/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Date;
import org.joda.time.DateTime;
import ru.alfastrah.ti.insurancealfaservice.Policy;

public class AlfastrahProductExistsKeyProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Policy policy = (Policy)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.POLICY);
        InsuranceTouristicIndex productIndex = this.searchExistProduct(policy);
        ctx.putObject((Enum)IbusAlfastrahContextKeys.PRODUCT_INDEX, (Object)productIndex);
        return productIndex != null ? productIndex.getStatus().name() : "NO";
    }

    private InsuranceTouristicIndex searchExistProduct(Policy policy) {
        SearchQuery query = new SearchQuery();
        query.setLimit(1);
        query.getPreferredProperties().add(InsuranceTouristicIndex.Property.status.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceTouristicIndex.Property.systemNumber.name(), (Object)policy.getCommon().getPolicyNumber()));
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getGdsNameSearchCriterionForInsuranceTouristicIndex((GdsName)GdsName.ALFASTRAH));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)InsuranceTouristicIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)InsuranceTouristicIndex.Property.status.name(), Arrays.asList(ProductStatus.SELL, ProductStatus.VOID)));
        if (policy.getCommon().getPlicyConfirmDate() != null) {
            Date createDate = MiscUtil.toDateWithoutTimeZone((DateTime)policy.getCommon().getPlicyConfirmDate());
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AeroexpressTicketIndex.Property.issueDate.name(), (Object)MiscUtil.addYearsToDate((Date)createDate, (int)-1)));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)AeroexpressTicketIndex.Property.issueDate.name(), (Object)MiscUtil.addYearsToDate((Date)createDate, (int)1)));
        }
        return (InsuranceTouristicIndex)CollectionUtil.head((Iterable)EntityStorage.get().search(InsuranceTouristicIndex.class, query).getData());
    }
}

