/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;

public class AlfastrahResolveProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        InsuranceTouristicIndex productIndex = (InsuranceTouristicIndex)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.PRODUCT_INDEX);
        EntityContainer bookingFile = EntityStorage.get().resolve(productIndex.getSource());
        Objects.requireNonNull(bookingFile, () -> "booking file " + productIndex.getSource() + " not found");
        InsuranceTouristic product = (InsuranceTouristic)BookingHelper.findProduct((BookingFile)((BookingFile)bookingFile.getEntity()), (String)productIndex.getNavigationKey(), InsuranceTouristic.class);
        Objects.requireNonNull(product, () -> "product with uid " + productIndex.getNavigationKey() + " not found");
        ctx.putObject((Enum)IbusAlfastrahContextKeys.BOOKING_FILE, (Object)bookingFile);
        ctx.putObject((Enum)IbusAlfastrahContextKeys.PRODUCT, (Object)product);
    }
}

