/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import org.joda.time.DateTime;
import ru.alfastrah.ti.insurancealfaservice.Common;
import ru.alfastrah.ti.insurancealfaservice.Policy;

public class AlfastrahUpdateProductCommonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Policy policy = (Policy)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.POLICY);
        InsuranceTouristic product = (InsuranceTouristic)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.PRODUCT);
        Common policyCommon = policy.getCommon();
        product.setTicketType(TicketType.OWN);
        product.setIssueDate(MiscUtil.toDateWithoutTimeZone((DateTime)policyCommon.getPlicyConfirmDate()));
        product.setSystemNumber(policyCommon.getPolicyNumber());
        product.setComments(TextUtil.nonBlank((String)policyCommon.getComments()) ? policyCommon.getComments() : null);
        product.setCountryName(policyCommon.getCountriesForPrint());
        product.setStartDate(MiscUtil.toDateWithoutTimeZone((DateTime)policyCommon.getPolicyPeriodFrom()));
        product.setEndDate(MiscUtil.toDateWithoutTimeZone((DateTime)policyCommon.getPolicyPeriodTill()));
        Money insuranceSum = policy.getRisks() != null && CollectionUtil.isNotEmpty((Collection)policy.getRisks().getRiskList()) ? (Money)policy.getRisks().getRiskList().stream().filter(risk -> !MiscUtil.isZero((BigDecimal)risk.getAmountAtRisk(), (boolean)true) && TextUtil.nonBlank((String)risk.getAmountCurrency())).map(risk -> MoneyHelper.buildMoney((BigDecimal)risk.getAmountAtRisk(), (String)risk.getAmountCurrency())).findFirst().orElse(null) : null;
        product.setInsuranceSum(insuranceSum);
    }
}

