/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.xtrip.common.model.AlfastrahSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import java.util.Date;
import org.joda.time.DateTime;
import ru.alfastrah.ti.insurancealfaservice.Policy;

public class AlfastrahUpdateSalesChainProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Policy policy = (Policy)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.POLICY);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.BOOKING_FILE);
        InsuranceTouristic product = (InsuranceTouristic)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.PRODUCT);
        AlfastrahSettings settings = (AlfastrahSettings)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.ALFASTRAH_SETTINGS);
        Reservation reservation = product.getReservation();
        GdsReferenceIndex referenceIndex = this.findAgent(policy);
        if (referenceIndex != null) {
            EntityReference agent = referenceIndex.getSource();
            EntityReference salesPoint = referenceIndex.getSalesPoint();
            product.setAgent(agent);
            if (salesPoint != null) {
                product.setSalesPoint(salesPoint);
            }
            if (reservation.getBookingAgent() == null) {
                reservation.setBookingAgent(agent);
            }
            if (reservation.getSalesPoint() == null) {
                reservation.setSalesPoint(salesPoint);
            }
        }
        if (settings.getAgency() != null) {
            InsuranceTouristicHelper.setAgency((InsuranceTouristic)product, (EntityReference)settings.getAgency());
            InsuranceTouristicHelper.setSubagency((InsuranceTouristic)product, (EntityReference)settings.getAgency());
            if (((BookingFile)bookingFile.getEntity()).getAgency() == null) {
                ((BookingFile)bookingFile.getEntity()).setAgency(settings.getAgency());
            }
        }
        if (settings.getSupplier() != null) {
            InsuranceTouristicHelper.setSupplier((InsuranceTouristic)product, (EntityReference)settings.getSupplier());
            product.setBlankOwner(settings.getSupplier());
        }
    }

    private GdsReferenceIndex findAgent(Policy policy) {
        if (TextUtil.isBlank((String)policy.getCommon().getUsersLogin())) {
            return null;
        }
        SearchQuery query = ProfileDao.createQueryAgentByGdsName((GdsName)GdsName.ALFASTRAH, (String)policy.getCommon().getUsersLogin(), (Date)MiscUtil.toDateWithoutTimeZone((DateTime)policy.getCommon().getDtCreated()));
        return (GdsReferenceIndex)CollectionUtil.head((Iterable)EntityStorage.get().search(GdsReferenceIndex.class, query).getData());
    }
}

