/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.autocancel;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.autocancel.IbecorpAutocancelHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Collection;
import java.util.Set;

public class IbecorpAutocancelAfterCancelProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservations = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        Set yetCancelledProductUids = (Set)ctx.getMandatoryObject("IBECORP_AUTOCANCEL_YET_CANCELLED_PRODUCT_UIDS");
        boolean neededSave = false;
        for (Reservation reservation : MidofficeHelper.getReservations((EntityContainer)bookingFileContainer, (Collection)reservations)) {
            if (CommonIbecorpHelper.getReservationStatus((Reservation)reservation) != ReservationStatus.CANCELED) {
                reservation.setFailedCancelling(true);
                neededSave = true;
                if (reservation.getProducts().stream().filter(pr -> !yetCancelledProductUids.contains(pr.getUid())).map(GeneralProductHelper::getStatus).noneMatch(IbecorpAutocancelHelper.CANCEL_PRODUCT_STATUSES::contains)) continue;
            }
            try {
                EntityReference bookingRef = bookingFileContainer.toReference();
                NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile(), (EntityReference<SMSite>)((BookingFile)bookingFileContainer.getEntity()).getSite(), ((BookingFile)bookingFileContainer.getEntity()).getCustomer().getPreferredLocale(), bookingRef, SalesContextHandler.get().createSalesContext(reservation));
                NotificationHelper.sendNotification(() -> NotificationHelper.getCancelReservationNotification(parameters, reservation), bookingRef, true);
            }
            catch (Exception e) {
                String exceptionStackTrace = ExceptionUtil.getExceptionStackTrace((Throwable)e);
                Message warnMessage = MessageHelper.createWarningMessage((String)("Reservation cancelled notification sending failed, pnr " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)), (String)exceptionStackTrace, (Object[])new Object[0]);
                SysLogHelper.audit((EntityReference)bookingFileContainer.toReference(), (String)"booking-auto-cancellation", (Message[])new Message[]{warnMessage});
                this.log.warn("Reservation cancelled notification wasn't send:\n" + exceptionStackTrace);
            }
        }
        if (neededSave) {
            bookingFileContainer.getVersionInfo().setDataSource("failed-cancelling");
            bookingFileContainer.getVersionInfo().setVersionNotes("some reservations have the status not canceled");
            EntityStorage.get().save(bookingFileContainer, true);
        }
    }
}

