/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.autocancel;

import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.storage.IbeCorpBookingFileIndexRegistryHandler;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class IbecorpAutocancelBookingFileIndexProvider
extends BaseTargetsProvider<BookingFileIndex> {
    public Collection<BookingFileIndex> getTargets(MessageContext ctx) throws Exception {
        Date nextFireTime = (Date)ctx.getMandatoryObject("nextFireTime");
        this.log.debug("started auto-cancellation task");
        this.log.debug("starting to cancel expiring bookings");
        SearchQuery sq = IbecorpAutocancelBookingFileIndexProvider.buildQuery(nextFireTime);
        List data = EntityStorage.get().search(BookingFileIndex.class, sq).getData();
        data.sort(Comparator.comparing(BookingFileIndex::getTimelimit));
        this.log.debug(String.format("%s bookings found for cancellation", data.size()));
        return data;
    }

    private static SearchQuery buildQuery(Date nextFireTime) {
        SearchQuery sq = new SearchQuery();
        List criteria = sq.getCriteria().getCriterions();
        criteria.add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])IbeCorpBookingFileIndexRegistryHandler.TIME_LIMIT_RESERVATION_STATUSES.stream().map(resStatus -> SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)resStatus)).toArray(SearchCriterion[]::new))));
        criteria.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.failedCancelling.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)BookingFileIndex.Property.failedCancelling.name(), null)}));
        criteria.add(SearchCriterion.le((String)BookingFileIndex.Property.timelimit.name(), (Object)nextFireTime));
        criteria.add(SearchCriterion.gt((String)BookingFileIndex.Property.timelimit.name(), (Object)MiscUtil.addDaysToDate((Date)nextFireTime, (int)-7)));
        return sq;
    }
}

