/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.autocancel;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.notifications.ReservationFailedCancellingNotificationHepler;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.ArrayList;
import java.util.Collection;

public class IbecorpAutocancelHandleExceptionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        Throwable ex = callback.getException();
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        IncidentsLog.reportException((String)String.format("failed cancelling booking %s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()))), (Throwable)ex);
        this.log.error(String.format("failed cancelling booking %s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()))), ex);
        try {
            SysLogHelper.audit((EntityReference)bookingFileContainer.toReference(), (String)"failed-cancelling", (Message[])new Message[]{MessageHelper.createExceptonMessage((String)"failed-cancelling", (Throwable)ex, (Object[])new Object[0])});
            ArrayList<Reservation> errors = new ArrayList<Reservation>();
            Collection reservations = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
            errors.addAll(MidofficeHelper.getReservations((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (Collection)reservations));
            errors.removeIf(r -> CommonIbecorpHelper.getReservationStatus((Reservation)r) == ReservationStatus.CANCELED);
            errors.forEach(r -> r.setFailedCancelling(true));
            bookingFileContainer.getVersionInfo().setDataSource("failed-cancelling");
            bookingFileContainer = EntityStorage.get().save(bookingFileContainer, true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
            this.log.warn(String.format("booking %s is marked as failed cancelled, sending email", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()))));
            for (Reservation reservation : errors) {
                MidofficeHelper.sendCustomerEmail((String)ReservationFailedCancellingNotificationHepler.buildFailedCancellingReservationEmailSubject((EntityReference<SMSite>)((BookingFile)bookingFileContainer.getEntity()).getSite(), reservation), (String)ReservationFailedCancellingNotificationHepler.buildFailedCancellingReservationEmailBody((EntityReference<SMSite>)((BookingFile)bookingFileContainer.getEntity()).getSite(), reservation), (String)ReservationFailedCancellingNotificationHepler.getRecipient(), null, (boolean)false);
            }
            this.log.warn(String.format("the failed cancelling email of booking %s is send ", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()))));
        }
        catch (Exception exp) {
            IncidentsLog.reportException((String)String.format("failed adding a cancelling propertry booking %s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()))), (Throwable)exp);
            this.log.error(String.format("failed adding a cancelling propertry booking %s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()))), (Throwable)exp);
        }
        callback.exceptionHandled(true);
    }
}

