/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.autocancel;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.storage.IbeCorpBookingFileIndexRegistryHandler;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class IbecorpAutocancelReservationGroupProvider
extends BaseTargetsProvider<Map.Entry<SalesContext, Collection<Reservation>>> {
    public Collection<Map.Entry<SalesContext, Collection<Reservation>>> getTargets(MessageContext ctx) throws Exception {
        BookingFileIndex index = (BookingFileIndex)ctx.getMandatoryObject("BOOKING_FILE_INDEX");
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        Collection reservations = bookingFile.getReservations().stream().filter(res -> IbeCorpBookingFileIndexRegistryHandler.TIME_LIMIT_RESERVATION_STATUSES.contains(CommonIbecorpHelper.getReservationStatus((Reservation)res))).filter(res -> !res.isFailedCancelling()).filter(ReservationGdsNameInfoHelper::containsOnlineRecordLocatorOfAnyType).filter(res -> MiscUtil.compare((Date)res.getTimeLimit(), (Date)index.getTimelimit()) <= 0).collect(Collectors.toList());
        this.log.debug(String.format("starting auto-cancellation of booking [%s]", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()))));
        LinkedHashMap map = new LinkedHashMap();
        for (Reservation reservation : reservations) {
            SalesContext salesContext = SalesContextHandler.get().createSalesContext(reservation);
            map.entrySet().stream().filter(e -> Objects.equals(((SalesContext)e.getKey()).getSalesPoint(), salesContext.getSalesPoint())).map(Map.Entry::getValue).findFirst().orElseGet(() -> {
                ArrayList list = new ArrayList();
                map.put(salesContext, list);
                return list;
            }).add(reservation);
        }
        return map.entrySet();
    }
}

