/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.checkTicketing;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingFileReferenceProvider
extends BaseTargetsProvider<EntityReference<BookingFile>> {
    public Collection<EntityReference<BookingFile>> getTargets(MessageContext ctx) throws Exception {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.reservationStatus.name(), (Object)ReservationStatus.IN_PROCESS_OF_TICKETING));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)ProductIndex.Property.reservationDate.name(), (Object)Date.from(Instant.now().minus(3L, ChronoUnit.HOURS))));
        searchQuery.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductIndex((GdsName)GdsName.SU_NDC));
        searchQuery.getPreferredProperties().add(ProductIndex.Property.reservationUid.name());
        Set<EntityReference<BookingFile>> refs = EntityStorage.get().search(ProductIndex.class, searchQuery).getData().stream().map(ProductIndex::getSource).collect(Collectors.toSet());
        this.log.info("processing booking files {}", (Object)refs.stream().map(EntityReference::getUid).collect(Collectors.joining(",")));
        return refs;
    }
}

