/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.compatibility;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.AuthorizationActionType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization.AuthSendHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Locale;

public class IbeCorpSendTicketingNotificationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservations = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        boolean wasCheckBalanceException = Boolean.TRUE.equals(ctx.getObject((Enum)IBusAuthorizationContextKeys.AUTHORIZATION_CHECK_BALANCE_EXCEPTION));
        BookingFile bf = (BookingFile)bfCtr.getEntity();
        Locale locale = null;
        if (bf.getCustomer() != null) {
            locale = bf.getCustomer().getPreferredLocale();
        }
        if (locale == null) {
            locale = LocaleManager.get().getCurrentLocale();
        }
        for (Reservation reservation : NotificationHelper.getReservations((EntityContainer<BookingFile>)bfCtr, reservations)) {
            EntityContainer site;
            if (wasCheckBalanceException) {
                AuthSendHelper.sendMailToRecipients(AuthorizationActionType.AUTHORIZATION_NOT_ENOUGH_FUNDS, reservation, (EntityReference<BookingFile>)bfCtr.toReference(), null, "insufficient_funds", TravelPolicyAuthorizationHelper.findPricingDelta((Reservation)reservation));
                continue;
            }
            ReservationStatus reservationStatus = CommonIbecorpHelper.getReservationStatus((Reservation)reservation);
            if (reservationStatus != ReservationStatus.ISSUED) {
                if (reservationStatus != ReservationStatus.ERROR) continue;
                AuthSendHelper.sendMailToRecipients(AuthorizationActionType.AUTHORIZATION_TICKET_ERROR, reservation, (EntityReference<BookingFile>)bfCtr.toReference(), null, "error_autoticketing", TravelPolicyAuthorizationHelper.findPricingDelta((Reservation)reservation));
                continue;
            }
            boolean hasCashFop = reservation.getProducts().stream().flatMap(bp -> GeneralProductHelper.getClientFops((BaseProduct)bp).stream()).map(Fop::getType).anyMatch(type -> type == PaymentType.CASH || type == PaymentType.CASH_DELIVERY);
            if (hasCashFop && (site = EntityStorage.get().resolve(siteRef)) != null && ((SMSite)site.getEntity()).getSiteType() == SMSiteType.B2C) continue;
            NotificationHelper.sendServicesIssuedNotification((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)((BookingFile)bfCtr.getEntity()).getCustomerProfile(), locale, reservation, bfCtr.toReference());
        }
    }
}

