/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.FiscalReceiptCalculatedDataHolder;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.registration.AtolRegistrationRequestBuilder;
import com.gridnine.xtrip.server.kkt.atol.model.RegistrationRQ;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.stream.Collectors;

public class AtolRegistrationRequestBuilderInjection
extends AtolRegistrationRequestBuilder {
    protected RegistrationRQ.Receipt buildReceipt(ReceiptData receiptData, AtolSettings atolSettings) {
        RegistrationRQ.Receipt result = new RegistrationRQ.Receipt();
        FiscalReceiptCalculatedDataHolder fiscalDataHolder = new FiscalReceiptCalculatedDataHolder(receiptData);
        result.setClient(this.buildClient(receiptData));
        result.setCompany(this.buildCompany(atolSettings));
        result.getPayments().addAll(fiscalDataHolder.getPaymentsMap().entrySet().stream().map(entry -> this.buildPayment((PaymentType)entry.getKey(), (BigDecimal)entry.getValue())).collect(Collectors.toList()));
        this.addItems(result, fiscalDataHolder.getReceiptLines());
        return result;
    }

    protected RegistrationRQ.Client buildClient(ReceiptData data) {
        String clientEmail = data.getClentEmail();
        if (TextUtil.isBlank((String)clientEmail)) {
            throw Xeption.forEndUser((String)"\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d email", (Object[])new Object[0]);
        }
        RegistrationRQ.Client result = new RegistrationRQ.Client();
        if (Objects.nonNull(data.getClient())) {
            EntityContainer clientCtr = EntityStorageHelper.resolve((EntityReference)data.getClient());
            if (clientCtr == null || clientCtr.getEntity() == null) {
                throw Xeption.forEndUser((String)"\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f-\u043a\u043b\u0438\u0435\u043d\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u0430!", (Object[])new Object[0]);
            }
            result.setName(((Organization)clientCtr.getEntity()).getFullName().toString());
            String registrationId = ((Organization)clientCtr.getEntity()).getRegistrationId();
            result.setInn(registrationId);
        }
        result.setEmail(clientEmail);
        return result;
    }

    private RegistrationRQ.ReceiptPayment buildPayment(PaymentType paymentType, BigDecimal amount) {
        RegistrationRQ.ReceiptPayment result = new RegistrationRQ.ReceiptPayment();
        result.setType(AtolHelper.convertPaymentTypeToGds((PaymentType)paymentType));
        result.setSum(amount);
        return result;
    }
}

