/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.ibecorp.ibus.fiscal.OnlineReceiptHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FillReceiptOnlineDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        EntityContainer<AtolSettings> atolSettings = (EntityContainer<AtolSettings>)ctx.getObject((Enum)IBusKktAtolContextKeys.ATOL_SETTINGS);
        Payment payment = (Payment)ctx.getObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        if (atolSettings == null) {
            EntityStorageContext storageContext = new EntityStorageContext();
            Set<Reservation> reservations = ((Receipt)receiptContainer.getEntity()).getReceiptData().getItems().stream().map(ReceiptLine::getProductReference).distinct().map(product -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)product, (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(BaseProduct::getReservation).collect(Collectors.toSet());
            atolSettings = OnlineReceiptHelper.findAtolSettings(reservations);
        }
        Receipt receipt = (Receipt)receiptContainer.getEntity();
        receipt.setRegistrationDate(new Date());
        receipt.setAtolSettings(atolSettings.toReference());
        if (payment != null) {
            receipt.setPaymentId(payment.getPaymentId());
            receipt.setDescription(payment.getDescription());
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.RECEIPT, (Object)receiptContainer);
    }
}

