/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal;

import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.ReceiptIndex;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FindReceiptsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ReceiptIndex.Property.paymentId.name(), (Object)payment.getPaymentId()));
        SearchResult searchResult = EntityStorage.get().search(ReceiptIndex.class, query);
        if (EntityStorageHelper.nonEmpty((SearchResult)searchResult)) {
            List receipts = searchResult.getData().stream().map(receiptIndex -> EntityStorage.get().resolve(receiptIndex.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
            ctx.putObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS, receipts);
        }
    }
}

