/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal;

import com.gridnine.xtrip.common.kkt.atol.AtolCommonHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class OnlineReceiptHelper {
    public static String getEmail(EntityContainer<BookingFile> bookingFile) {
        if (((BookingFile)bookingFile.getEntity()).getCustomer() == null) {
            return null;
        }
        return ProfileHelper.filterCommunications((Collection)((BookingFile)bookingFile.getEntity()).getCustomer().getCommunications(), Collections.singleton(CommunicationType.EMAIL)).stream().map(Communication::getSense).filter(TextUtil::nonBlank).findFirst().orElse(null);
    }

    public static Double getAgencyVatRate(EntityReference<Organization> agencyRef) {
        EntityContainer organizationEntityContainer = EntityStorage.get().resolve(agencyRef);
        HistoricalValue vatPayerValue = HistoricalValueHelper.getHistoricalValue((List)((Organization)organizationEntityContainer.getEntity()).getVatPayerHistory(), (Date)new Date());
        if (vatPayerValue == null || ((Boolean)vatPayerValue.getValue()).equals(Boolean.FALSE)) {
            return null;
        }
        return DictHelper.getDefaultVat().doubleValue();
    }

    public static EntityContainer<AtolSettings> findAtolSettings(Collection<Reservation> reservations) {
        List atolSettings = AtolCommonHelper.findSettingsByReservations(reservations);
        if (atolSettings.size() > 1) {
            throw Xeption.forAdmin((String)("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043e\u0434\u043d\u043e\u0439 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0410\u0422\u041e\u041b \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 " + reservations.stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.joining(", "))), (Object[])new Object[0]);
        }
        return (EntityContainer)CollectionUtil.head((Iterable)atolSettings);
    }
}

