/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.fiscal.OnlineReceiptHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PrepareDataForReceiptCreationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        List productsToPrint = (List)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.SELECTED_PRODUCTS);
        String clientEmail = Objects.requireNonNull(OnlineReceiptHelper.getEmail((EntityContainer<BookingFile>)bookingFile), "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 email \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 " + bookingFile.getEntity());
        Map<NestedEntityReference, List> mapProductsToPayReference = productsToPrint.stream().collect(Collectors.toMap(product -> new NestedEntityReference(bookingFile, (BaseEntity)product), product -> GeneralProductHelper.getUnmodifiableFops((BaseProduct)product, (ContractType)ContractType.CLIENT).stream().map(fop -> new NestedEntityReference(bookingFile.toReference(), fop.getUid(), Fop.class, null)).collect(Collectors.toList())));
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.PRODUCTS_TO_PAY_REFERENCE, mapProductsToPayReference);
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_SERVICE_TYPE, (Object)ReceiptServiceType.ATOL_ONLINE);
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.CLIENT_ADDRESS, (Object)clientEmail);
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.MESSAGE, new ArrayList());
    }
}

