/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.kkt.atol.model.ReceiptObject;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.ReceiptLinkNotification;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SendReceiptLinkProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer receipt = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        SalesContext salesContext = (SalesContext)ctx.getObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer<BookingFile> bookingFile = (EntityContainer<BookingFile>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        if (!AtolHelper.isDownloadable((ReceiptObject)((Receipt)receipt.getEntity()).getReceiptObject())) {
            ((Receipt)receipt.getEntity()).getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0447\u0435\u043a: \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445", (Object[])new Object[0]));
            return;
        }
        if (((Receipt)receipt.getEntity()).getReceiptData() == null || TextUtil.isBlank((String)((Receipt)receipt.getEntity()).getReceiptData().getClentEmail())) {
            ((Receipt)receipt.getEntity()).getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0447\u0435\u043a: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 email", (Object[])new Object[0]));
            return;
        }
        String link = AtolHelper.toLkUrl((ReceiptObject)((Receipt)receipt.getEntity()).getReceiptObject());
        EntityStorageContext entityStorageContext = new EntityStorageContext();
        if (bookingFile == null) {
            bookingFile = this.getBookingFile((EntityContainer<Receipt>)receipt, entityStorageContext);
        }
        EntityReference<Organization> subagency = salesContext != null && salesContext.getSubagency() != null ? salesContext.getSubagency() : this.getSubagency(bookingFile, (EntityContainer<Receipt>)receipt, entityStorageContext);
        BookingFile booking = (BookingFile)bookingFile.getEntity();
        EntityReference bookingRef = bookingFile.toReference();
        NotificationParameters parameters = new NotificationParameters(subagency, (EntityReference<Organization>)booking.getCustomerProfile(), (EntityReference<SMSite>)booking.getSite(), LocaleHelper.getCurrentLocale(), bookingRef, salesContext);
        NotificationHelper.sendNotification(() -> new ReceiptLinkNotification(parameters, ((Receipt)receipt.getEntity()).getReceiptData().getClentEmail(), link, booking), bookingRef, true);
    }

    private EntityContainer<BookingFile> getBookingFile(EntityContainer<Receipt> receipt, EntityStorageContext entityStorageContext) {
        EntityReference bookingRef = ((Receipt)receipt.getEntity()).getOwner();
        if (bookingRef == null) {
            throw Xeption.forDeveloper((String)("No booking file reference found in receipt " + receipt.toReference()), (Object[])new Object[0]);
        }
        EntityContainer bookingFile = EntityStorageHelper.resolve((EntityReference)bookingRef, (EntityStorageContext)entityStorageContext);
        if (bookingFile == null) {
            throw Xeption.forDeveloper((String)("Unable to resolve booking file " + bookingRef), (Object[])new Object[0]);
        }
        return bookingFile;
    }

    private EntityReference<Organization> getSubagency(EntityContainer<BookingFile> bookingFile, EntityContainer<Receipt> receipt, EntityStorageContext entityStorageContext) {
        List subagencies = ((Receipt)receipt.getEntity()).getReceiptData().getItems().stream().map(ReceiptLine::getProductReference).distinct().filter(ref -> bookingFile.getUid().equals(ref.getUid())).map(ref -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)ref, (EntityStorageContext)entityStorageContext)).filter(Objects::nonNull).map(BaseProduct::getReservation).filter(Objects::nonNull).map(Reservation::getSubagency).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return (EntityReference)CollectionUtil.head(subagencies);
    }
}

