/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.PaymentData;
import com.gridnine.xtrip.common.model.fiscal.PaymentMethod;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptStatus;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.fiscal.OnlineReceiptHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.fiscal.rail.RailReceiptLineBuilder;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateRailReceiptProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        List productsToPrint = (List)ctx.getMandatoryObject((Enum)IBusFiscalReceiptContextKeys.SELECTED_PRODUCTS);
        EntityContainer atolSettings = (EntityContainer)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.ATOL_SETTINGS);
        List<EntityContainer<Receipt>> receipts = this.createReceipts((EntityContainer<BookingFile>)bookingFile, payment, productsToPrint, (EntityContainer<AtolSettings>)atolSettings);
        ctx.putObject((Enum)IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS, receipts);
    }

    private List<EntityContainer<Receipt>> createReceipts(EntityContainer<BookingFile> bookingFile, Payment payment, List<BaseProduct> products, EntityContainer<AtolSettings> atolSettings) {
        ArrayList<EntityContainer<Receipt>> result = new ArrayList<EntityContainer<Receipt>>();
        HashMap receiptLinesMap = new HashMap();
        Double agencyVatRate = OnlineReceiptHelper.getAgencyVatRate((EntityReference<Organization>)BookingHelper.getSubagency((BookingFile)((BookingFile)bookingFile.getEntity())));
        String clientEmail = OnlineReceiptHelper.getEmail(bookingFile);
        if (TextUtil.isBlank((String)clientEmail)) {
            throw Xeption.forAdmin((String)("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 email \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 " + bookingFile.getEntity()), (Object[])new Object[0]);
        }
        products.forEach(product -> this.fillReceiptLinesMap((RailwayProduct)product, bookingFile, agencyVatRate, receiptLinesMap));
        for (Map.Entry entry : receiptLinesMap.entrySet()) {
            ArrayList receiptLines = new ArrayList();
            Map<ReceiptLineType, List<ReceiptLine>> receiptLineTypeMap = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(ReceiptLine::getLineType));
            receiptLineTypeMap.forEach((type, lines) -> {
                if (type == ReceiptLineType.FEES || type == ReceiptLineType.REFUNDABLE_FEES) {
                    receiptLines.add(lines.stream().reduce((l1, l2) -> {
                        l1.setPrice(l1.getPrice().add(l2.getPrice()));
                        l1.setTotal(l1.getTotal().add(l2.getTotal()));
                        return l1;
                    }).orElseThrow(IllegalArgumentException::new));
                } else {
                    receiptLines.addAll(lines);
                }
            });
            PaymentData paymentData = new PaymentData();
            paymentData.setType(PaymentType.ELECTRONIC);
            paymentData.setAmount(receiptLines.stream().map(ReceiptLine::getTotal).reduce(BigDecimal::add).orElseThrow(IllegalArgumentException::new));
            ReceiptData receiptData = this.createReceiptData(payment, (ReceiptType)entry.getKey(), clientEmail);
            receiptData.getItems().addAll(receiptLines);
            receiptData.getPayments().add(paymentData);
            Receipt receipt = this.createReceipt(payment, (EntityReference<BookingFile>)bookingFile.toReference(), (EntityReference<AtolSettings>)atolSettings.toReference());
            receipt.setReceiptData(receiptData);
            receipt.getProducts().clear();
            receipt.getProducts().addAll(products.stream().map(product -> new NestedEntityReference(bookingFile, (BaseEntity)product, BookingHelper.generateShortProductName((BaseProduct)product))).collect(Collectors.toList()));
            result.add((EntityContainer<Receipt>)EntityContainer.create((BaseEntity)receipt));
        }
        return result;
    }

    private Receipt createReceipt(Payment payment, EntityReference<BookingFile> bookingRef, EntityReference<AtolSettings> atolSettingsRef) {
        Receipt receipt = new Receipt();
        Date now = new Date();
        receipt.setCreated(now);
        receipt.setUpdated(now);
        receipt.setRegistrationDate(now);
        receipt.setPaymentId(payment.getPaymentId());
        receipt.setOwner(bookingRef);
        receipt.setStatus(ReceiptStatus.NEW);
        receipt.setServiceType(ReceiptServiceType.ATOL_ONLINE);
        receipt.setAtolSettings(atolSettingsRef);
        receipt.setDescription(payment.getDescription());
        return receipt;
    }

    private ReceiptData createReceiptData(Payment payment, ReceiptType receiptType, String email) {
        ReceiptData result = new ReceiptData();
        result.setAgency(payment.getPayee());
        result.setClient(payment.getPayer());
        result.setType(receiptType);
        result.setClentEmail(email);
        return result;
    }

    private void fillReceiptLinesMap(RailwayProduct product, EntityContainer<BookingFile> bookingFile, Double agencyVatRate, Map<ReceiptType, List<ReceiptLine>> receiptLineMap) {
        String lineNamePattern = String.format("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 %s ", product.getSystemNumber());
        NestedEntityReference productReference = new NestedEntityReference(bookingFile, (BaseEntity)product);
        Date now = new Date();
        Principal principal = (Principal)Objects.requireNonNull(DictionaryCache.get().resolveReference(product.getCarrier()), String.format("Failed to create receipt for payment. Missing principal in rail product [%s].", product.getSystemNumber()));
        Collection feesFops = GeneralProductHelper.filterFops((Collection)GeneralProductHelper.getClientFops((BaseProduct)product), (Set)GeneralProductHelper.feeFopTypes, null, null);
        BigDecimal fees = BigDecimal.ZERO;
        BigDecimal refundedFees = BigDecimal.ZERO;
        for (GeneralProductFop fop : feesFops) {
            BigDecimal amount = fop.getEquivalentAmount();
            if (product.getStatus() == ProductStatus.REFUND) {
                if (MiscUtil.isNegative((BigDecimal)amount)) {
                    fees = fees.add(amount.abs());
                    continue;
                }
                refundedFees = refundedFees.add(amount);
                continue;
            }
            fees = fees.add(amount);
        }
        BigDecimal fareAmount = MiscUtil.guarded((BigDecimal)product.getEquivalentFare());
        BigDecimal serviceAmount = MiscUtil.guarded((BigDecimal)product.getServiceFare());
        BigDecimal penalty = MiscUtil.guarded((BigDecimal)product.getPenalty());
        BigDecimal reservedSeatsAmount = product.getReservedSeats().stream().filter(Objects::nonNull).map(reservedSeat -> MiscUtil.sub((BigDecimal)reservedSeat.getEquivalentFare(), (BigDecimal[])new BigDecimal[]{reservedSeat.getEquivalentDeduction()})).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        ReceiptLine fareLine = new RailReceiptLineBuilder(ReceiptLineType.PRODUCT).setAmount(fareAmount.subtract(reservedSeatsAmount)).setVatRate(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)now)).setPrintName(lineNamePattern + "\u0422\u0410\u0420\u0418\u0424 \u0411\u0418\u041b\u0415\u0422\u0410 \u0420\u0416\u0414").setSupplier(principal).setProductReference((NestedEntityReference<BookingFile, BaseProduct>)productReference).setPaymentMethod(PaymentMethod.FULL_PREPAYMENT).build();
        receiptLineMap.computeIfAbsent(this.calcReceiptType(product, fareLine), k -> new ArrayList()).add(fareLine);
        if (MiscUtil.compare((Comparable)reservedSeatsAmount, (Comparable)BigDecimal.ZERO) == 1) {
            ReceiptLine reservedSeatLine = new RailReceiptLineBuilder(ReceiptLineType.PRODUCT).setAmount(reservedSeatsAmount).setVatRate(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)now)).setPrintName(lineNamePattern + "\u0422\u0410\u0420\u0418\u0424 \u041f\u041b\u0410\u0426\u041a\u0410\u0420\u0422\u042b").setSupplier(principal).setProductReference((NestedEntityReference<BookingFile, BaseProduct>)productReference).setPaymentMethod(PaymentMethod.FULL_PREPAYMENT).build();
            receiptLineMap.computeIfAbsent(this.calcReceiptType(product, reservedSeatLine), k -> new ArrayList()).add(reservedSeatLine);
        }
        if (MiscUtil.compare((Comparable)serviceAmount, (Comparable)BigDecimal.ZERO) == 1) {
            ReceiptLine serviceLine = new RailReceiptLineBuilder(ReceiptLineType.SERVICE).setAmount(serviceAmount).setVatRate(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)now)).setVatAmount(product.getServiceVAT()).setPrintName(lineNamePattern + "\u0421\u0415\u0420\u0412\u0418\u0421").setSupplier(principal).setProductReference((NestedEntityReference<BookingFile, BaseProduct>)productReference).setPaymentMethod(PaymentMethod.FULL_PREPAYMENT).build();
            receiptLineMap.computeIfAbsent(this.calcReceiptType(product, serviceLine), k -> new ArrayList()).add(serviceLine);
        }
        if (MiscUtil.compare((Comparable)penalty, (Comparable)BigDecimal.ZERO) == 1) {
            ReceiptLine penaltyLine = new RailReceiptLineBuilder(ReceiptLineType.PENALTY).setAmount(penalty).setVatRate(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)now)).setVatAmount(product.getPenaltyVAT()).setPrintName(lineNamePattern + "\u0421\u0411\u041e\u0420 \u0417\u0410 \u0412\u041e\u0417\u0412\u0420\u0410\u0422").setSupplier(principal).setProductReference((NestedEntityReference<BookingFile, BaseProduct>)productReference).setPaymentMethod(PaymentMethod.FULL_PREPAYMENT).build();
            receiptLineMap.computeIfAbsent(this.calcReceiptType(product, penaltyLine), k -> new ArrayList()).add(penaltyLine);
        }
        if (MiscUtil.compare((Comparable)fees, (Comparable)BigDecimal.ZERO) == 1) {
            ReceiptLine feesLine = new RailReceiptLineBuilder(ReceiptLineType.FEES).setAmount(fees).setVatRate(agencyVatRate).setPrintName("\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0441\u0431\u043e\u0440").setProductReference((NestedEntityReference<BookingFile, BaseProduct>)productReference).setPaymentMethod(PaymentMethod.FULL_PAYMENT).build();
            receiptLineMap.computeIfAbsent(this.calcReceiptType(product, feesLine), k -> new ArrayList()).add(feesLine);
        }
        if (MiscUtil.compare((Comparable)refundedFees, (Comparable)BigDecimal.ZERO) == 1) {
            ReceiptLine refundableFeesLine = new RailReceiptLineBuilder(ReceiptLineType.REFUNDABLE_FEES).setAmount(refundedFees.abs()).setVatRate(agencyVatRate).setPrintName("\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0441\u0431\u043e\u0440").setProductReference((NestedEntityReference<BookingFile, BaseProduct>)productReference).setPaymentMethod(PaymentMethod.FULL_PAYMENT).build();
            receiptLineMap.computeIfAbsent(this.calcReceiptType(product, refundableFeesLine), k -> new ArrayList()).add(refundableFeesLine);
        }
    }

    private ReceiptType calcReceiptType(RailwayProduct product, ReceiptLine line) {
        if (product.getStatus() == ProductStatus.REFUND) {
            if (line.getLineType() == ReceiptLineType.PENALTY || line.getLineType() == ReceiptLineType.FEES) {
                return ReceiptType.SELL;
            }
            return ReceiptType.SELL_REFUND;
        }
        return ReceiptType.SELL;
    }
}

