/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.fiscal.rail;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.fiscal.PaymentMethod;
import com.gridnine.xtrip.common.model.fiscal.PaymentObject;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineSellType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptVatType;
import com.gridnine.xtrip.common.model.fiscal.Supplier;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;

class RailReceiptLineBuilder {
    private final ReceiptLine receiptLine = new ReceiptLine();

    RailReceiptLineBuilder(ReceiptLineType lineType) {
        this.receiptLine.setQuantity(BigDecimal.ONE);
        this.receiptLine.setPaymentObject(PaymentObject.SERVICE);
        this.receiptLine.setPaymentType(PaymentType.ELECTRONIC);
        this.receiptLine.setLineType(lineType);
    }

    RailReceiptLineBuilder setAmount(BigDecimal amount) {
        this.receiptLine.setPrice(MiscUtil.guarded((BigDecimal)amount));
        this.receiptLine.setTotal(MiscUtil.guarded((BigDecimal)amount));
        return this;
    }

    RailReceiptLineBuilder setPrintName(String printName) {
        this.receiptLine.setPrintName(printName);
        return this;
    }

    RailReceiptLineBuilder setVatRate(Double rate) {
        this.receiptLine.setVatType(this.convertVatRate(rate));
        return this;
    }

    RailReceiptLineBuilder setVatAmount(BigDecimal vatAmount) {
        this.receiptLine.setVatAmount(vatAmount);
        return this;
    }

    RailReceiptLineBuilder setPaymentMethod(PaymentMethod paymentMethod) {
        this.receiptLine.setPaymentMethod(paymentMethod);
        return this;
    }

    RailReceiptLineBuilder setProductReference(NestedEntityReference<BookingFile, BaseProduct> productReference) {
        this.receiptLine.setProductReference(productReference);
        return this;
    }

    RailReceiptLineBuilder setSupplier(Principal principal) {
        if (principal != null) {
            Supplier supplier = new Supplier();
            supplier.setName((String)MiscUtil.findByLocale((Map)principal.getTranslations(), (Locale)LocaleUtil.LOCALE_RU));
            supplier.setINN(principal.getRegistrationId());
            supplier.setPhoneNum(principal.getPhone());
            this.receiptLine.setSupplier(supplier);
            this.receiptLine.setSellType(ReceiptLineSellType.AGENT);
        } else {
            this.receiptLine.setSellType(ReceiptLineSellType.OWN);
        }
        return this;
    }

    ReceiptLine build() {
        return this.receiptLine;
    }

    private ReceiptVatType convertVatRate(Double vatRate) {
        if (vatRate == null) {
            return ReceiptVatType.NONE;
        }
        if (Double.compare(vatRate, 0.0) == 0) {
            return ReceiptVatType.VAT_0;
        }
        if (Double.compare(vatRate, 5.0) == 0) {
            return ReceiptVatType.VAT_5;
        }
        if (Double.compare(vatRate, 7.0) == 0) {
            return ReceiptVatType.VAT_7;
        }
        if (Double.compare(vatRate, 10.0) == 0) {
            return ReceiptVatType.VAT_10;
        }
        if (Double.compare(vatRate, 18.0) == 0) {
            return ReceiptVatType.VAT_18;
        }
        if (Double.compare(vatRate, 20.0) == 0) {
            return ReceiptVatType.VAT_20;
        }
        throw Xeption.forDeveloper((String)("Unsupported vat rate: " + vatRate), (Object[])new Object[0]);
    }
}

