/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds;

import com.gridnine.xtrip.common.gds.exceptions.CannotCancelIssuedException;
import com.gridnine.xtrip.common.gds.exceptions.NoSegmentsInBookingException;
import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Map;

public class IbeCorpCheckBookingExceptionHandlerProvider
extends BaseRoutingKeyProvider {
    private static final Map<String, ReservationStatus> HANDLED_EXCEPTIONS_STATUSES = new HashMap<String, ReservationStatus>();

    public String getRoutingKey(MessageContext ctx) throws Exception {
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        return this.lookForException(callback.getException());
    }

    private String lookForException(Throwable exception) {
        MulticallException me;
        if (HANDLED_EXCEPTIONS_STATUSES.keySet().contains(exception.getClass().getName())) {
            return HANDLED_EXCEPTIONS_STATUSES.get(exception.getClass().getName()).name();
        }
        if (exception instanceof MulticallException && (me = (MulticallException)exception).getSubrouteExceptions().values().size() == 1) {
            return this.lookForException((Throwable)me.getSubrouteExceptions().values().iterator().next());
        }
        if (exception.getCause() == null) {
            return "";
        }
        return this.lookForException(exception.getCause());
    }

    static {
        if (Boolean.parseBoolean(System.getProperty(IbeCorpCheckBookingExceptionHandlerProvider.class.getName() + "." + CannotCancelIssuedException.class.getSimpleName() + ".enabled"))) {
            HANDLED_EXCEPTIONS_STATUSES.put(CannotCancelIssuedException.class.getName(), ReservationStatus.ISSUED);
        }
        HANDLED_EXCEPTIONS_STATUSES.put(NoSegmentsInBookingException.class.getName(), ReservationStatus.CANCELED);
    }
}

