/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightPassengerTypeData;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class IbecorpUpdateReservationAndTicketsParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GDSParameters params = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        reservation.setBookingAgent(sc.getAgent());
        reservation.setSalesPoint(sc.getSalesPoint());
        reservation.setSubagency(sc.getSubagency());
        reservation.setType(ReservationType.IBE);
        reservation.setResDate(new Date());
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountCtr.toReference());
        String ticketingPCCCode = null;
        NestedEntityReference ticketingSpRef = null;
        NestedEntityReference ticketingPccRef = PccHelper.getTicketingPccRef((GDSParameters)params);
        if (ticketingPccRef != null) {
            ticketingSpRef = ticketingPccRef;
            Pcc pcc = (Pcc)EntityStorageHelper.resolve((NestedEntityReference)ticketingPccRef);
            if (pcc != null) {
                ticketingPCCCode = pcc.getCode();
            } else {
                ticketingSpRef = null;
            }
        }
        if (ticketingSpRef == null) {
            ticketingSpRef = sc.getSalesPoint();
            ticketingPCCCode = PccHelper.getTicketingPccCode((GDSParameters)params);
        }
        if (params.getBlankOwner() == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430", (Object[])new Object[0]);
        }
        EntityReference blankOwnerRef = params.getBlankOwner();
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        if (blankOwnerCtr == null) {
            throw Xeption.forAdmin((String)"\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430 {0} \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", (Object[])new Object[]{blankOwnerRef});
        }
        if (((Organization)blankOwnerCtr.getEntity()).getAirline() == null) {
            throw Xeption.forAdmin((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        Airline blankOwnerAirline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerCtr.getEntity()).getAirline());
        if (blankOwnerAirline == null) {
            throw Xeption.forAdmin((String)"\u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f {0}, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {1}, \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getAirline(), ((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        if (StringUtils.isBlank((String)blankOwnerAirline.getAirlineNumber())) {
            throw Xeption.forAdmin((String)"\u0443 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 {0}, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {1}, \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043a\u043e\u0434", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getAirline(), ((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        DictionaryReference<BlankType> blankTypeRef = IbecorpUpdateReservationAndTicketsParametersProcessor.getBlankType((EntityReference<Organization>)blankOwnerRef);
        EntityStorageContext storageContext = new EntityStorageContext();
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product ticket = (Product)baseProduct;
            ticket.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference(ticket.getCarrier())).getAirlineNumber());
            ticket.setEticket(true);
            ticket.setTicketType(TicketType.OWN);
            ticket.setCashier(sc.getAgent());
            ticket.setCashierCode(((Person)EntityStorage.get().resolve(sc.getAgent()).getEntity()).getCode());
            ticket.setSalesPoint((EntityReference)ticketingSpRef);
            AirProductHelper.setAgency((Product)ticket, (EntityReference)sc.getAgency());
            AirProductHelper.setSubagency((Product)ticket, (EntityReference)sc.getSubagency());
            AirProductHelper.setTechnicalProvider((Product)ticket, (EntityReference)sc.getTechnicalProvider());
            if (flight != null) {
                ticket.setSalesOriginProvider(flight.getSalesOriginProvider());
                ticket.setSalesOriginContent(flight.getSalesOriginContent());
            }
            ticket.setBlankOwnerRef(blankOwnerRef);
            ticket.setBlankOwnerNumber(IbecorpUpdateReservationAndTicketsParametersProcessor.getBlankOwnerNumber((EntityReference<Organization>)blankOwnerRef));
            ticket.setBlankType(blankTypeRef);
            if (!StringUtils.isBlank((String)ticketingPCCCode)) {
                ticket.setPcc(ticketingPCCCode);
                if (StringUtils.isBlank((String)ticket.getValidatorCode())) {
                    Validator val = GDSHelper.findValidatorByPccAndBlankOwner((EntityReference)ticketingSpRef, (String)ticket.getPcc(), (EntityReference)blankOwnerRef);
                    if (val == null && blankOwnerRef != null) {
                        val = GDSHelper.findValidatorByBlankOwner((EntityReference)sc.getSalesPoint(), (EntityReference)blankOwnerRef);
                    }
                    if (val == null && blankOwnerRef != null) {
                        EntityStorageHelper.NestedEntity<SalesPoint, Validator> tempValidator = this.findValidator(ticketingPCCCode, (EntityReference<Organization>)blankOwnerRef, storageContext);
                        if (tempValidator == null) {
                            tempValidator = this.findValidator((EntityReference<Organization>)blankOwnerRef, storageContext);
                        }
                        if (tempValidator != null) {
                            val = (Validator)tempValidator.getEntity();
                        }
                    }
                    if (val != null) {
                        ticket.setValidatorCode(val.getNumber());
                        if (ticketingSpRef != null) {
                            ticket.setValidatorRef(new NestedEntityReference((EntityReference)ticketingSpRef, (BaseEntity)val));
                        }
                        AirProductHelper.setSupplier((Product)ticket, (EntityReference)val.getSupplier());
                        if (ticket.getBlankOwnerRef() == null) {
                            ticket.setBlankOwnerRef(val.getBlankOwner());
                            ticket.setBlankOwnerNumber(IbecorpUpdateReservationAndTicketsParametersProcessor.getBlankOwnerNumber((EntityReference<Organization>)val.getBlankOwner()));
                        }
                    }
                }
            }
            AirProductHelper.updateRecordNumbers((Product)ticket);
            FlightHelper.getPassengerTypeData((Flight)flight, (DictionaryReference)ticket.getPassengerType()).map(FlightPassengerTypeData::getStatisticalData).ifPresent(arg_0 -> ((Product)ticket).setStatisticalData(arg_0));
        }
    }

    private EntityStorageHelper.NestedEntity<SalesPoint, Validator> findValidator(String pcc, EntityReference<Organization> blankOwner, EntityStorageContext storageContext) {
        if (StringUtils.isBlank((String)pcc)) {
            return EntityStorageHelper.NestedEntity.nullEntity();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)ValidatorIndex.Property.pcc.name(), (String)pcc));
        List data = EntityStorage.get().search(ValidatorIndex.class, query).getData();
        if (data.isEmpty()) {
            return EntityStorageHelper.NestedEntity.nullEntity();
        }
        Date now = new Date();
        for (ValidatorIndex idx : data) {
            EntityStorageHelper.NestedEntity result;
            if (idx.getOpened() != null && idx.getOpened().after(now) || idx.getClosed() != null && idx.getClosed().before(now) || blankOwner != null && idx.getBlankOwner() != null && !blankOwner.equals((Object)idx.getBlankOwner()) || (result = EntityStorageHelper.NestedEntity.forRef((NestedEntityReference)new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), Validator.class, null), (EntityStorageContext)storageContext)).getEntity() == null || ((Validator)result.getEntity()).getPCC().getOpened() != null && ((Validator)result.getEntity()).getPCC().getOpened().after(now) || ((Validator)result.getEntity()).getPCC().getClosed() != null && ((Validator)result.getEntity()).getPCC().getClosed().before(now)) continue;
            return result;
        }
        return EntityStorageHelper.NestedEntity.nullEntity();
    }

    private EntityStorageHelper.NestedEntity<SalesPoint, Validator> findValidator(EntityReference<Organization> blankOwner, EntityStorageContext storageContext) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), blankOwner));
        List data = EntityStorage.get().search(ValidatorIndex.class, query).getData();
        if (data.isEmpty()) {
            return EntityStorageHelper.NestedEntity.nullEntity();
        }
        Date now = new Date();
        for (ValidatorIndex idx : data) {
            EntityStorageHelper.NestedEntity result;
            if (idx.getOpened() != null && idx.getOpened().after(now) || idx.getClosed() != null && idx.getClosed().before(now) || (result = EntityStorageHelper.NestedEntity.forRef((NestedEntityReference)new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), Validator.class, null), (EntityStorageContext)storageContext)).getEntity() == null) continue;
            return result;
        }
        return EntityStorageHelper.NestedEntity.nullEntity();
    }

    private static String getBlankOwnerNumber(EntityReference<Organization> blankOwner) {
        EntityContainer ctr = EntityStorage.get().resolve(blankOwner);
        if (ctr == null) {
            return null;
        }
        Airline airline = (Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(((Organization)ctr.getEntity()).getAirline());
        return airline == null ? null : airline.getAirlineNumber();
    }

    private static DictionaryReference<BlankType> getBlankType(EntityReference<Organization> blankOwner) {
        for (BlankType blankType : BookingHelper.getBlankTypesByVendor(blankOwner)) {
            if (blankType.getBlankCategory() != BlankCategory.ETICKET || blankType.getProductCategory() != ProductCategory.AIR) continue;
            return blankType.toReference();
        }
        throw Xeption.forAdmin((String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0438\u043f \u0431\u043b\u0430\u043d\u043a\u0430 \u0434\u043b\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 {0}", (Object[])new Object[]{blankOwner});
    }
}

