/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds.createReservation.remarks;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;

public class PriceRemarksProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        HashSet<DictionaryReference> processedTypes = new HashSet<DictionaryReference>();
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            if (!processedTypes.add(gdsTraveller.getPassengerType())) continue;
            PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
            remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.INVOICE);
            remark.setText(PriceRemarksProcessor.buildRemarkText(parameters.getFlight(), (DictionaryReference<PassengerType>)gdsTraveller.getPassengerType()));
            request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
        }
    }

    private static String buildRemarkText(Flight flight, DictionaryReference<PassengerType> type) {
        Integer iataDecimalPlaces = DictHelper.getCurrencyInfoByAnyCode((String)flight.getGdsCurrencyCode()).getIataDecimalPlaces();
        if (iataDecimalPlaces == null) {
            throw Xeption.forAdmin((String)"\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u0432\u0430\u043b\u044e\u0442 \u0434\u043b\u044f \u0432\u0430\u043b\u044e\u0442\u044b {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u043d\u0430\u043a\u043e\u0432 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u044f\u0442\u043e\u0439 \u0432 Sabre", (Object[])new Object[]{flight.getGdsCurrencyCode()});
        }
        int scale = iataDecimalPlaces;
        BigDecimal fareWt = FlightHelper.getEquivalentFare((Flight)flight, (DictionaryReference)SabreHelper.autocorrectPassengerType(type, (Flight)flight)).add(FlightHelper.getEquivalentTaxSum((Flight)flight, (DictionaryReference)SabreHelper.autocorrectPassengerType(type, (Flight)flight)));
        BigDecimal fareWtScaled = fareWt.setScale(scale, RoundingMode.HALF_UP);
        BigDecimal agFee = FlightHelper.getEquivalentFee((Flight)flight, (DictionaryReference)SabreHelper.autocorrectPassengerType(type, (Flight)flight));
        BigDecimal agFeeScaled = agFee.setScale(scale, RoundingMode.HALF_UP);
        StringBuilder sb = new StringBuilder("X*-WEB PRICE ");
        sb.append(SabreHelper.getNativeCode(type));
        sb.append(" FARE WT");
        sb.append(fareWtScaled);
        sb.append("/AG FEE");
        sb.append(agFeeScaled);
        sb.append("/TTL");
        sb.append(fareWtScaled.add(agFeeScaled));
        sb.append('/');
        sb.append(AirPriceHelper.buildCommissionQualifier((Commission)SabreHelper.getTotalVendorCommissionForSabre((Flight)flight, (DictionaryReference)SabreHelper.autocorrectPassengerType(type, (Flight)flight)), (String)flight.getGdsCurrencyCode()));
        return sb.toString();
    }
}

