/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds.penalties;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MergePenaltiesInfosProcessor
extends BaseProcessor {
    private Comparator<PenaltiesInfo> comparator = (p1, p2) -> {
        int p2Availability;
        int p1Availability = this.getAvailability((PenaltiesInfo)p1);
        if (p1Availability == (p2Availability = this.getAvailability((PenaltiesInfo)p2))) {
            BigDecimal p1PenaltySum = this.getPenaltiesSum((PenaltiesInfo)p1);
            BigDecimal p2PenaltySum = this.getPenaltiesSum((PenaltiesInfo)p2);
            return p2PenaltySum.compareTo(p1PenaltySum);
        }
        return p1Availability - p2Availability;
    };

    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Map multicallResult = (Map)ctx.getMandatoryObject("PENALTIES_INFO_MULTICALL_RESULT");
        List passengerTypes = flight.getSeats().stream().map(seat -> (PassengerType)DictionaryCache.get().resolveReference(seat.getPassengerType())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List penaltiesMaps = multicallResult.values().stream().map(context -> (Map)context.getMandatoryObject((Enum)IBusGdsContextKeys.PENALTIES_INFO)).collect(Collectors.toList());
        for (PassengerType passengerType : passengerTypes) {
            ArrayList<PenaltiesInfo> penaltiesInfos = new ArrayList<PenaltiesInfo>();
            for (Map penaltiesMap : penaltiesMaps) {
                PenaltiesInfo penaltiesInfo = passengerType.getCodeVariants().values().stream().map(penaltiesMap::get).filter(Objects::nonNull).findFirst().orElseGet(() -> (PenaltiesInfo)penaltiesMap.get(null));
                if (penaltiesInfo == null) continue;
                penaltiesInfos.add(penaltiesInfo);
            }
            PenaltiesInfo result = this.getTheMostRestrictivePenalties(penaltiesInfos);
            if (result == null) continue;
            flight.getPenaltiesInfos().put(passengerType.toReference(), result);
        }
    }

    private PenaltiesInfo getTheMostRestrictivePenalties(List<PenaltiesInfo> penaltiesInfos) {
        if (penaltiesInfos.isEmpty()) {
            return null;
        }
        penaltiesInfos.sort(this.comparator);
        return penaltiesInfos.get(0);
    }

    private int getAvailability(PenaltiesInfo penaltiesInfo) {
        int result = 0;
        if (penaltiesInfo.getRefundableBeforeDeparture() == Boolean.TRUE) {
            ++result;
        }
        if (penaltiesInfo.getRefundableAfterDeparture() == Boolean.TRUE) {
            ++result;
        }
        if (penaltiesInfo.getExchangableBeforeDeparture() == Boolean.TRUE) {
            ++result;
        }
        if (penaltiesInfo.getExchangableAfterDeparture() == Boolean.TRUE) {
            ++result;
        }
        return result;
    }

    private BigDecimal getPenaltiesSum(PenaltiesInfo penaltiesInfo) {
        return MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.getMoneyValue(penaltiesInfo.getRefundBeforeDeparture()), this.getMoneyValue(penaltiesInfo.getRefundAfterDeparture()), this.getMoneyValue(penaltiesInfo.getExchangeBeforeDeparture()), this.getMoneyValue(penaltiesInfo.getExchangeAfterDeparture())}));
    }

    private BigDecimal getMoneyValue(Money money) {
        return money != null ? money.getValue() : null;
    }
}

