/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds.searchFlights;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.rules.GdsPropertiesProvider;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.AirlineDiscountCard;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GetDiscountCardsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference[] agencies = new EntityReference[]{salesContext.getAgency()};
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Collection airlines = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.APPLICABLE_AIRLINES);
        List passengers = (List)ctx.getObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Boolean ignoreBonusCards = (Boolean)ctx.getObject((Enum)IBusGdsSirenaContextKeys.IGNORE_BONUS_CARDS);
        HashMap discountCards = Boolean.TRUE.equals(ignoreBonusCards) ? new HashMap() : this.getDiscountCards(salesContext, (EntityContainer<BaseGdsAccount>)gdsAccountCtr, airlines, agencies, passengers, fsp);
        ctx.putObject((Enum)IBusIbeCorpContextKeys.DISCOUNT_CARDS, discountCards);
    }

    private Map<EntityReference<Person>, AirlineDiscountCard> getDiscountCards(SalesContext salesContext, final EntityContainer<BaseGdsAccount> gdsAccountCtr, Collection<DictionaryReference<Airline>> airlines, EntityReference[] agencies, List<EntityReference<Person>> passengers, FlightSearchParameters fsp) {
        Set cardsAirlines;
        HashMap discountCards = new HashMap();
        ArrayList contractsAirlines = new ArrayList();
        Date startDate = fsp.getRoute().stream().map(RouteSegment::getDate).filter(Objects::nonNull).min(Date::compareTo).orElse(null);
        Date endDate = fsp.getRoute().stream().map(RouteSegment::getDate).filter(Objects::nonNull).max(Date::compareTo).orElse(null);
        for (EntityContainer entityContainer : IBusGdsHelper.collectTripartiteContracts((SalesContext)salesContext, airlines, (EntityReference[])agencies)) {
            if (((TripartiteContract)entityContainer.getEntity()).getRuleSet() == null) continue;
            RuleSet ruleSet = ((TripartiteContract)entityContainer.getEntity()).getRuleSet();
            block1: for (RuleSettings rs : ruleSet.getRules()) {
                Object rr22;
                if (rs.getPeriodBegin() != null && rs.getPeriodBegin().after(new Date()) || rs.getPeriodEnd() != null && rs.getPeriodEnd().before(new Date())) continue;
                for (Object rr22 : rs.getRestrictions()) {
                    if (!(rr22.getProperty() == Properties.GDS_NAME ? !rr22.getProperty().match(() -> ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds().name(), rr22.getCondition(), rr22.getValue()) : rr22.getProperty() == com.gridnine.xtrip.common.gds.rules.Properties.GDS_ACCOUNT && !rr22.getProperty().match((Object)new GdsPropertiesProvider(){

                        public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
                            return gdsAccountCtr.toReference();
                        }

                        public String getGdsName() {
                            return ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds().name();
                        }
                    }, rr22.getCondition(), rr22.getValue()))) continue;
                    continue block1;
                }
                boolean usePersonDiscountCard = false;
                rr22 = rs.getResults().iterator();
                while (rr22.hasNext()) {
                    RuleResult rr3 = (RuleResult)rr22.next();
                    if (rr3.getAction() != AviaTripartiteContractActions.USE_PERSON_DISCOUNT_CARD) continue;
                    usePersonDiscountCard = true;
                    break;
                }
                if (!usePersonDiscountCard) continue;
                ArrayList contractAirlines = new ArrayList(((TripartiteContract)entityContainer.getEntity()).getAviaVendorData().getAirlines());
                contractAirlines.addAll(((TripartiteContract)entityContainer.getEntity()).getAviaVendorData().getAlliances().stream().map(DictHelper::findAirlinesByAlliance).flatMap(Collection::stream).distinct().map(Airline::toReference).collect(Collectors.toList()));
                contractsAirlines.addAll(contractAirlines);
            }
        }
        if (passengers != null) {
            for (EntityReference entityReference : passengers) {
                EntityContainer passengerCont = EntityStorage.get().resolve(entityReference);
                if (!EntityStorageHelper.nonEmpty((EntityContainer)passengerCont)) continue;
                Person passenger = (Person)passengerCont.getEntity();
                List airlineDiscountCards = passenger.getAirlineDiscountCards();
                if ((airlineDiscountCards = airlineDiscountCards.stream().filter(card -> TextUtil.nonBlank((String)card.getCode()) && TextUtil.nonBlank((String)card.getNumber())).filter(card -> MiscUtil.isBetween((Date)card.getStartDate(), (Date)card.getEndDate(), (Date)startDate)).filter(card -> MiscUtil.isBetween((Date)card.getStartDate(), (Date)card.getEndDate(), (Date)endDate)).filter(card -> contractsAirlines.contains(card.getAirline())).collect(Collectors.toList())).size() != 1) continue;
                discountCards.put(entityReference, airlineDiscountCards.get(0));
            }
        }
        return (cardsAirlines = discountCards.values().stream().map(AirlineDiscountCard::getAirline).collect(Collectors.toSet())).size() == 1 ? discountCards : Collections.emptyMap();
    }
}

