/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds.searchFlights;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.AirlineDiscountCard;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.gds.IbeSirenaHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModifyFlightPricingResultProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection parsedFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Flight originalFlight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        for (Flight parsedFlight : parsedFlights) {
            if (fsp != null) {
                this.modifyExtraChildren(parsedFlight, fsp.getSeats());
                continue;
            }
            this.modifyExtraChildren(parsedFlight, originalFlight.getSeats());
        }
        if (fsp != null) {
            Map discountCards = (Map)ctx.getMandatoryObject((Enum)IBusIbeCorpContextKeys.DISCOUNT_CARDS);
            Map passengersTypes = (Map)ctx.getMandatoryObject((Enum)IBusIbeCorpContextKeys.PASSENGERS_TYPES);
            for (Flight flight : parsedFlights) {
                DictionaryReference carrier = flight.getCarrier();
                boolean cardsForCarrierExists = false;
                for (Map.Entry card : discountCards.entrySet()) {
                    if (!((AirlineDiscountCard)card.getValue()).getAirline().equals((Object)carrier)) continue;
                    flight.getAirlineDiscountCards().put(card.getKey(), card.getValue());
                    cardsForCarrierExists = true;
                }
                if (cardsForCarrierExists) {
                    this.addDiscountCodes(flight, fsp.getSeats());
                }
                this.addPassengerTypes(flight, passengersTypes);
            }
        } else {
            for (Flight parsedFlight : parsedFlights) {
                this.addDiscountCodes(parsedFlight, originalFlight.getSeats());
                this.addPassengerTypes(parsedFlight, originalFlight.getPassengerTypes());
            }
        }
    }

    private void modifyExtraChildren(Flight flight, List<SeatPreferences> originalSeatPreferences) throws Exception {
        LinkedHashMap<DictionaryReference, Integer> extraChildrenCount = new LinkedHashMap<DictionaryReference, Integer>();
        for (SeatPreferences seatPreferences : originalSeatPreferences) {
            if (!IbeSirenaHelper.isExtraPassengerType((DictionaryReference<PassengerType>)seatPreferences.getOriginalPassengerType())) continue;
            extraChildrenCount.put(seatPreferences.getOriginalPassengerType(), seatPreferences.getCount() + extraChildrenCount.getOrDefault(seatPreferences.getOriginalPassengerType(), 0));
        }
        for (Map.Entry entry : extraChildrenCount.entrySet()) {
            DictionaryReference type = (DictionaryReference)entry.getKey();
            int count = (Integer)entry.getValue();
            SeatPreferences seat = flight.getSeats().stream().filter(params -> DictHelper.isChildPassengerType((DictionaryReference)params.getPassengerType())).findFirst().orElse(null);
            if (seat == null) continue;
            SeatPreferences newSeat = (SeatPreferences)XCloneHelper.clone((XCloneable)seat, (boolean)true);
            newSeat.setOriginalPassengerType(type);
            newSeat.setCount(count);
            flight.getSeats().add(newSeat);
            seat.setCount(seat.getCount() - count);
            if (seat.getCount() >= 1) continue;
            flight.getSeats().remove(seat);
        }
    }

    private void addDiscountCodes(Flight flight, List<SeatPreferences> originalSeatPreferences) throws Exception {
        List discountCodes = originalSeatPreferences.stream().filter(seat -> DictHelper.isPromoPassengerType((DictionaryReference)seat.getPassengerType())).map(SeatPreferences::getDiscountCode).filter(TextUtil::nonBlank).collect(Collectors.toList());
        for (String discountCode : discountCodes) {
            SeatPreferences seat2 = flight.getSeats().stream().filter(params -> params.getDiscountCode() == null).filter(params -> DictHelper.isPromoPassengerType((DictionaryReference)params.getPassengerType())).findFirst().orElse(null);
            if (seat2 == null) continue;
            SeatPreferences newSeat = (SeatPreferences)XCloneHelper.clone((XCloneable)seat2, (boolean)true);
            newSeat.setDiscountCode(discountCode);
            newSeat.setCount(1);
            flight.getSeats().add(newSeat);
            seat2.setCount(seat2.getCount() - 1);
            if (seat2.getCount() >= 1) continue;
            flight.getSeats().remove(seat2);
        }
    }

    private void addPassengerTypes(Flight flight, Map<EntityReference<Person>, DictionaryReference<PassengerType>> passengersTypes) {
        flight.getPassengerTypes().clear();
        flight.getPassengerTypes().putAll(passengersTypes);
    }
}

