/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.AirlineDiscountCard;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.gds.IbeSirenaHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModifyFlightSearchParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HashMap<EntityReference, DictionaryReference> passengersTypes;
        SeatPreferences sp;
        FlightSearchParameters fspOriginal = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        FlightSearchParameters fsp = (FlightSearchParameters)XCloneHelper.clone((XCloneable)fspOriginal);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)fsp);
        Map discountCards = (Map)ctx.getMandatoryObject((Enum)IBusIbeCorpContextKeys.DISCOUNT_CARDS);
        List passengers = (List)ctx.getObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS);
        int standardChildrenCount = 0;
        LinkedHashMap<DictionaryReference, Integer> extraChildrenCount = new LinkedHashMap<DictionaryReference, Integer>();
        Iterator spIterator = fsp.getSeats().iterator();
        while (spIterator.hasNext()) {
            sp = (SeatPreferences)spIterator.next();
            if (!sp.getPassengerType().getCode().startsWith("CHILD_")) continue;
            if (IbeSirenaHelper.isExtraPassengerType((DictionaryReference<PassengerType>)sp.getPassengerType())) {
                extraChildrenCount.put(sp.getPassengerType(), sp.getCount() + extraChildrenCount.getOrDefault(sp.getPassengerType(), 0));
            } else {
                standardChildrenCount += sp.getCount();
            }
            spIterator.remove();
        }
        if (standardChildrenCount > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(DictHelper.getChildPassengerType());
            sp.setCount(standardChildrenCount);
            fsp.getSeats().add(sp);
        }
        extraChildrenCount.forEach((type, count) -> {
            SeatPreferences sp = new SeatPreferences();
            sp.setOriginalPassengerType(type);
            sp.setPassengerType(DictHelper.getChildPassengerType());
            sp.setCount(count.intValue());
            fsp.getSeats().add(sp);
        });
        Map<Object, DictionaryReference> map = passengersTypes = passengers != null ? passengers.stream().collect(Collectors.toMap(Function.identity(), type -> Objects.requireNonNull(DictHelper.getAdultPassengerType()))) : new HashMap<EntityReference, DictionaryReference>();
        if (!discountCards.isEmpty()) {
            Optional<SeatPreferences> seatOptional = fsp.getSeats().stream().filter(params -> DictHelper.isAdultPassengerType((DictionaryReference)params.getPassengerType())).findFirst();
            if (seatOptional.isPresent()) {
                SeatPreferences seat2 = seatOptional.get();
                for (Map.Entry entry : discountCards.entrySet()) {
                    EntityReference person = (EntityReference)entry.getKey();
                    AirlineDiscountCard card = (AirlineDiscountCard)entry.getValue();
                    SeatPreferences newSeat = (SeatPreferences)XCloneHelper.clone((XCloneable)seat2, (boolean)true);
                    newSeat.setPassengerType(DictHelper.getPromoPassengerType());
                    newSeat.setDiscountCode(card.getCode());
                    newSeat.setCount(1);
                    seat2.setCount(seat2.getCount() - 1);
                    fsp.getSeats().add(newSeat);
                    passengersTypes.put(person, DictHelper.getPromoPassengerType());
                }
                if (seat2.getCount() < 1) {
                    fsp.getSeats().remove(seat2);
                }
            }
        } else {
            fsp.getSeats().stream().filter(seat -> DictHelper.isPromoPassengerType((DictionaryReference)seat.getPassengerType())).forEach(seat -> {
                seat.setPassengerType(DictHelper.getAdultPassengerType());
                seat.setDiscountCode(null);
            });
        }
        ctx.putObject((Enum)IBusIbeCorpContextKeys.PASSENGERS_TYPES, passengersTypes);
    }
}

