/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.gds.searchFlights.filter;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.ibecorp.IbeSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SirenaFlightsFilter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IbeSettings settings = (IbeSettings)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.IBE_SETTINGS);
        List<String> filter = Arrays.asList(TextUtil.nonBlank((String)settings.getSirenaFilter()) ? settings.getSirenaFilter().split(",") : new String[]{});
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Iterator iter = flights.iterator();
        block0: while (iter.hasNext()) {
            Flight flight = (Flight)iter.next();
            if (!GdsName.SIRENA.equals((Object)flight.getGds())) continue;
            Airline carrier = (Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(flight.getCarrier());
            if (carrier == null) {
                this.log.error(String.format("could not resolve carrier %s, flight excluded", flight.getCarrier()));
                iter.remove();
                continue;
            }
            for (String code : carrier.getCodeVariants().values()) {
                if (!filter.contains(code)) continue;
                iter.remove();
                continue block0;
            }
        }
    }
}

