/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.hotels.cancel;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.exceptions.UserBookingWithoutErrorStatusException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class ValidateHotelsRefundProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List finalProducts = HotelsReservationHelper.getFinalProducts((Reservation)reservation);
        boolean alreadyRefunded = finalProducts.stream().noneMatch(hp -> hp.getStatus() != ProductStatus.REFUND);
        if (alreadyRefunded) {
            throw new UserBookingWithoutErrorStatusException(L10nResourcesManager.createL10nMessage((String)Messages.HOTELS_RESERVATION_ALREADY_REFUNDED, (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
        }
        for (BaseProduct bp : finalProducts) {
            HotelProduct product = (HotelProduct)bp;
            if (!HotelsReservationHelper.isRefundAvailable((HotelProduct)product)) {
                throw Xeption.forEndUser((String)Messages.HOTELS_NONREFUNDABLE_PRODUCT, (Object[])new Object[]{HotelsReservationHelper.getCaption((HotelProduct)product)});
            }
            if (product.isCancellable() && product.getCancellableNow() == Boolean.TRUE) continue;
            String message = product.getProvider() == HotelProvider.A_AND_A ? CommonHelper.getLocalizedString(Messages.HOTELS_PRODUCT_NOT_CANCELLABLE_AANDA, product.getProviderStatusInfo()) : CommonHelper.getLocalizedString(Messages.HOTELS_PRODUCT_NOT_CANCELLABLE, product.getSystemNumber());
            throw Xeption.forEndUser((String)message, (Object[])new Object[0]);
        }
    }
}

