/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.hotels.dc;

import com.gridnine.xtrip.common.helper.SearchHelper;
import com.gridnine.xtrip.common.hotels2.model.CancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.CancellationChargeHolder;
import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.hotels2.model.CheckInOption;
import com.gridnine.xtrip.common.hotels2.model.CheckOutOption;
import com.gridnine.xtrip.common.hotels2.model.Facility;
import com.gridnine.xtrip.common.hotels2.model.GuestField;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOptionAvailability;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOptionAvailabilityType;
import com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy;
import com.gridnine.xtrip.common.hotels2.model.MealOption;
import com.gridnine.xtrip.common.hotels2.model.MealPlan;
import com.gridnine.xtrip.common.hotels2.model.NonCancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.ProviderVatInfo;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AvailableOption;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Location;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.OfferOptionType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.RateType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsPayee;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsStayType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.ibecorp.hotels.MealItem;
import com.gridnine.xtrip.common.model.ibecorp.hotels.RoomSize;
import com.gridnine.xtrip.common.model.ibecorp.profile.DirectContract;
import com.gridnine.xtrip.common.model.ibecorp.profile.DirectContractCancellationCharge;
import com.gridnine.xtrip.common.model.ibecorp.profile.DirectContractCancellationPolicy;
import com.gridnine.xtrip.common.model.ibecorp.profile.DirectContractFare;
import com.gridnine.xtrip.common.model.ibecorp.profile.DirectContractPrice;
import com.gridnine.xtrip.common.model.ibecorp.profile.DirectContractTimeService;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.statistic.helpers.CommonStatisticsHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsDirectContractHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelInfo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class HotelDirectContractHelper {
    public static Map<EntityReference<Organization>, String> getHotels(String hotelNumber) {
        return HotelDirectContractHelper.getHotels(SearchHelper.searchEntity(OrganizationIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.hotelNumber.name(), (Object)hotelNumber)}));
    }

    public static Map<EntityReference<Organization>, String> getHotels(DictionaryReference<GeoLocation> hotelCity) {
        return HotelDirectContractHelper.getHotels(SearchHelper.searchEntity(OrganizationIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.hotelCity.name(), hotelCity)}));
    }

    private static Map<EntityReference<Organization>, String> getHotels(List<OrganizationIndex> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        return list.stream().filter(i -> TextUtil.nonBlank((String)i.getHotelNumber())).collect(Collectors.toMap(OrganizationIndex::getSource, OrganizationIndex::getHotelNumber));
    }

    private static Set<EntityReference<Contract>> getContracts(Set<EntityReference<Organization>> hotels, SalesContext salesContext, LocalDate checkInDate, LocalDate checkOutDate) {
        EntityReference client = salesContext.getClient();
        SearchQuery query = new SearchQuery();
        HotelsDirectContractHelper.buildBasicCriterions((SearchQuery)query, (SalesContext)salesContext);
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEntityCriterion((String)ContractIndex.Property.supplier.name(), hotels));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.buildOrEqEntityCriterion((String)ContractIndex.Property.vendor.name(), hotels), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)MiscUtil.toDate((LocalDate)checkInDate)))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)MiscUtil.toDate((LocalDate)checkOutDate)))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)ContractIndex.Property.hotelClients.name()), SearchCriterion.contains((String)ContractIndex.Property.hotelClients.name(), (Object)client)}));
        List contractIndexes = EntityStorage.get().search(ContractIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS).getData();
        return contractIndexes.stream().map(ContractIndex::getSource).collect(Collectors.toSet());
    }

    public static Map<String, Collection<HotelOffer>> createOffers(Map<EntityReference<Organization>, String> hotels, HotelInfo hotelInfo, SalesContext salesContext, LocalDate checkInDate, LocalDate checkOutDate, List<com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room> rooms) {
        Set<EntityReference<Contract>> contracts = HotelDirectContractHelper.getContracts(hotels.keySet(), salesContext, checkInDate, checkOutDate);
        HashMap<String, Collection<HotelOffer>> result = new HashMap<String, Collection<HotelOffer>>();
        for (EntityReference<Contract> contractRef : contracts) {
            Contract contract;
            DirectContract dc;
            EntityContainer contractCtr = EntityStorage.get().resolve(contractRef);
            if (null == contractCtr || null == (dc = (contract = (Contract)contractCtr.getEntity()).getDirectContract())) continue;
            String hotelNumber = hotels.get(contract.getSupplier());
            List priceList = dc.getPriceList();
            for (DirectContractPrice price : priceList) {
                com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room room;
                int limit;
                int count = HotelDirectContractHelper.getSeatCount(price.getRoomSize());
                Iterator<com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room> iterator = rooms.iterator();
                while (iterator.hasNext() && count == (limit = !(room = iterator.next()).getTravellers().isEmpty() ? room.getTravellers().size() : room.getTravellersInfo().values().stream().reduce(0, Integer::sum).intValue())) {
                    HotelOffer offer = HotelDirectContractHelper.createOffer(contractRef, hotelNumber, hotelInfo, checkInDate, checkOutDate, room, price);
                    if (offer == null) continue;
                    result.computeIfAbsent(hotelNumber, k -> new ArrayList()).add(offer);
                }
            }
        }
        return result;
    }

    private static HotelOffer createOffer(EntityReference<Contract> contractRef, String hotelNumber, HotelInfo hotelInfo, LocalDate checkInDate, LocalDate checkOutDate, com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room room, DirectContractPrice price) {
        HotelOffer result = new HotelOffer();
        result.setContract(contractRef);
        result.setHotelCardNumber(hotelNumber);
        result.setFreeForSale(false);
        result.setProvider(HotelProvider.INTERNAL);
        result.setRoomName(price.getRoomName());
        result.setRoomSize(EnumUtil.nameOf((Enum)price.getRoomSize()));
        result.setMealIncluded(HotelDirectContractHelper.getMeal(price.getMeal()));
        result.getOptions().getMealOptions().add(HotelDirectContractHelper.getMealOption(price.getMeal(), null, null, true));
        HotelsServiceAvailability availability = new HotelsServiceAvailability();
        availability.setImmediateConfirmation(Boolean.FALSE);
        availability.setPayee(price.isReferral() ? HotelsPayee.HOTEL : HotelsPayee.PROVIDER);
        result.setAvailability(availability);
        result.setRoomInfo(HotelsConverterHelper.convertToRoomInfo(room));
        DirectContractCancellationPolicy cancellationPolicy = price.getCancellationPolicy();
        if (cancellationPolicy.isNonCancelable()) {
            result.setRateType(RateType.NON_REFUNDABLE);
            result.setCancellationPolicy((CancellationPolicy)new NonCancellablePolicy());
        } else {
            result.setRateType(RateType.STANDARD);
            CancellablePolicy cp = new CancellablePolicy();
            result.setCancellationPolicy((CancellationPolicy)cp);
            CancellationChargeHolder holder = new CancellationChargeHolder();
            cp.setCancellationChargesHolder(holder);
            for (DirectContractCancellationCharge c : cancellationPolicy.get\u0421ancellationCharges()) {
                CancellationCharge cc = new CancellationCharge();
                if (c.getPenalty() == null || (c.getPenalty().getMoney() == null || c.getPenalty().getMoney().getValue() == null || BigDecimal.ZERO.equals(c.getPenalty().getMoney().getValue())) && c.getPenalty().getRate() == null) continue;
                if (c.getAnchor() != null) {
                    switch (c.getAnchor()) {
                        case AFTER_RESERVATION_DATE: {
                            cc.setStartDate(MiscUtil.toDate((LocalDateTime)LocalDateTime.now().plusDays(c.getDays())));
                            break;
                        }
                        case BEFORE_CHECK_IN_DATE: {
                            cc.setStartDate(MiscUtil.toDate((LocalDate)checkInDate.minusDays(c.getDays())));
                        }
                    }
                }
                cc.setWithTime(true);
                cc.setPenalty(c.getPenalty());
                if (c.getPenalty().getMoney() != null && c.getVatRate() != null) {
                    VatAmount va = new VatAmount();
                    BigDecimal amount = c.getPenalty().getMoney().getValue();
                    va.setTotalVat(amount, c.getVatRate().doubleValue());
                    cc.setPenaltyEquivalentAmount(amount);
                    cc.setPenaltyVatAmount(va.getVatAmount());
                    cc.setPenaltyEquivalentVatRate(c.getVatRate());
                }
                holder.getCancellationCharges().add(cc);
            }
            Date checkInDate2 = MiscUtil.toDate((LocalDate)checkInDate);
            if (holder.getCancellationCharges().isEmpty()) {
                holder.setFreeCancellationTerm(checkInDate2);
            } else {
                if (holder.getCancellationCharges().size() > 1) {
                    holder.getCancellationCharges().sort((o1, o2) -> {
                        Date date2;
                        Date date1 = o1.getStartDate();
                        Integer cmp = MiscUtil.compareIfNulls((Object)date1, (Object)(date2 = o2.getStartDate()));
                        if (cmp != null) {
                            return cmp;
                        }
                        return date1.compareTo(date2);
                    });
                    CancellationCharge prevCharge = null;
                    for (CancellationCharge charge : holder.getCancellationCharges()) {
                        if (prevCharge != null) {
                            prevCharge.setEndDate(charge.getStartDate());
                        }
                        prevCharge = charge;
                    }
                    ((CancellationCharge)holder.getCancellationCharges().get(holder.getCancellationCharges().size() - 1)).setEndDate(checkInDate2);
                }
                Date first = ((CancellationCharge)holder.getCancellationCharges().get(0)).getStartDate();
                holder.setFreeCancellationTerm(first);
            }
        }
        AtomicReference rackRate = new AtomicReference();
        List fares = price.getFares();
        if (!HotelDirectContractHelper.forEach(checkInDate, checkOutDate, date -> {
            DirectContractFare fare = HotelDirectContractHelper.getFare(fares, date);
            if (null == fare) {
                return false;
            }
            result.getBreakdowns().add(HotelDirectContractHelper.cloneMoney(fare.getFare()));
            rackRate.weakCompareAndSet(null, fare.getRackRate());
            return true;
        })) {
            return null;
        }
        if (result.getBreakdowns().stream().map(Money::getCurrency).filter(Objects::nonNull).distinct().count() != 1L) {
            return null;
        }
        result.setBasePrice(MoneyHelper.buildMoney((BigDecimal)result.getBreakdowns().stream().map(Money::getValue).reduce(BigDecimal.ZERO, BigDecimal::add), (String)((Money)result.getBreakdowns().get(0)).getCurrency()));
        result.setRackRate((Money)rackRate.get());
        HotelsStayPolicy stayPolicy = new HotelsStayPolicy();
        result.setStayPolicy(stayPolicy);
        stayPolicy.setCheckInDate(checkInDate);
        stayPolicy.setCheckOutDate(checkOutDate);
        stayPolicy.setType(HotelsStayType.DEFAULT);
        price.getMeals().forEach(m -> result.getOptions().getMealOptions().add(HotelDirectContractHelper.getMealOption(m.getMeal(), m.getPrice(), m.getVatRate(), false)));
        if (!price.getEarlyCheckIn().isEmpty()) {
            Money checkInPrice = (Money)result.getBreakdowns().get(0);
            price.getEarlyCheckIn().forEach(s -> result.getOptions().getCheckInOptions().add(HotelDirectContractHelper.getEarlyCheckIn(s, checkInPrice)));
        }
        if (!price.getLateCheckOut().isEmpty()) {
            Money checkOutPrice = (Money)result.getBreakdowns().get(result.getBreakdowns().size() - 1);
            price.getLateCheckOut().forEach(s -> result.getOptions().getCheckOutOptions().add(HotelDirectContractHelper.getLaterCheckOut(s, checkOutPrice)));
        }
        ProviderVatInfo providerVatInfo = result.getProviderVatInfo();
        if (price.isReferral() || price.getVatRate() == null) {
            providerVatInfo.setIncluded(Boolean.valueOf(false));
            providerVatInfo.setAmount(null);
        } else {
            VatAmount va = new VatAmount();
            va.setTotalVat(result.getBasePrice().getValue(), price.getVatRate().doubleValue());
            providerVatInfo.setAmount(va.getVatAmount());
            providerVatInfo.setRate(va.getVat());
            providerVatInfo.setIncluded(Boolean.valueOf(true));
        }
        result.getMandatoryGuestField().add(GuestField.FIRST_NAME);
        result.getMandatoryGuestField().add(GuestField.SECOND_NAME);
        if (hotelInfo != null && DictHelper.getRuRef().equals((Object)hotelInfo.getHotelCountry())) {
            result.getMandatoryGuestField().add(GuestField.SUPPORTS_CYRILLIC_NAMES);
        }
        return result;
    }

    private static DirectContractFare getFare(List<DirectContractFare> fares, LocalDate date) {
        return fares.stream().filter(f -> !(f.getStartDate() != null && f.getStartDate().isAfter(date) || f.getEndDate() != null && f.getEndDate().isBefore(date) || !f.getDaysOfWeek().isEmpty() && !f.getDaysOfWeek().contains(date.getDayOfWeek()) || f.getFare() == null || f.getFare().getValue() == null)).findFirst().orElse(null);
    }

    private static boolean forEach(LocalDate from, LocalDate to, Function<LocalDate, Boolean> consumer) {
        if (!from.isBefore(to)) {
            return false;
        }
        LocalDate d = from;
        while (d.isBefore(to)) {
            if (!consumer.apply(d).booleanValue()) {
                return false;
            }
            d = d.plusDays(1L);
        }
        return true;
    }

    private static MealOption getMealOption(MealItem meal, Money price, Double vatRate, boolean includedInTariff) {
        MealOption option = new MealOption();
        if (meal != null) {
            option.setMealCode(meal.getCode());
            option.setBaseMealCode(meal.getBaseMealCode());
            option.setMealCaption(meal.getCaption());
        } else {
            option.setMealCode("-1");
            option.setMealCaption("\u0411\u0435\u0437 \u043f\u0438\u0442\u0430\u043d\u0438\u044f");
        }
        option.setExclusive(Boolean.valueOf(true));
        option.setPrice(price);
        option.setVatRate(vatRate);
        option.setIncludedInTariff(Boolean.valueOf(includedInTariff));
        HotelsServiceOptionAvailability availability = option.getAvailability();
        availability.setGuaranteed(Boolean.valueOf(true));
        availability.setType(includedInTariff ? HotelsServiceOptionAvailabilityType.INCLUDED : HotelsServiceOptionAvailabilityType.REQUEST);
        return option;
    }

    private static CheckInOption getEarlyCheckIn(DirectContractTimeService service, Money checkInPrice) {
        CheckInOption option = new CheckInOption();
        option.setFrom(service.getStartTime());
        option.setTo(service.getEndTime());
        option.setPrice(HotelDirectContractHelper.getPrice(service.getPrice(), checkInPrice));
        option.setVatRate(service.getVatRate());
        option.setIncludedInTariff(Boolean.valueOf(false));
        HotelsServiceOptionAvailability availability = option.getAvailability();
        availability.setGuaranteed(Boolean.valueOf(true));
        availability.setType(HotelsServiceOptionAvailabilityType.REQUEST);
        return option;
    }

    private static CheckOutOption getLaterCheckOut(DirectContractTimeService service, Money checkInPrice) {
        CheckOutOption option = new CheckOutOption();
        option.setFrom(service.getStartTime());
        option.setTo(service.getEndTime());
        option.setPrice(HotelDirectContractHelper.getPrice(service.getPrice(), checkInPrice));
        option.setVatRate(service.getVatRate());
        option.setIncludedInTariff(Boolean.valueOf(false));
        HotelsServiceOptionAvailability availability = option.getAvailability();
        availability.setGuaranteed(Boolean.valueOf(true));
        availability.setType(HotelsServiceOptionAvailabilityType.REQUEST);
        return option;
    }

    private static Money cloneMoney(Money money) {
        if (null == money) {
            return MoneyHelper.buildMoney((BigDecimal)BigDecimal.ZERO, (String)DictHelper.getLocalCurrency());
        }
        Money result = MoneyHelper.cloneMoney((Money)money);
        if (result.getValue() == null) {
            result.setValue(BigDecimal.ZERO);
        }
        if (result.getCurrency() == null) {
            result.setCurrency(DictHelper.getLocalCurrency());
        }
        return result;
    }

    private static Money getPrice(RateMoney money, Money base) {
        if (null == money) {
            return null;
        }
        Double rate = money.getRate();
        if (null == rate) {
            return HotelDirectContractHelper.cloneMoney(money.getMoney());
        }
        if (null == base || base.getValue() == null) {
            return null;
        }
        Money result = HotelDirectContractHelper.cloneMoney(base);
        result.setValue(base.getValue().multiply(BigDecimal.valueOf(rate / 100.0)));
        return result;
    }

    private static MealPlan getMeal(MealItem meal) {
        MealPlan mealPlan = new MealPlan();
        if (null == meal) {
            mealPlan.setCode("-1");
            mealPlan.setCaption("\u0411\u0435\u0437 \u043f\u0438\u0442\u0430\u043d\u0438\u044f");
        } else {
            mealPlan.setCode(meal.getCode());
            mealPlan.setCaption(meal.getCaption());
            mealPlan.setBasemealId(meal.getBaseMealCode());
        }
        return mealPlan;
    }

    private static int getSeatCount(RoomSize roomSize) {
        if (null == roomSize) {
            return 0;
        }
        switch (roomSize) {
            case SINGLE: {
                return 1;
            }
            case DOUBLE: 
            case TWIN: {
                return 2;
            }
            case TRPL: {
                return 3;
            }
            case QUAD: {
                return 4;
            }
        }
        return 0;
    }

    public static Reservation createReservation(SalesContext salesContext, HotelCard card, HotelOffer offer, String comments, Consumer<Message> messages) throws Exception {
        Reservation reservation = new Reservation();
        reservation.setType(ReservationType.IBE);
        reservation.getGdsNameInfo().setOnlineGdsAccount(offer.getGdsAccount());
        SalesContextHandler.get().enforceSalesContext(salesContext, reservation);
        reservation.setResDate(new Date());
        String number = SequenceNumberHelper.generateNumber((String)"hotels-reservation", MainHotelProductIndex.class, com.gridnine.xtrip.common.model.helpers.SearchQueryHelper::getRecordLocatorSearchCriterionForMainHotelProductIndex, (String)"H", null);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.IBE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)number);
        reservation.setNotes(comments);
        HotelProduct hp = HotelDirectContractHelper.createProduct(salesContext, card, offer, messages);
        hp.setReservation(reservation);
        reservation.getProducts().add(hp);
        reservation.setTimeLimit((Date)reservation.getProducts().stream().filter(p -> p instanceof HotelProduct).map(HotelProduct.class::cast).map(p -> p.getRooms().isEmpty() ? null : ((Room)p.getRooms().get(0)).getCheckInDate()).filter(Objects::nonNull).min(Date::compareTo).orElse(null));
        return reservation;
    }

    private static HotelProduct createProduct(SalesContext salesContext, HotelCard card, HotelOffer offer, Consumer<Message> messages) {
        AvailableOption availableOption;
        HotelProduct hp = HotelsHelper.createHotelProduct((SalesContext)salesContext);
        hp.setStatus(ProductStatus.INTENTION);
        Date issueDate = new Date();
        hp.setIssueDate(issueDate);
        HotelProductHelper.setOnHold((HotelProduct)hp, (boolean)true);
        hp.setProvider(offer.getProvider());
        hp.setSubProvider(offer.getSubProvider());
        hp.setBlankOwnerCode(offer.getBlankOwnerCode());
        EntityContainer contractCtr = EntityStorage.get().resolve(offer.getContract());
        hp.setVendorContract(contractCtr.toReference());
        Contract contract = (Contract)contractCtr.getEntity();
        EntityReference supplier = contract.getSupplier();
        HotelProductHelper.setSupplier((HotelProduct)hp, (EntityReference)supplier);
        hp.setBlankOwnerRef(supplier);
        Money basePrice = offer.getBasePrice();
        String gdsCurrency = (String)MiscUtil.guarded((Object)basePrice.getCurrency(), DictHelper::getLocalCurrency);
        hp.setGdsCurrency(gdsCurrency);
        hp.setHotelByRequest(true);
        hp.setTicketType(offer.getAvailability().getPayee() == HotelsPayee.HOTEL ? TicketType.REFERRAL : TicketType.OWN);
        if (!offer.getEssentialInfo().isEmpty()) {
            hp.getEssentialInfoData().add(HotelProductHelper.getDefaultEssentialInfoData((List)offer.getEssentialInfo()));
        }
        hp.setHotelPropertyId(card.getNumber());
        hp.setHotelName(card.getName());
        hp.setHotelType(card.getHotelType());
        hp.setHotelStars(card.getHotelStars());
        hp.setDescription(card.getDescription());
        hp.setTripartiteAgreement(offer.isTripartiteContract());
        hp.setClientTariffCode(offer.getClientTariffCode());
        Address address = card.getAddress();
        if (address != null) {
            hp.setHotelLocation(address.getCity());
            hp.setHotelCountry(address.getCountry());
            hp.setHotelAddress(address.getAddress().toString());
        }
        if (card.getLatitude() != null && card.getLongitude() != null) {
            Location loc = new Location();
            loc.setLatitude(card.getLatitude().doubleValue());
            loc.setLongitude(card.getLongitude().doubleValue());
            hp.setLoc(loc);
        }
        hp.setHotelFax(HotelsHelper.getFax((List)card.getContacts()));
        hp.setHotelEmail(HotelsHelper.getEmail((List)card.getContacts()));
        String phone = HotelsHelper.getPhone((List)card.getContacts());
        if (TextUtil.nonBlank((String)phone)) {
            hp.setHotelPhone(phone);
        } else {
            messages.accept(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"HOTELS2_MISSING_HOTEL_PHONE_IN_PRODUCT", (Object[])new Object[]{hp.getSystemNumber()}));
        }
        card.getBaseFacilities().stream().map(Facility::getCaption).filter(Objects::nonNull).forEach(hp.getBaseFacilities()::add);
        card.getFacilities().stream().map(Facility::getCaption).filter(Objects::nonNull).forEach(hp.getFacilities()::add);
        Room room = (Room)hp.getRooms().get(0);
        room.setId(offer.getId());
        room.setHotelCardNumber(offer.getHotelCardNumber());
        room.setRateType(offer.getRateType());
        room.setAdditionalInfo(offer.getAdditionalInfo());
        room.getRequestedByRemark().clear();
        offer.getAdditionalServices().stream().map(AdditionalService::getType).forEach(room.getRequestedByRemark()::add);
        HotelsStayPolicy stayPolicy = offer.getStayPolicy();
        room.setCheckInDate(MiscUtil.toDate((LocalDate)stayPolicy.getCheckInDate()));
        room.setCheckOutDate(MiscUtil.toDate((LocalDate)stayPolicy.getCheckOutDate()));
        LocalTime standardCheckInTime = stayPolicy.getStandardCheckInTime();
        LocalTime standardCheckOutTime = stayPolicy.getStandardCheckOutTime();
        room.setCheckInTime(HotelsBaseHelper.localTime2Integer((LocalTime)stayPolicy.getCheckInTime()));
        room.setCheckOutTime(HotelsBaseHelper.localTime2Integer((LocalTime)stayPolicy.getCheckOutTime()));
        room.setStandardCheckInTime(HotelsBaseHelper.localTime2Integer((LocalTime)standardCheckInTime));
        room.setStandardCheckOutTime(HotelsBaseHelper.localTime2Integer((LocalTime)standardCheckOutTime));
        room.setBasePrice(basePrice);
        BigDecimal equivalentPrice = basePrice.getValue();
        room.setEquivalentPrice(equivalentPrice);
        ProviderVatInfo providerVatInfo = offer.getProviderVatInfo();
        room.setVat(providerVatInfo.getIncluded());
        room.setVatAmount(providerVatInfo.getAmount());
        room.setEquivalentVatPrice(providerVatInfo.getAmount());
        room.setEquivVatRate(providerVatInfo.getRate());
        room.setBaseRate(HotelProductHelper.calculateRawPriceRatePerNight((LocalDate)stayPolicy.getCheckInDate(), (LocalDate)stayPolicy.getCheckOutDate(), (Money)basePrice));
        room.setRackRate(offer.getRackRate() != null ? offer.getRackRate().getValue() : null);
        room.setRoomName(offer.getRoomName());
        room.setRoomSize(offer.getRoomSize());
        hp.getAdditionalServices().addAll(offer.getAdditionalServices());
        for (CheckInOption ignored : offer.getOptions().getCheckInOptions()) {
            availableOption = new AvailableOption();
            availableOption.setDisplayName(OfferOptionType.EARLY_CHECKIN.toString());
            availableOption.setOptionType(OfferOptionType.EARLY_CHECKIN);
            room.getAvailableOptions().add(availableOption);
        }
        for (CheckInOption ignored : offer.getOptions().getCheckOutOptions()) {
            availableOption = new AvailableOption();
            availableOption.setDisplayName(OfferOptionType.LATE_CHECKOUT.toString());
            availableOption.setOptionType(OfferOptionType.LATE_CHECKOUT);
            room.getAvailableOptions().add(availableOption);
        }
        for (MealOption option : offer.getOptions().getMealOptions()) {
            if (Boolean.TRUE.equals(option.getIncludedInTariff())) continue;
            availableOption = new AvailableOption();
            availableOption.setCode(HotelsConverterHelper.getMealCode(option));
            availableOption.setDisplayName(HotelsConverterHelper.getMealCaption(option));
            availableOption.setOptionType(OfferOptionType.EXTRA_MEAL);
            room.getAvailableOptions().add(availableOption);
            if (room.getMeal() != null) continue;
            Meal meal = new Meal();
            meal.setCode(availableOption.getCode());
            meal.setCaption(availableOption.getDisplayName());
            room.setMeal(meal);
        }
        if (room.getMeal() == null) {
            MealPlan mealPlan = offer.getMealIncluded();
            room.setMeal(HotelsHelper.buildMeal((MealPlan)mealPlan));
        }
        room.setAvailability(offer.getAvailability());
        hp.setCancellationPolicyCostsMayChange(offer.isCancellationPolicyCostsMayChange() ? Boolean.valueOf(true) : null);
        CancellationPolicy cancellationPolicy = offer.getCancellationPolicy();
        if (cancellationPolicy != null) {
            if (cancellationPolicy instanceof CancellablePolicy) {
                hp.setCancellableNow(Boolean.valueOf(((CancellablePolicy)cancellationPolicy).isCancellableNow()));
                CancellablePolicy cancellablePolicy = (CancellablePolicy)cancellationPolicy;
                CancellationChargeHolder chargesHolder = cancellablePolicy.getCancellationChargesHolder();
                if (chargesHolder != null) {
                    boolean isCancellable = false;
                    for (CancellationCharge charge : chargesHolder.getCancellationCharges()) {
                        isCancellable = isCancellable || !BooleanUtil.nullAsFalse((Boolean)charge.getNotAvailableViaAPI());
                        hp.getCancellationCharges().add(charge);
                    }
                    hp.setCancellable(isCancellable || chargesHolder.getFreeCancellationTerm() != null);
                    hp.setFreeCancellationTerm(chargesHolder.getFreeCancellationTerm());
                } else {
                    hp.setCancellable(true);
                }
            } else {
                hp.setCancellable(false);
                CancellationCharge cancellationCharge = new CancellationCharge();
                cancellationCharge.setStartDate(issueDate);
                BigDecimal total = hp.getRooms().stream().map(Room::getEquivalentPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                Money allMoney = MoneyHelper.buildMoney((BigDecimal)total, (String)gdsCurrency);
                CancellationChargeHelper.fillCancellationCharge((CancellationCharge)cancellationCharge, (Money)allMoney, (String)gdsCurrency, (boolean)HotelProductHelper.includeVat((HotelProduct)hp));
                RateMoney penalty = cancellationCharge.getPenalty();
                cancellationCharge.setPolicyText(penalty.toString());
                cancellationCharge.setWithTime(true);
                hp.getCancellationCharges().add(cancellationCharge);
            }
            hp.setCancellationPolicyText(cancellationPolicy.getText());
        }
        room.setNumberOfPeople(Integer.valueOf(offer.getRoomInfo().getStandardNumberOfGuests()));
        offer.getRoomInfo().getTravellers().forEach(t -> HotelsHelper.addTraveller((HotelProduct)hp, (Room)room, (Traveller)t, (DictionaryReference)HotelsReservationHelper.getTravellerPassengerType((Traveller)t)));
        HotelsHelper.setHotelCommission((HotelProduct)hp, (HotelProductCommission)offer.getHotelCommission());
        if (offer.getMinClientPrice() != null && CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference)salesContext.getClient(), (CalculatedStatisticType)CalculatedStatisticType.MIN_PRICE_HOTEL)) {
            if (hp.getStatisticalData() == null) {
                hp.setStatisticalData(new StatisticalData());
            }
            hp.getStatisticalData().setMinPriceHotel(offer.getMinClientPrice());
        }
        if (offer.getMinClientPriceByNight() != null && CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference)salesContext.getClient(), (CalculatedStatisticType)CalculatedStatisticType.MIN_PRICE_PER_ROOM)) {
            if (hp.getStatisticalData() == null) {
                hp.setStatisticalData(new StatisticalData());
            }
            hp.getStatisticalData().setMinPricePerRoom(Double.valueOf(offer.getMinClientPriceByNight().doubleValue()));
        }
        if (offer.getRackRate() != null && CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference)salesContext.getClient(), (CalculatedStatisticType)CalculatedStatisticType.RACK_RATE_PRICE)) {
            if (hp.getStatisticalData() == null) {
                hp.setStatisticalData(new StatisticalData());
            }
            hp.getStatisticalData().setRackRatePrice(offer.getRackRate().getValue());
        }
        HotelProductVatFiller.updateVat((HotelProduct)hp);
        HotelProductHelper.updateFops((HotelProduct)hp);
        return hp;
    }

    public static void repriceReservation(Reservation reservation) {
        for (BaseProduct bp : reservation.getProducts()) {
            HotelProduct product = (HotelProduct)bp;
            HotelDirectContractHelper.checkProductStatus(reservation, product);
            HotelsHelper.updateProductSystemNumber((HotelProduct)product);
            product.setContractRulesApplied(false);
        }
    }

    public static void ticketReservation(Reservation reservation) {
        for (BaseProduct bp : reservation.getProducts()) {
            HotelProduct product = (HotelProduct)bp;
            HotelDirectContractHelper.checkProductStatus(reservation, product);
            product.setStatus(ProductStatus.REQUEST);
            HotelProductHelper.setOnHold((HotelProduct)product, (boolean)true);
            product.setIssueDate(new Date());
            HotelsHelper.updateProductSystemNumber((HotelProduct)product);
            product.setContractRulesApplied(false);
        }
        reservation.setResDate(new Date());
    }

    private static void checkProductStatus(Reservation reservation, HotelProduct product) {
        if (product.getStatus() != ProductStatus.INTENTION) {
            throw Xeption.forAdmin((String)"\u0412 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 {0} \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u044b.", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)});
        }
    }
}

