/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.hotels.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CheckAdditionServicesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map addSrv = (Map)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.OLD_ADDITIONAL_SERVICES);
        for (BaseProduct bp : reservation.getProducts()) {
            HotelProduct product = (HotelProduct)bp;
            Collection list = (Collection)addSrv.get(product);
            if (null == list) continue;
            List toCheck = product.getAdditionalServices();
            for (AdditionalService as : list) {
                AdditionalService nas = this.findService(toCheck, as);
                if (null != nas) continue;
                switch (as.getType()) {
                    case EARLIER_CHECKIN: {
                        product.getNotConfirmedAdditionalServices().add(as);
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.HOTELS_CANT_TICKET_EARLIER_CHECK_IN, (Object[])new Object[0]));
                        break;
                    }
                    case LATER_CHECKOUT: {
                        product.getNotConfirmedAdditionalServices().add(as);
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.HOTELS_CANT_TICKET_LATER_CHECK_OUT, (Object[])new Object[0]));
                        break;
                    }
                    case MEAL: {
                        product.getNotConfirmedAdditionalServices().add(as);
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.HOTELS_CANT_TICKET_MEAL, (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    private AdditionalService findService(Collection<AdditionalService> list, AdditionalService as) {
        if (as.getType() == AdditionalServiceType.EARLIER_CHECKIN) {
            return list.stream().filter(a -> a.getType() == AdditionalServiceType.EARLIER_CHECKIN).findFirst().orElse(null);
        }
        if (as.getType() == AdditionalServiceType.LATER_CHECKOUT) {
            return list.stream().filter(a -> a.getType() == AdditionalServiceType.LATER_CHECKOUT).findFirst().orElse(null);
        }
        if (as.getType() == AdditionalServiceType.MEAL) {
            String code = as.getCode();
            return list.stream().filter(a -> a.getType() == AdditionalServiceType.MEAL && Objects.equals(a.getCode(), code)).findFirst().orElse(null);
        }
        return null;
    }
}

