/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.hotels.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusCorrespondenceContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.RequestForHotelBookingIssue;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.hotels.ticketReservation.ReservationRequestNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;

public class PrepareHotelNotificationProcessor
extends BaseProcessor {
    private static final String EMAIL_NOT_FOUND = "\u0412 \u043e\u0442\u0435\u043b\u0435 \"%s\" \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d email \u0434\u043b\u044f \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0439";
    private static final String TEMPLATE_NOT_FOUND = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0448\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u044c\u043c\u0430 \u0432 \u043e\u0442\u0435\u043b\u044c";

    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(Targets.NOTIFICATION_TEMPLATE_HOTEL.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new NotificationsPropertySet());
        proxy.setActionSet((Object)new NotificationsActionSet());
        EntityReference supplier = null;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            HotelProduct product = (HotelProduct)baseProduct;
            HotelProductContractRelationData vendorContractRelation = HotelProductHelper.getVendorContractRelation((HotelProduct)product);
            supplier = HotelProductHelper.getSupplier((HotelProduct)product);
            if (vendorContractRelation == null) continue;
            proxy.setContractType(ContractType.VENDOR.name());
            EntityContainer contract = EntityStorage.get().resolve(vendorContractRelation.getGeneralData().getContractData().getManualContract());
            if (contract == null) {
                contract = EntityStorage.get().resolve(vendorContractRelation.getGeneralData().getContractData().getContract());
            }
            if (contract == null) continue;
            RulesHelper.applyRules((EntityContainer)contract, Collections.singletonList(proxy), (BaseProduct)product);
            break;
        }
        MailTemplate notificationTemplate = ((NotificationsActionSet)proxy.getActionSet()).getHotelNotificationTemplate();
        ctx.putObject((Enum)IBusCorrespondenceContextKeys.SEND_NOTIFICATION, (Object)false);
        if (notificationTemplate != null) {
            NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)reservation.getBookingFile().getCustomerProfile(), (EntityReference<SMSite>)reservation.getBookingFile().getSite(), this.getLocale(notificationTemplate), bookingFile.toReference(), salesContext);
            ReservationRequestNotification notification = new ReservationRequestNotification(parameters, reservation, notificationTemplate);
            MailDocument mailDocument = NotificationHelper.prepareMailDocument(notification);
            if (mailDocument != null) {
                EntityContainer hotelCtr = EntityStorageHelper.resolve((EntityReference)supplier);
                if (hotelCtr != null) {
                    Organization hotel = (Organization)hotelCtr.getEntity();
                    Optional<Communication> notificationEmail = hotel.getCommunications().stream().filter(Communication::isSendToHotel).findFirst();
                    if (notificationEmail.isPresent()) {
                        ctx.putObject((Enum)IBusCorrespondenceContextKeys.ISSUE_CLASS, RequestForHotelBookingIssue.class);
                        ctx.putObject((Enum)IBusCorrespondenceContextKeys.ISSUE_TITLE, (Object)mailDocument.getSubject());
                        ctx.putObject((Enum)IBusCorrespondenceContextKeys.ISSUE_CONTENT, (Object)new String(mailDocument.getBody().getData()));
                        ctx.putObject((Enum)IBusCorrespondenceContextKeys.HOTEL_EMAIL, (Object)notificationEmail.get());
                        ctx.putObject((Enum)IBusCorrespondenceContextKeys.BOOKING_FILE_REFERENCE, (Object)bookingFile.toReference());
                        ctx.putObject((Enum)IBusCorrespondenceContextKeys.SEND_NOTIFICATION, (Object)true);
                    } else {
                        ctx.putObject((Enum)IBusCorrespondenceContextKeys.ISSUE_EXCEPTION, (Object)String.format(EMAIL_NOT_FOUND, hotel.getFullName().toString()));
                    }
                }
            } else {
                ctx.putObject((Enum)IBusCorrespondenceContextKeys.ISSUE_EXCEPTION, (Object)TEMPLATE_NOT_FOUND);
            }
        } else {
            ctx.putObject((Enum)IBusCorrespondenceContextKeys.ISSUE_EXCEPTION, (Object)TEMPLATE_NOT_FOUND);
        }
    }

    private Locale getLocale(MailTemplate hotelNotificationTemplate) {
        if (TextUtil.nonBlank((String)hotelNotificationTemplate.getSubjectRu())) {
            return LocaleHelper.RU_LOCALE;
        }
        if (TextUtil.nonBlank((String)hotelNotificationTemplate.getSubjectEn())) {
            return LocaleHelper.EN_LOCALE;
        }
        return LocaleHelper.getCurrentLocale();
    }
}

