/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.hotels.vendorCommission;

import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.ProviderVatInfo;
import com.gridnine.xtrip.common.ibecorp.rules.HotelPreprocessingActionsResult;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelRulesHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.VatHelper;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.RulesCache;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;

public class VendorCommissionHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AppliedRule> preprocess(Collection<BaseProduct> products, Map<BaseProduct, RulesCache<?>> rulesCacheMap, Map<HotelProduct, MiscUtil.Pair<HotelOffer, EntityReference<Contract>>> offers, SalesContext salesContext) throws Exception {
        ArrayList<AppliedRule> appliedRules = new ArrayList<AppliedRule>();
        BookingFile bookingFile = null;
        for (BaseProduct bp : products) {
            HotelProduct product;
            if (!(bp instanceof HotelProduct) || (product = (HotelProduct)bp).getProvider() != HotelProvider.OSTROVOK && product.getProvider() != HotelProvider.BRONEVIK && product.getProvider() != HotelProvider.A_AND_A && product.getProvider() != HotelProvider.HOTELBOOK || product.isTripartiteAgreement()) continue;
            boolean bookingFileNeeded = product.getReservation().getBookingFile() == null;
            try {
                BigDecimal commissionAmount;
                BigDecimal prevCommissionEquivalentAmount;
                Room room;
                Money basePrice;
                HotelOffer offer;
                EntityContainer contract;
                HotelPropertySet propertySet;
                if (bookingFileNeeded) {
                    if (null == bookingFile) {
                        bookingFile = VendorCommissionHelper.buildBookingFile(salesContext);
                    }
                    product.getReservation().setBookingFile(bookingFile);
                }
                RuleProxy proxy = new RuleProxy();
                proxy.getTracer().setDisabled(true);
                proxy.setProxyType(Targets.HOTEL_PREPROCESSING.getId());
                Date date = product.getIssueDate();
                proxy.setProxyDate(date);
                proxy.setActionSet((Object)new HotelPreprocessingActionsResult());
                if (rulesCacheMap.isEmpty()) {
                    propertySet = new HotelPropertySet(proxy);
                    propertySet.init(product);
                    contract = HotelRulesHelper.getVendorContract((HotelProduct)product, new ArrayList());
                } else {
                    propertySet = (HotelPropertySet)rulesCacheMap.get(product).getPropertySet();
                    contract = (EntityContainer)CollectionUtil.head((Iterable)((Iterable)rulesCacheMap.get(product).getContracts().get(ContractType.VENDOR)));
                }
                proxy.setPropertySet((Object)propertySet);
                if (contract == null) continue;
                List ruleContainers = ProfileHelper.getRuleContainers((EntityContainer)contract, (Date)date);
                for (EntityContainer rc : ruleContainers) {
                    RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ProfileHelper.getRuleSet((EntityContainer)rc));
                }
                HotelOffer hotelOffer = offer = offers != null ? (HotelOffer)offers.get(product).getFirst() : null;
                RuleResultValue commission = ((HotelPreprocessingActionsResult)proxy.getActionSet()).getProviderCommission();
                if (null == commission || null == (basePrice = (room = (Room)product.getRooms().get(0)).getBasePrice()) || basePrice.getValue() == null) continue;
                String currency = (String)MiscUtil.guarded((Object)basePrice.getCurrency(), (Object)DictHelper.getLocalCurrency());
                HotelProductCommission hotelCommission = new HotelProductCommission();
                hotelCommission.setManual(true);
                String cc = (String)MiscUtil.guarded((Object)commission.getCurrencyCode(), (Object)DictHelper.getLocalCurrency());
                BigDecimal bigDecimal = prevCommissionEquivalentAmount = product.getHotelAggrCommission() != null ? MiscUtil.guarded((BigDecimal)product.getHotelAggrCommission().getEquivalentAmount()) : BigDecimal.ZERO;
                if (!"%".equals(commission.getCurrencyCode())) {
                    BigDecimal prevCommissionAmount = VendorCommissionHelper.getAmount(prevCommissionEquivalentAmount, currency, cc, product.getIssueDate(), (EntityReference<? extends BaseCommissionProperties>)commission.getTarget());
                    hotelCommission.setAmount(MoneyHelper.buildMoney((BigDecimal)prevCommissionAmount.add(BigDecimal.valueOf(commission.getValue())), (String)cc));
                    commissionAmount = VendorCommissionHelper.getAmount(BigDecimal.valueOf(commission.getValue()), cc, currency, product.getIssueDate(), (EntityReference<? extends BaseCommissionProperties>)commission.getTarget());
                } else {
                    BigDecimal rate = BigDecimal.valueOf(commission.getValue());
                    EntityContainer commissionPropertiesCtr = EntityStorage.get().resolve(commission.getTarget());
                    commissionAmount = basePrice.getValue().multiply(rate).multiply(BigDecimal.valueOf(0.01));
                    if (commissionPropertiesCtr != null) {
                        CommissionProperties commissionProperties = (CommissionProperties)commissionPropertiesCtr.getEntity();
                        commissionAmount = MulticurrencyHelper.roundDouble((BigDecimal)commissionAmount, (RoundingMode)commissionProperties.getRoundingMode(), (RoundingValue)commissionProperties.getRoundingValue());
                    }
                    hotelCommission.setAmount(MoneyHelper.buildMoney((BigDecimal)prevCommissionEquivalentAmount.add(commissionAmount), (String)currency));
                }
                basePrice.setValue(basePrice.getValue().add(commissionAmount));
                for (CancellationCharge ch : product.getCancellationCharges()) {
                    Money money;
                    BigDecimal penaltyAmount;
                    if (ch.getPenalty() == null || MiscUtil.isZero((BigDecimal)(penaltyAmount = (money = ch.getPenalty().getMoney()).getValue()), (boolean)true)) continue;
                    money.setValue(penaltyAmount.add(commissionAmount));
                    CancellationChargeHelper.fillCancellationCharge((CancellationCharge)ch, (Money)money, (boolean)HotelProductHelper.includeVat((HotelProduct)product));
                }
                commissionAmount = prevCommissionEquivalentAmount.add(commissionAmount);
                hotelCommission.setEquivalentAmount(commissionAmount);
                if (offer != null) {
                    offer.setHotelCommission(hotelCommission);
                    offer.setBasePrice(MoneyHelper.cloneMoney((Money)basePrice));
                    ProviderVatInfo vatInfo = offer.getProviderVatInfo();
                    vatInfo.setAmount(null);
                }
                room.setEquivalentPrice(basePrice.getValue());
                if (BooleanUtils.isTrue((Boolean)room.getVat()) && !BigDecimal.ZERO.equals(room.getVatAmount())) {
                    room.setVatAmount(null);
                    room.setEquivalentVatPrice(VatHelper.calcVatAmount((BigDecimal)room.getEquivalentPrice(), (Double)room.getEquivVatRate()));
                }
                HotelsHelper.setHotelCommission((HotelProduct)product, (HotelProductCommission)hotelCommission);
                product.setContractRulesApplied(false);
                appliedRules.addAll(RulesHelper.calcAppliedRulesToBooking((RuleProxy)proxy, (Set)proxy.getAppliedRules(), (List)ruleContainers, (BaseProduct)product, (EntityContainer)contract));
                product.setChecked(false);
                HotelProductHelper.updateFops((HotelProduct)product);
            }
            finally {
                if (!bookingFileNeeded) continue;
                product.getReservation().setBookingFile(null);
            }
        }
        appliedRules.forEach(appliedRule -> appliedRule.setHotelPreprocessingRule(true));
        return appliedRules;
    }

    private static BigDecimal getAmount(BigDecimal amount, String currency, String toCurrency, Date date, EntityReference<? extends BaseCommissionProperties> target) {
        String toCurrency2 = (String)MiscUtil.guarded((Object)toCurrency, (Object)DictHelper.getLocalCurrency());
        if (Objects.equals(currency, toCurrency2)) {
            return amount;
        }
        ExchangeRateData rate = MulticurrencyHelper.buildExchangeRateData((String)currency, (String)toCurrency2, null, (Date)date, null, (boolean)false);
        EntityContainer commissionPropertiesCtr = EntityStorage.get().resolve(target);
        if (commissionPropertiesCtr != null) {
            CommissionProperties commissionProperties = (CommissionProperties)commissionPropertiesCtr.getEntity();
            rate.setRoundingMode(commissionProperties.getRoundingMode());
            rate.setRoundingValue(commissionProperties.getRoundingValue());
        }
        return MulticurrencyHelper.convert((BigDecimal)amount, (ExchangeRateData)rate);
    }

    private static BookingFile buildBookingFile(SalesContext salesContext) {
        BookingFile bf = new BookingFile();
        bf.setAgency(salesContext.getAgency());
        bf.setCustomerProfile(salesContext.getClient());
        bf.setCreateDate(new Date());
        bf.setAgency(salesContext.getAgency());
        bf.setCustomerProfile(salesContext.getClient());
        if (salesContext.getCustomer() != null) {
            Customer customer = bf.getCustomer();
            customer.setProfile(salesContext.getCustomer());
        }
        bf.setSite(salesContext.getSite());
        return bf;
    }

    public static class ContractKey {
        EntityContainer<Contract> contract;
        Date date;

        public ContractKey clone() {
            ContractKey result = new ContractKey();
            result.contract = this.contract;
            result.date = this.date;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContractKey that = (ContractKey)o;
            return Objects.equals(this.contract, that.contract) && Objects.equals(this.date, that.date);
        }

        public int hashCode() {
            return Objects.hash(this.contract, this.date);
        }
    }
}

