/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersProperties;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public class ApplicableGdsAccountsProvider
extends BaseTargetsProvider<EntityContainer<BaseRailGdsAccount>> {
    private String searchParametersName;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.searchParametersName = parameters.get("parameters-name");
    }

    public Collection<EntityContainer<BaseRailGdsAccount>> getTargets(MessageContext ctx) throws Exception {
        RzdAbstractSearchParameters params = (RzdAbstractSearchParameters)ctx.getMandatoryObject(this.searchParametersName);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        Boolean proxyTracerEnabled = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED);
        if (proxyTracerEnabled == null) {
            proxyTracerEnabled = Boolean.FALSE;
        }
        proxy.getTracer().setDisabled(proxyTracerEnabled == false);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdParametersProperties(params, salesContext, null, proxy));
        proxy.setActionSet((Object)new RzdParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        if (accountCtr != null) {
            if (((BaseRailGdsAccount)accountCtr.getEntity()).getGds() == null) {
                throw Xeption.forAdmin((String)"\u0423 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.", (Object[])new Object[]{((BaseRailGdsAccount)accountCtr.getEntity()).getName()});
            }
            if (!((RzdParametersActions)proxy.getActionSet()).getApplicableGdsAccounts().contains(accountCtr.toReference())) {
                return Collections.emptyList();
            }
            return Collections.singleton(accountCtr);
        }
        HashSet<EntityContainer<BaseRailGdsAccount>> result = new HashSet<EntityContainer<BaseRailGdsAccount>>();
        for (EntityReference ref : ((RzdParametersActions)proxy.getActionSet()).getApplicableGdsAccounts()) {
            if (ref == null) continue;
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            BaseGdsAccount entity = (BaseGdsAccount)ctr.getEntity();
            if (!(entity instanceof BaseRailGdsAccount)) {
                throw Xeption.forAdmin((String)"\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0432 \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u0445 \u0441\u0430\u0439\u0442\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0436/\u0434 \u0431\u0438\u043b\u0435\u0442\u043e\u0432.", (Object[])new Object[]{ref.getCaption()});
            }
            if (this.validGdsAccount((EntityContainer<BaseRailGdsAccount>)ctr)) {
                result.add((EntityContainer<BaseRailGdsAccount>)ctr);
                continue;
            }
            throw Xeption.forAdmin((String)"\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}.", (Object[])new Object[]{ref.getCaption()});
        }
        return result;
    }

    private boolean validGdsAccount(EntityContainer<BaseRailGdsAccount> ctr) {
        if (ctr == null) {
            return false;
        }
        return ((BaseRailGdsAccount)ctr.getEntity()).getGds() != null;
    }
}

