/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.server.gds.ibus.tracing.BookingTracingHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class BookingTracingAdvice
extends BaseAdvice {
    private String operation;

    public void configure(Map<String, String> params) throws Exception {
        this.operation = params.get("operation");
    }

    public void before(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        String prefix = gdsAccountCtr != null ? ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName() : null;
        String bookingNumber = reservation != null && reservation.getBookingFile() != null ? reservation.getBookingFile().getNumber() : null;
        String fullOperationName = prefix == null ? this.operation : prefix.concat("-").concat(this.operation);
        BookingTracingHelper.startNewDocument((String)fullOperationName, (String)bookingNumber);
    }

    public void after(MessageContext ctx) throws Exception {
        Document traceDoc = BookingTracingHelper.finishDocument();
        RailwayHelper.addDocumentToBookingFileContext((BaseFileDocument)traceDoc, ctx);
    }
}

