/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.tracing.BookingTracingHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.HttpItemTracingParams;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.HttpTraceElementGenerator;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import org.w3c.dom.Element;

public class HttpItemTracingAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_HTTP_INVOKER_START, (Object)System.currentTimeMillis());
    }

    public void after(MessageContext ctx) throws Exception {
        Long startTime = (Long)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_HTTP_INVOKER_START);
        long endTime = System.currentTimeMillis();
        HttpRequest request = (HttpRequest)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_REQUEST);
        HttpResponse response = (HttpResponse)ctx.getObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        HttpItemTracingParams tracingParams = (HttpItemTracingParams)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRACING_PART_PARAMETERS);
        BookingTracingHelper.addTraceData((BookingTracingHelper.TraceItem)new HttpTraceItem(request, response, tracingParams, startTime, endTime));
    }

    static class HttpTraceItem
    extends BookingTracingHelper.TraceItem {
        private final Element traceElement;

        public HttpTraceItem(HttpRequest request, HttpResponse response, HttpItemTracingParams tracingParams, long startTime, long endTime) {
            this.traceElement = new HttpTraceElementGenerator(request, response, (HttpItemTracingParams)MiscUtil.guarded((Object)tracingParams, (Object)new HttpItemTracingParams()), startTime, endTime).generate();
        }

        public Element getTraceEl() {
            return this.traceElement;
        }
    }
}

