/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.HttpItemTracingParams;
import com.gridnine.xtrip.server.model.ibus.http.HttpInvoker;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpTraceElementGenerator {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static Logger log = LoggerFactory.getLogger(HttpTraceElementGenerator.class);
    private final HttpRequest request;
    private final HttpResponse response;
    private final HttpItemTracingParams tracingParams;
    private final long startTime;
    private final long endTime;
    private Element traceEl;
    private Document doc;

    public HttpTraceElementGenerator(HttpRequest request, HttpResponse response, HttpItemTracingParams tracingParams, long startTime, long endTime) {
        this.request = request;
        this.response = response;
        this.tracingParams = tracingParams;
        this.startTime = startTime;
        this.endTime = endTime;
        this.doc = DocumentBuilderHelper.newDocument();
        this.traceEl = this.doc.createElement("transaction");
        this.doc.appendChild(this.traceEl);
    }

    public Element generate() {
        String url = HttpInvoker.buildUrl((HttpRequest)this.request);
        Element urlElement = XHelper.writeString((Element)this.traceEl, (String)"url", (String)url);
        if (this.request.getRequestMethod() != null) {
            urlElement.setAttribute("method", this.request.getRequestMethod().name());
        }
        if (this.tracingParams.isShowUrlSuffixInTransaction()) {
            this.traceEl.setAttribute("command", this.getUrlSuffix(url));
        }
        this.setStartAttribute();
        this.setHeaders();
        this.setRequest();
        this.setResponse();
        this.setTiming();
        return this.traceEl;
    }

    private void setRequest() {
        this.writeTextBytes("text/xml", this.traceEl, "request", this.request.getBody(), false);
    }

    private void writeDecodedRequestBody() {
        if (this.request.getBody() != null) {
            try {
                String body = new String(this.request.getBody());
                String decoded = URLDecoder.decode(body, DEFAULT_CHARSET);
                if (!body.equals(decoded)) {
                    this.writeTextBytes("text/xml", this.traceEl, "request-decoded", decoded.getBytes());
                }
            }
            catch (UnsupportedEncodingException e) {
                log.warn("decode error", (Throwable)e);
            }
        }
    }

    private void setResponse() {
        if (this.response == null) {
            XHelper.writeString((Element)this.traceEl, (String)"response", (String)"response is null");
        } else {
            Element responseEl = this.doc.createElement("response");
            this.traceEl.appendChild(responseEl);
            XHelper.writeInt((Element)responseEl, (String)"code", (int)this.response.getResponseCode());
            XHelper.writeString((Element)responseEl, (String)"message", (String)this.response.getResponseMessage());
            String contentType = this.response.getContentType();
            this.writeTextBytes(contentType, responseEl, "body", this.response.getBody(), true);
            this.writeTextBytes(contentType, responseEl, "error", this.response.getError());
        }
    }

    private void setHeaders() {
        if (this.tracingParams.isShowHeaders() && !this.request.getRequestProperties().isEmpty()) {
            Element headersEl = this.doc.createElement("headers");
            this.traceEl.appendChild(headersEl);
            for (Map.Entry entry : this.request.getRequestProperties().entrySet()) {
                XHelper.writeString((Element)headersEl, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
    }

    private void setStartAttribute() {
        this.traceEl.setAttribute("start", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.startTime)));
    }

    private void setTiming() {
        long timing = this.endTime - this.startTime;
        float seconds = (float)timing % 60000.0f / 1000.0f;
        int minutes = (int)(timing / 60000L);
        this.traceEl.setAttribute("timing", String.format("%d min, %s sec", minutes, Float.valueOf(seconds)));
    }

    private String getUrlSuffix(String url) {
        if (TextUtil.isBlank((String)url)) {
            return null;
        }
        int ind = url.lastIndexOf("/");
        if (ind == -1) {
            return null;
        }
        int endInd = url.lastIndexOf("?");
        return endInd == -1 ? url.substring(ind + 1) : url.substring(ind + 1, endInd);
    }

    private void writeTextBytes(String contentType, Element el, String path, byte[] bytes) {
        this.writeTextBytes(contentType, el, path, bytes, false);
    }

    private void writeTextBytes(String contentType, Element el, String path, byte[] bytes, boolean checkXML) {
        block8: {
            if (bytes == null) {
                return;
            }
            boolean isText = TextUtil.isBlank((String)contentType) || contentType.toLowerCase().contains("text/") || contentType.toLowerCase().contains("/json") || contentType.toLowerCase().contains("/xml");
            boolean isXml = checkXML && contentType != null && contentType.toLowerCase().contains("/xml");
            String charset = this.getCharset(contentType);
            if (isText) {
                try {
                    String text = new String(bytes, charset);
                    if (isXml) {
                        try {
                            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                            Element dataEl = builder.parse(new ByteArrayInputStream(bytes)).getDocumentElement();
                            Element pathEl = XmlUtil.addElement((Element)el, (String)path);
                            pathEl.appendChild(this.doc.importNode(dataEl, true));
                        }
                        catch (Exception e) {
                            XHelper.writeString((Element)el, (String)path, (String)text, (boolean)true);
                        }
                        break block8;
                    }
                    XHelper.writeString((Element)el, (String)path, (String)text, (boolean)true);
                }
                catch (UnsupportedEncodingException e) {
                    XHelper.writeBytes((Element)el, (String)path, (byte[])bytes);
                }
            } else {
                XHelper.writeBytes((Element)el, (String)path, (byte[])bytes);
            }
        }
    }

    private String getCharset(String contentType) {
        String value;
        String[] arr;
        if (contentType == null) {
            return DEFAULT_CHARSET;
        }
        String result = null;
        int ind = contentType.indexOf("charset=");
        if (ind != -1 && (arr = (value = contentType.substring(ind)).split("[=;]")).length > 1) {
            result = arr[1].trim();
        }
        return TextUtil.isBlank(result) ? DEFAULT_CHARSET : result;
    }
}

