/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarPlaceType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttribute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttributeEx;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchWithTimeParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainSeatPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.DictValidationHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.railway.model.helpers.CommonRailwayHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.CarriageCardId;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RailwayHelper {
    public static final Set<RailwayMcoCategory> BAGGAGE_MCO_CATEGORIES = EnumSet.of(RailwayMcoCategory.HAND_BAGGAGE, RailwayMcoCategory.PET_BAGGAGE, RailwayMcoCategory.LUGGAGE_IN_RAILWAY_ROOM, RailwayMcoCategory.OVERSIZED_BAGGAGE, RailwayMcoCategory.CAR_BAGGAGE);
    public static final Pattern GENDER_PATTERN = Pattern.compile("(?<=\\D)|(?=\\D)");
    private static final Map<String, CarriageCardId> kzhSchemaMap = new HashMap<String, CarriageCardId>();
    private static final Map<String, CarriageCardId> subTypeMap = new HashMap<String, CarriageCardId>();
    private static final Set<String> lastochkaI = new HashSet<String>();
    private static final Set<String> lastochkaII = new HashSet<String>();
    private static final Set<String> lastochkaIII = new HashSet<String>();
    private static final Set<String> lastochkaIV = new HashSet<String>();
    public static final String RESPONSE_BYTES_TAG = "body";
    private static final String GET_TRAIN_SEATS_TRACE_TEMPORAL_OBJECT_UID = "railway:get-train-seats-trace";
    private static final String NULL_PLACE_NUMBER = "000";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Element getHttpResponseElement(HttpResponse httpResponse, boolean haveToParseXml) throws Exception {
        if (httpResponse == null) {
            throw Xeption.forDeveloper((String)"HttpResponse is null.", (Object[])new Object[0]);
        }
        if (httpResponse.getResponseCode() != 200) {
            throw Xeption.forAdmin((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441.", (Object[])new Object[0]);
        }
        byte[] body = httpResponse.getBody();
        Element responseEl = null;
        if (!haveToParseXml) return RailwayHelper.createBytesElement(body, "response");
        try {
            if (body == null) return responseEl;
            return DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(body)).getDocumentElement();
        }
        catch (SAXException e) {
            String mes = String.format("%s\n%s", e.getMessage(), new String(body));
            throw Xeption.forDeveloper((String)mes, (Throwable)e, (Object[])new Object[0]);
        }
    }

    private static Element createBytesElement(byte[] content, String name) {
        Document doc = DocumentBuilderHelper.newDocument();
        Element result = doc.createElement(name);
        doc.appendChild(result);
        XHelper.writeBytes((Element)result, (String)RESPONSE_BYTES_TAG, (byte[])content);
        return result;
    }

    public static DictionaryReference<RailwayStation> getRailwayStationDictReferenceByCode(String code) {
        return DictHelper.toReference((BaseDictionary)DictionaryCache.get().lookup(RailwayStation.class, code, new String[0]).stream().findFirst().orElse(null));
    }

    public static void validateSearchWithTimeParameters(RzdSearchWithTimeParameters params, SalesContext salesContext, Date minimumDate, boolean checkDateExceedDaysFromNow) throws Exception {
        RailwayHelper.validateSearchParameters((RzdAbstractSearchParameters)params, salesContext, minimumDate, checkDateExceedDaysFromNow);
        if (params.getTimeFrom() != null && (params.getTimeFrom() < 0 || params.getTimeFrom() > 23)) {
            params.getValidationContext().getTimeFromValidationMessages().add(RzdValidationMessages.getIvalidValueNumberRange((int)0, (int)23));
        }
        if (params.getTimeTo() != null && (params.getTimeTo() < 1 || params.getTimeTo() > 24)) {
            params.getValidationContext().getTimeToValidationMessages().add(RzdValidationMessages.getIvalidValueNumberRange((int)1, (int)24));
        }
        if (params.getTimeFrom() != null && params.getTimeTo() != null && params.getTimeFrom() > params.getTimeTo()) {
            params.getValidationContext().getTimeToValidationMessages().add(RzdValidationMessages.getIvalidValueEndRangeMoreStartRange());
        }
    }

    public static void validateSearchParameters(RzdAbstractSearchParameters params, SalesContext salesContext, Date minimumDate, boolean checkDateExceedDaysFromNow) throws Exception {
        RailwayHelper.validateDepartuteAndArrival((DictionaryReference<RailwayStation>)params.getDeparture(), (DictionaryReference<RailwayStation>)params.getArrival(), params.getValidationContext().getDepartureValidationMessages(), params.getValidationContext().getArrivalValidationMessages());
        RailwayHelper.validateDepartureDate(params.getDepartureDate(), (DictionaryReference<RailwayStation>)params.getDeparture(), (DictionaryReference<RailwayStation>)params.getArrival(), salesContext, minimumDate, params.getValidationContext().getDepartureDateValidationMessages(), checkDateExceedDaysFromNow);
    }

    public static void validateDepartuteAndArrival(DictionaryReference<RailwayStation> departure, DictionaryReference<RailwayStation> arrival, Collection<ValidationMessage> departureMessages, Collection<ValidationMessage> arrivalMessages) {
        DictValidationHelper.validateDictRef(departure, departureMessages);
        DictValidationHelper.validateDictRef(arrival, arrivalMessages);
        if (departure != null && departure.equals(arrival)) {
            arrivalMessages.add(RzdValidationMessages.getArrivalEqualsDeparture());
        }
    }

    public static void validateDepartureDate(Date departureDate, DictionaryReference<RailwayStation> departure, DictionaryReference<RailwayStation> arrival, SalesContext salesContext, Date minimumDate, Collection<ValidationMessage> messages, boolean checkDateExceedDaysFromNow) throws Exception {
        if (departureDate == null) {
            messages.add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            DateInterval di = new DateInterval(MiscUtil.clearTime((Date)new Date()), MiscUtil.clearTime((Date)departureDate));
            if (di.getDuration(5) < 0) {
                messages.add(RzdValidationMessages.getPastDate());
            }
            if (minimumDate != null && departureDate.before(MiscUtil.clearTime((Date)minimumDate))) {
                messages.add(RzdValidationMessages.getUnavailableDate());
            }
            if (checkDateExceedDaysFromNow) {
                int maxDay = MiscUtil.guarded((Integer)RailwayHelper.calcDaysLimit(salesContext, departure, arrival));
                if (di.getDuration(5) >= maxDay) {
                    messages.add(RzdValidationMessages.getDateExceedDaysFromNow((int)maxDay));
                }
            }
        }
    }

    public static Integer calcDaysLimit(SalesContext salesContext, DictionaryReference<RailwayStation> departureLocation, DictionaryReference<RailwayStation> arrivalLocation) throws Exception {
        RzdSearchTrainsParameters searchParams = new RzdSearchTrainsParameters();
        searchParams.setDeparture(departureLocation);
        searchParams.setArrival(arrivalLocation);
        return IbecorpRulesHelper.calcSearchDaysLimit(salesContext, (RzdAbstractSearchParameters)searchParams);
    }

    public static String generateReservationUid(String trainUid, String categoryUid) {
        return trainUid + "_" + categoryUid;
    }

    public static String generateReservationUid(RzdTrainSeatPrice seatPrice) {
        return seatPrice.getUid();
    }

    public static boolean updateEReg(RailwayProduct product, boolean isEReg) {
        for (RailwaySegment segment : product.getSegments()) {
            if (segment.isHasEReg() == isEReg) {
                return false;
            }
            segment.setHasEReg(isEReg);
        }
        return true;
    }

    public static RailwayProduct refundRailwayProduct(Reservation reservation, RailwayProduct product, EntityReference<Person> agentRef, RefundTransactionInfo.BlankPrice refBlankPrice, Date refundDate) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (!RailwayHelper.canRefundProduct(reservation, product, messages)) {
            throw new Exception(MessageHelper.toString(messages));
        }
        RailwayProduct refundProduct = new RailwayProduct();
        RailwayProductHelper.copy((RailwayProduct)product, (RailwayProduct)refundProduct, (boolean)false);
        BigDecimal totalEquivalentFare = MiscUtil.guarded((BigDecimal)refBlankPrice.getPrice());
        if (!TextUtil.isBlank((String)refBlankPrice.getRefundBlankId())) {
            refundProduct.setBlankId(refBlankPrice.getRefundBlankId());
        }
        refundProduct.setIssueDate((Date)MiscUtil.guarded((Object)refundDate, (Object)new Date()));
        refundProduct.setCashier(agentRef);
        refundProduct.setStatus(ProductStatus.REFUND);
        refundProduct.setTotalEquivalentFare(totalEquivalentFare);
        RailwayHelper.updateProductVats(refundProduct, MiscUtil.guarded((BigDecimal)refBlankPrice.getTariffVat()), refBlankPrice.getTariffVatRate(), MiscUtil.guarded((BigDecimal)refBlankPrice.getServiceVat()), refBlankPrice.getServiceVatRate(), MiscUtil.guarded((BigDecimal)refBlankPrice.getPenaltyVat()), refBlankPrice.getPenaltyVatRate(), messages);
        BigDecimal penaltyFare = BigDecimal.ZERO;
        if (product.getTotalEquivalentFare() != null) {
            penaltyFare = product.getTotalEquivalentFare().subtract(totalEquivalentFare);
        }
        refundProduct.setPenalty(penaltyFare);
        refundProduct.setEndorsement(product.getEndorsement());
        refundProduct.setFareCalculationData(null);
        refundProduct.setChecked(false);
        refundProduct.setContractRulesApplied(false);
        RailwayHelper.updateEReg(refundProduct, false);
        RailwayProductHelper.updateFops((RailwayProduct)refundProduct);
        if (!reservation.getProducts().contains(refundProduct)) {
            reservation.getProducts().add(refundProduct);
            refundProduct.setPreviousProduct(product);
            product.setNextProduct(refundProduct);
        }
        return refundProduct;
    }

    private static boolean canRefundProduct(Reservation reservation, RailwayProduct product, List<Message> messages) {
        BookingFile bookingFile = reservation.getBookingFile();
        if (product.getStatus() != ProductStatus.SELL) {
            messages.add(MessageHelper.createErrorMessage((String)String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0416/\u0414 \u0431\u0438\u043b\u0435\u0442\u0430 %s \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"%s\" \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d", product.getSystemNumber(), product.getStatus(), bookingFile), (String)String.format("\u0411\u0438\u043b\u0435\u0442 \u0438\u043c\u0435\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0439 \u043e\u0442 \"%s\"", ProductStatus.SELL), (Object[])new Object[0]));
            return false;
        }
        if (product.getNextProduct() != null && product.getNextProduct().getStatus() == ProductStatus.REFUND) {
            messages.add(MessageHelper.createErrorMessage((String)String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0416/\u0414 \u0431\u0438\u043b\u0435\u0442\u0430 %s \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"%s\" \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d", product.getSystemNumber(), product.getStatus(), bookingFile), (String)"\u0411\u0438\u043b\u0435\u0442 \u0443\u0436\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d", (Object[])new Object[0]));
            return false;
        }
        if (RzdCommonHelper.isVoucherPrinted((RailwayProduct)product)) {
            messages.add(MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0416/\u0414 \u0431\u0438\u043b\u0435\u0442\u0430 {0}, \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c {1} \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 {2} \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d", (String)"\u0412\u044b\u0434\u0430\u043d \u043f\u043e\u0441\u0430\u0434\u043e\u0447\u043d\u044b\u0439 \u043a\u0443\u043f\u043e\u043d", (Object[])new Object[]{product.getSystemNumber(), product.getIbecorpRzdStatus(), bookingFile}));
            return false;
        }
        return true;
    }

    public static void addDocumentToBookingFileContext(BaseFileDocument doc, MessageContext ctx) {
        if (doc == null) {
            return;
        }
        Collection documents = (Collection)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, ArrayList::new);
        documents.add(doc);
    }

    public static void updateTimeRange(RzdSearchWithTimeParameters params) {
        if (params.getTimeFrom() == null) {
            params.setTimeFrom(Integer.valueOf(0));
        }
        if (params.getTimeTo() == null) {
            params.setTimeTo(Integer.valueOf(24));
        }
    }

    public static List<String> getSortedBlankIdsByUids(Reservation res, List<? extends BaseProduct> products) {
        HashSet<String> resultSet = new HashSet<String>();
        HashSet<String> adults = new HashSet<String>();
        for (BaseProduct baseProduct : products) {
            RailwayProduct rp = RzdCommonHelper.getProductByUid((Reservation)res, (String)baseProduct.getUid());
            if (rp == null || TextUtil.isBlank((String)rp.getBlankId())) continue;
            if (RailwayProductHelper.getPassengerTypes((RailwayProduct)rp).stream().anyMatch(DictHelper::isAdultPassengerType)) {
                adults.add(rp.getBlankId());
                continue;
            }
            resultSet.add(rp.getBlankId());
        }
        ArrayList<String> result = new ArrayList<String>(resultSet);
        result.addAll(adults);
        return result;
    }

    public static void updateProductVats(RailwayProduct product, BigDecimal equivalentVat, Double equivalentRate, BigDecimal serviceVat, Double serviceRate, List<Message> messages) {
        RailwayHelper.updateProductVats(product, equivalentVat, equivalentRate, serviceVat, serviceRate, null, null, messages);
    }

    private static void updateProductVats(RailwayProduct product, BigDecimal fareVat, Double fareRate, BigDecimal serviceVat, Double serviceRate, BigDecimal penaltyVat, Double penaltyRate, List<Message> messages) {
        product.setEquivalentVAT(null);
        product.setServiceVAT(null);
        product.setPenaltyVAT(null);
        product.setVendorVatDetalization(null);
        BigDecimal totalVat = MiscUtil.sub((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{fareVat, serviceVat}), (BigDecimal[])new BigDecimal[]{penaltyVat});
        product.setTotalEquivalentVAT(totalVat);
        if (Objects.isNull(totalVat)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u0430\u043d\u043d\u044b\u0435 \u041d\u0414\u0421 (\u0431\u043b\u0430\u043d\u043a {0})", (Object[])new Object[]{product.getBlankId()}));
            return;
        }
        ArrayList<VatComponent> vatComponents = new ArrayList<VatComponent>();
        if (Objects.nonNull(fareVat)) {
            product.setEquivalentVAT(fareVat);
            if (Objects.nonNull(fareRate)) {
                vatComponents.add(RailwayHelper.buildVatComponent(fareVat, fareRate, VatBasisType.FARE));
            } else {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0414\u043b\u044f \u041d\u0414\u0421 \u0442\u0430\u0440\u0438\u0444\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u0430\u0432\u043a\u0430 (\u0431\u043b\u0430\u043d\u043a {0})", (Object[])new Object[]{product.getBlankId()}));
            }
        }
        if (Objects.nonNull(serviceVat)) {
            product.setServiceVAT(serviceVat);
            if (Objects.nonNull(serviceRate)) {
                VatComponent serviceVc = RailwayHelper.buildVatComponent(serviceVat, serviceRate, VatBasisType.SERVICE);
                if (!MiscUtil.equals((Object)serviceVc.getBasis(), (Object)product.getServiceFare())) {
                    product.setEquivalentFare(MiscUtil.sub((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getEquivalentFare(), product.getServiceFare()}), (BigDecimal[])new BigDecimal[]{serviceVc.getBasis()}));
                    product.setServiceFare(serviceVc.getBasis());
                }
                vatComponents.add(serviceVc);
            } else {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0414\u043b\u044f \u041d\u0414\u0421 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u0430\u0432\u043a\u0430 (\u0431\u043b\u0430\u043d\u043a {0})", (Object[])new Object[]{product.getBlankId()}));
            }
        }
        if (Objects.nonNull(penaltyVat)) {
            product.setPenaltyVAT(penaltyVat);
            if (Objects.nonNull(penaltyRate)) {
                vatComponents.add(RailwayHelper.buildVatComponent(penaltyVat, penaltyRate, VatBasisType.PENALTY));
            } else {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0414\u043b\u044f \u041d\u0414\u0421 \u0448\u0442\u0440\u0430\u0444\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u0430\u0432\u043a\u0430 (\u0431\u043b\u0430\u043d\u043a {0})", (Object[])new Object[]{product.getBlankId()}));
            }
        }
        if (vatComponents.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u041d\u0414\u0421 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430 (\u0431\u043b\u0430\u043d\u043a {0})", (Object[])new Object[]{product.getBlankId()}));
            return;
        }
        VatDetalization vatDetalization = new VatDetalization();
        vatDetalization.setDetalized(true);
        vatDetalization.getComponents().addAll(vatComponents);
        product.setVendorVatDetalization(vatDetalization);
    }

    private static VatComponent buildVatComponent(BigDecimal sum, double rate, VatBasisType basisType) {
        VatComponent result = new VatComponent();
        result.setSum(sum);
        result.setRate(Double.valueOf(rate));
        result.setBasis(RailwayHelper.calcVatBasis(sum, rate));
        result.getBasisTypes().add(basisType);
        return result;
    }

    private static BigDecimal calcVatBasis(BigDecimal vat, double rate) {
        if (rate == 0.0) {
            return null;
        }
        BigDecimal result = BigDecimal.valueOf(vat.doubleValue() / rate * (100.0 + rate));
        return MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)result, (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
    }

    public static void setTrainCarTraceTemporalObjectUid(RzdCar rzdCar, String uid) {
        NamedValueHelper.setValueForName((String)GET_TRAIN_SEATS_TRACE_TEMPORAL_OBJECT_UID, (String)uid, (Collection)rzdCar.getCustomProperties());
    }

    public static String getTrainCarTraceTemporalObjectUid(List<NamedValue> customProperties) {
        return NamedValueHelper.getValueForName((String)GET_TRAIN_SEATS_TRACE_TEMPORAL_OBJECT_UID, customProperties);
    }

    public static String mergeSubCategories(String subCategory1, String subCategory2) {
        Set carriageAttributes = CarriageAttributeEx.parseCarriageAttributes((String)subCategory1);
        carriageAttributes.addAll(CarriageAttributeEx.parseCarriageAttributes((String)subCategory2));
        return carriageAttributes.stream().map(CarriageAttributeEx::toString).sorted().collect(Collectors.joining(" "));
    }

    public static String calcPlaceDemands(RzdBookingSegmentParams params) {
        PlacingRequirements placing = params.getPlacing();
        RzdPrice rzdPrice = params.getRzdPrice();
        RzdCar rzdCar = params.getRzdCar();
        Set carriageAttributesEx = CarriageAttributeEx.parseCarriageAttributes((String)rzdPrice.getSubcategory());
        boolean withPet = false;
        boolean forChild = false;
        for (CarriageAttributeEx attr : carriageAttributesEx) {
            if (attr.getAttribute() == CarriageAttribute.PETS) {
                withPet = true;
            }
            if (attr.getAttribute() != CarriageAttribute.CHILD) continue;
            forChild = true;
        }
        if (withPet) {
            return "WithPetsPlaces";
        }
        if (forChild) {
            if (RzdCommonHelper.isSeatForMotherWithChild((Integer)placing.getSeatRangeFirst(), (Integer)placing.getSeatRangeLast())) {
                return "MotherAndBabyPlaces";
            }
            return "WithBabyPlaces";
        }
        if (MiscUtil.equals((Object)CarPlaceType.WITH_CHILD, (Object)rzdCar.getCarPlaceType())) {
            return "WithBabyPlaces";
        }
        if (MiscUtil.equals((Object)CarPlaceType.WITH_PETS, (Object)rzdCar.getCarPlaceType())) {
            return "WithPetsPlaces";
        }
        if (MiscUtil.equals((Object)CarPlaceType.MOTHER_AND_BABY, (Object)rzdCar.getCarPlaceType()) && MiscUtil.equals((Object)placing.getSeatRangeFirst(), (Object)placing.getSeatRangeLast())) {
            return "MotherAndBabyPlaces";
        }
        return "NoValue";
    }

    public static RzdTraveller getRzdTraveller(String travellerUid, List<RzdTraveller> rzdTravellers) {
        return rzdTravellers.stream().filter(rzdTr -> travellerUid.equals(rzdTr.getTravellerUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find rzdTraveller with uid {0}", (Object[])new Object[]{travellerUid}));
    }

    public static String getFullFirstName(Passport psp) {
        return Stream.of(psp.getFirstName(), psp.getSecondName()).filter(TextUtil::nonBlank).collect(Collectors.joining(" "));
    }

    public static int calcTravellersSeatsCount(List<RzdTraveller> travellers) {
        int result = 0;
        for (RzdTraveller tr : travellers) {
            if (DictHelper.isInfantPassengerType((DictionaryReference)tr.getPassengerType())) continue;
            ++result;
        }
        return result;
    }

    public static DictionaryReference<RailwayStation> getCityStation(DictionaryReference<RailwayStation> stationRef) {
        DictionaryReference location = ((RailwayStation)DictionaryCache.get().resolveReference(stationRef)).getGeoLocation();
        RailwayStation station = DictionaryCache.get().getAll(RailwayStation.class).values().stream().filter(rs -> rs.getGeoLocation() != null && rs.getGeoLocation().equals((Object)location)).filter(rs -> BooleanUtils.isTrue((Boolean)rs.getMainCityStation())).findFirst().orElse(null);
        return station != null ? station.toReference() : stationRef;
    }

    public static CarriageCardId findCarriageCardId(RzdPrice rzdPrice, RzdCar rzdCar) {
        String brand;
        int carriageNumber;
        int serviceClassNumber;
        ServiceClass serviceClass = rzdPrice.getServiceClass();
        if (serviceClass != null) {
            try {
                serviceClassNumber = Integer.parseInt(serviceClass.name().replaceAll("\\D+", ""));
            }
            catch (NumberFormatException exception) {
                serviceClassNumber = -1;
            }
        } else {
            serviceClassNumber = -1;
        }
        String trainNumber = rzdCar.getTrainNumber();
        CarriageType carriageType = rzdPrice.getCategory();
        if (StringUtils.isNotBlank((String)rzdCar.getNumber())) {
            try {
                carriageNumber = Integer.parseInt(StringUtils.stripStart((String)rzdCar.getNumber(), (String)"0"));
            }
            catch (NumberFormatException exception) {
                carriageNumber = -1;
            }
        } else {
            carriageNumber = -1;
        }
        String brandToLowerCase = (brand = rzdPrice.getTrainName()) == null ? null : brand.toLowerCase();
        String schema = rzdCar.getSchema();
        String subcategory = rzdPrice.getSubcategory();
        String subType = rzdCar.getCarSubType();
        HashMap carrierCodeVariants = new HashMap();
        if (rzdPrice.getCarrier() != null) {
            carrierCodeVariants.putAll(((RailwayCarrier)DictionaryCache.get().resolveReference(rzdPrice.getCarrier())).getCodeVariants());
        }
        int availableMax = 0;
        for (String vacantSeat : rzdCar.getVacantSeats()) {
            int available = Integer.parseInt(GENDER_PATTERN.split(vacantSeat)[0]);
            availableMax = Math.max(available, availableMax);
        }
        CarriageCardId carriageCardId = null;
        if (schema != null && kzhSchemaMap.containsKey(schema)) {
            carriageCardId = kzhSchemaMap.get(schema);
        } else if (subType != null && subTypeMap.containsKey(subType)) {
            carriageCardId = subTypeMap.get(subType);
        } else if ("023\u0419".equals(trainNumber) || "024\u0419".equals(trainNumber)) {
            if (carriageType == CarriageType.K) {
                carriageCardId = CarriageCardId.MOW_PARIS_023_K;
            } else if (carriageType == CarriageType.L) {
                carriageCardId = CarriageCardId.MOW_PARIS_023_SV;
            } else if (carriageType == CarriageType.M) {
                carriageCardId = CarriageCardId.MOW_PARIS_023_LUX;
            }
        } else if (("055\u042c".equals(trainNumber) || "055\u0411".equals(trainNumber)) && carriageType == CarriageType.K) {
            carriageCardId = "\u041d\u0424".equals(subcategory) ? CarriageCardId.POLONEZ_010ZH_K : CarriageCardId.MOW_GOM_055_K_40;
        } else if ("105\u042f".equals(trainNumber) && carriageType == CarriageType.S) {
            carriageCardId = carriageNumber == 6 || carriageNumber == 8 || carriageNumber == 9 ? CarriageCardId.NUMBER_105YA_S_42 : CarriageCardId.NUMBER_105YA_S_68;
        } else if ("737\u0410".equals(trainNumber) || "738\u0410".equals(trainNumber) || "739\u0410".equals(trainNumber) || "740\u0410".equals(trainNumber) || "741\u0412".equals(trainNumber) || "742\u0412".equals(trainNumber) || "743\u0412".equals(trainNumber) && carriageType != CarriageType.P) {
            if (carriageType == CarriageType.S) {
                carriageCardId = availableMax > 42 ? CarriageCardId.MOW_BRK_68 : CarriageCardId.MOW_BRK_42;
            } else if (carriageType == CarriageType.K) {
                carriageCardId = CarriageCardId.K;
            } else if (carriageType == CarriageType.L) {
                carriageCardId = CarriageCardId.L2;
            }
        } else if ("741\u0410".equals(trainNumber) && carriageType == CarriageType.S) {
            carriageCardId = CarriageCardId.STANDARD_60_741A;
        } else if ("258\u0410".equals(trainNumber) && carriageType == CarriageType.S) {
            carriageCardId = CarriageCardId.STANDARD_62_258A;
        } else if ("017\u0411".equals(trainNumber) || "018\u0411".equals(trainNumber)) {
            if (carriageType == CarriageType.K) {
                carriageCardId = CarriageCardId.NICE_017_COUPE;
            } else if (carriageType == CarriageType.L) {
                carriageCardId = CarriageCardId.NICE_017_SV;
            } else if (carriageType == CarriageType.M) {
                carriageCardId = CarriageCardId.MOW_PARIS_023_LUX;
            }
        } else if (carriageType == CarriageType.P) {
            carriageCardId = CarriageCardId.P;
        } else if ("\u043d\u0435\u0432\u0441\u043a\u0438\u0439 \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441".equals(brandToLowerCase) || "748\u0410".equals(trainNumber) || "747\u0410".equals(trainNumber)) {
            if (carriageNumber == 12) {
                carriageCardId = CarriageCardId.NEVSKIIEXPRES_S_112;
            } else if (carriageNumber == 1 || carriageNumber == 2 || carriageNumber == 3 || carriageNumber == 5 || carriageNumber == 6 || carriageNumber == 7 || carriageNumber == 8 || carriageNumber == 9 || carriageNumber == 10 || carriageNumber == 11) {
                carriageCardId = CarriageCardId.NEVSKIIEXPRES_K_23467891011;
            } else if (carriageNumber == 4) {
                carriageCardId = CarriageCardId.NEVSKIIEXPRES_K_5;
            } else if (carriageNumber == 13) {
                carriageCardId = CarriageCardId.NEVSKII_EXPRES_K_13_CAR;
            }
        } else if ("010\u0416".equals(trainNumber) && carriageType == CarriageType.K) {
            carriageCardId = CarriageCardId.POLONEZ_010ZH_K;
        } else if (("\u043f\u043e\u043b\u043e\u043d\u0435\u0437".equals(brandToLowerCase) || "\u0432\u0430\u0440\u0448\u0430\u0432\u0430 \u0437\u0430".equals(brandToLowerCase)) && carriageType == CarriageType.K) {
            carriageCardId = CarriageCardId.POLONEZ_K;
        } else if (("\u043f\u043e\u043b\u043e\u043d\u0435\u0437".equals(brandToLowerCase) || "\u0432\u0430\u0440\u0448\u0430\u0432\u0430 \u0437\u0430".equals(brandToLowerCase)) && carriageType == CarriageType.L) {
            carriageCardId = CarriageCardId.POLONEZ_SV;
        } else if ("\u043b\u0430\u0441\u0442\u043e\u0447\u043a\u0430".equals(brandToLowerCase) || lastochkaI.contains(trainNumber) || "169\u0427".equals(trainNumber)) {
            if (lastochkaII.contains(trainNumber)) {
                if ("809\u0421".equals(trainNumber) && carriageNumber >= 6 && carriageNumber <= 10) {
                    carriageCardId = carriageNumber == 6 || carriageNumber == 10 ? CarriageCardId.LASTOCHKA_STD_6_10 : CarriageCardId.LASTOCHKA_STD_7_9;
                } else if (lastochkaIII.contains(trainNumber)) {
                    if (carriageNumber == 1 || carriageNumber == 6) {
                        carriageCardId = CarriageCardId.LASTOCHKA_723M_1;
                    } else if (carriageNumber == 2 || carriageNumber == 7) {
                        carriageCardId = CarriageCardId.LASTOCHKA_723M_2;
                    } else if (carriageNumber == 3 || carriageNumber == 8) {
                        carriageCardId = CarriageCardId.LASTOCHKA_723M_3;
                    } else if (carriageNumber == 4 || carriageNumber == 9) {
                        carriageCardId = CarriageCardId.LASTOCHKA_723M_4;
                    } else if (carriageNumber == 5 || carriageNumber == 10) {
                        carriageCardId = CarriageCardId.LASTOCHKA_723M_5;
                    }
                } else if ("715\u042f".equals(trainNumber)) {
                    if (carriageNumber == 1 || carriageNumber == 5 && serviceClass == ServiceClass.P1) {
                        carriageCardId = CarriageCardId.LASTOCHKA_715YA_1;
                    } else if (carriageNumber == 2) {
                        carriageCardId = CarriageCardId.LASTOCHKA_715YA_2;
                    } else if (carriageNumber == 3) {
                        carriageCardId = CarriageCardId.LASTOCHKA_715YA_3;
                    } else if (carriageNumber == 4) {
                        carriageCardId = CarriageCardId.LASTOCHKA_715YA_4;
                    } else if (carriageNumber == 5) {
                        carriageCardId = CarriageCardId.LASTOCHKA_715YA_5;
                    }
                } else if (carriageNumber == 1 || carriageNumber == 6) {
                    carriageCardId = CarriageCardId.LASTOCHKA_PREM_1;
                } else if (carriageNumber == 2 || carriageNumber == 7 || (carriageNumber == 3 || carriageNumber == 4) && "820\u0421".equals(trainNumber)) {
                    carriageCardId = CarriageCardId.LASTOCHKA_PREM_2;
                } else if (carriageNumber == 3 || carriageNumber == 4 || carriageNumber == 8 || carriageNumber == 9) {
                    carriageCardId = CarriageCardId.LASTOCHKA_PREM_34;
                } else if (carriageNumber == 5 || carriageNumber == 10) {
                    carriageCardId = CarriageCardId.LASTOCHKA_PREM_5;
                }
            } else if (lastochkaIV.contains(trainNumber) && ServiceClass.V3.equals((Object)serviceClass)) {
                carriageCardId = CarriageCardId.EMPTY_MAP;
            } else if (carriageNumber == 2 || carriageNumber == 3 || carriageNumber == 4 || carriageNumber == 7 || carriageNumber == 8 || carriageNumber == 9) {
                carriageCardId = CarriageCardId.LASTOCHKA_STD_234789;
            } else if (carriageNumber == 1 || carriageNumber == 5 || carriageNumber == 6 || carriageNumber == 10) {
                carriageCardId = CarriageCardId.LASTOCHKA_STD_510;
            }
        } else if ("\u0441\u0442\u0440\u0438\u0436".equals(brandToLowerCase) && carriageNumber >= 10 && carriageType != CarriageType.K) {
            carriageCardId = CarriageCardId.STRIZH_2;
        } else if ("\u0441\u0442\u0440\u0438\u0436".equals(brandToLowerCase) && (carriageNumber == 8 || carriageNumber == 9)) {
            carriageCardId = CarriageCardId.STRIZH_1;
        } else if ("\u0441\u0442\u0440\u0438\u0436".equals(brandToLowerCase) && carriageNumber < 6) {
            carriageCardId = CarriageCardId.STRIZH_LUX;
        } else if (("strizh".equals(brandToLowerCase) || "\u0441\u0442\u0440\u0438\u0436".equals(brandToLowerCase)) && ("013\u041c".equals(trainNumber) || "014\u041c".equals(trainNumber) || "706\u041d".equals(trainNumber) || "707\u041d".equals(trainNumber))) {
            if (carriageType == CarriageType.K && serviceClassNumber == 2) {
                carriageCardId = CarriageCardId.STRIZH_MB_K_CLASS_2;
            } else if (carriageType == CarriageType.M) {
                carriageCardId = serviceClass == ServiceClass.I1 ? CarriageCardId.STRIZH_MB : CarriageCardId.STRIZH_MB_I;
            } else if (carriageType == CarriageType.L && serviceClassNumber == 1) {
                carriageCardId = CarriageCardId.STRIZH_MB_L_CLASS_1;
            } else if (carriageType == CarriageType.S) {
                if (serviceClassNumber == 1) {
                    carriageCardId = CarriageCardId.STRIZH_1;
                } else if (serviceClassNumber == 2) {
                    carriageCardId = CarriageCardId.STRIZH_2;
                }
            }
        } else if (carriageType == CarriageType.K) {
            carriageCardId = rzdCar.isTwoStoreyed() ? CarriageCardId.K2 : CarriageCardId.K;
        } else if (carriageType == CarriageType.L) {
            if ("054\u0427".equals(trainNumber) || "053\u0427".equals(trainNumber)) {
                if (carriageNumber == 7) {
                    carriageCardId = CarriageCardId.GRAND_L_WAGON_7;
                } else if (serviceClass == ServiceClass.L1) {
                    carriageCardId = CarriageCardId.GRAND_L_1L;
                } else if (serviceClass == ServiceClass.E1) {
                    carriageCardId = CarriageCardId.GRAND_L_1E;
                }
            } else {
                carriageCardId = "004\u0410".equals(trainNumber) && (serviceClass == ServiceClass.U1 || serviceClass == ServiceClass.EE1) ? CarriageCardId.L3 : ("004\u0410".equals(trainNumber) && serviceClass == ServiceClass.B1 ? CarriageCardId.L : ("001\u0411".equals(trainNumber) ? CarriageCardId.L2_20 : (rzdCar.isTwoStoreyed() ? CarriageCardId.L2_TF : CarriageCardId.L2)));
            }
        } else if (carriageType == CarriageType.M) {
            if (carrierCodeVariants.containsValue("\u0413\u0420\u0410\u041d\u0414")) {
                if (serviceClass == ServiceClass.G1) {
                    carriageCardId = CarriageCardId.M6;
                } else if (serviceClass == ServiceClass.N1) {
                    carriageCardId = CarriageCardId.GRAND_M_1N;
                } else if (serviceClass == ServiceClass.M1) {
                    carriageCardId = CarriageCardId.GRAND_M_1M;
                } else if (serviceClass == ServiceClass.A1 || serviceClass == ServiceClass.I1) {
                    carriageCardId = CarriageCardId.M8;
                }
            } else if (carrierCodeVariants.containsValue("\u0424\u041f\u041a")) {
                if (serviceClass == ServiceClass.A1 || serviceClass == ServiceClass.I1) {
                    carriageCardId = CarriageCardId.M8;
                } else if (serviceClass == ServiceClass.G1 || serviceClass == ServiceClass.M1) {
                    carriageCardId = CarriageCardId.M12;
                }
            } else {
                carriageCardId = CarriageCardId.M12;
            }
        } else if (carriageType == CarriageType.S && rzdCar.isTwoStoreyed() && (serviceClassNumber == 1 || serviceClassNumber == 2)) {
            carriageCardId = serviceClassNumber == 1 ? CarriageCardId.S_TF_CLASS_1 : CarriageCardId.S_TF_CLASS_2;
        } else if (carriageType == CarriageType.S) {
            carriageCardId = availableMax <= 60 ? CarriageCardId.S_60 : (availableMax <= 68 ? CarriageCardId.S_68 : CarriageCardId.S_80);
        }
        if (carriageCardId == null) {
            carriageCardId = CarriageCardId.UNIDENTIFIED;
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Carriage with UNIDENTIFIED card id received:\n").append("serviceClass = ").append(serviceClass).append(",\n").append("serviceClassNumber = ").append(serviceClassNumber).append(",\n").append("trainNumber = ").append(trainNumber).append(",\n").append("carriageType = ").append(carriageType).append(",\n").append("carriageSubType = ").append(subType).append(",\n").append("carriageNumber = ").append(carriageNumber).append(",\n").append("brandToLowerCase = ").append(brandToLowerCase).append(",\n").append("schema = ").append(schema).append(",\n").append("subcategory = ").append(subcategory).append(",\n").append("carrier = ").append(rzdPrice.getCarrier()).append(",\n").append("availableMax = ").append(availableMax);
            IncidentsLog.reportStackTrace((String)messageBuilder.toString());
        }
        return carriageCardId;
    }

    public static List<RailwayProduct> getProducts(Reservation reservation, RzdBookingSegmentParams segmentParams) {
        return BookingStreamHelper.getProductsStream((Reservation)reservation, RailwayProduct.class).filter(rp -> RailwayHelper.isSameProduct(rp, segmentParams)).collect(Collectors.toList());
    }

    private static boolean isSameProduct(RailwayProduct rp, RzdBookingSegmentParams segmentParams) {
        RailwaySegment seg = (RailwaySegment)rp.getSegments().get(0);
        if (!MiscUtil.equals((Object)seg.getCarriageNumber(), (Object)segmentParams.getRzdCar().getNumber())) {
            return false;
        }
        List<String> segmentParamsTrainNumbers = Arrays.asList(RailwayHelper.normalizeTrainNumber(segmentParams.getTrain().getNumber()), RailwayHelper.normalizeTrainNumber(segmentParams.getTrain().getDisplayNumber()));
        List<String> productTrainNumbers = Arrays.asList(RailwayHelper.normalizeTrainNumber(seg.getTrainNumber()), RailwayHelper.normalizeTrainNumber(seg.getTrainNumberOriginal()));
        return CollectionUtil.containAtLeastOneCommonElement(segmentParamsTrainNumbers, productTrainNumbers);
    }

    private static String normalizeTrainNumber(String trainNumber) {
        if (TextUtil.isBlank((String)trainNumber)) {
            return trainNumber;
        }
        return trainNumber.replaceAll("\\D", "");
    }

    public static List<String> parseSeatNumber(String seatNumberStr) {
        if (TextUtil.isBlank((String)seatNumberStr)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        List seats = TextUtil.split((String)seatNumberStr, (String)"[,;]", (boolean)true, (boolean)true);
        for (String seat : seats) {
            int rangeIndex = seat.indexOf(45);
            if (rangeIndex == -1) {
                result.add(seat);
                continue;
            }
            String startNmb = seat.substring(0, rangeIndex);
            String endNmb = seat.substring(rangeIndex + 1);
            if (TextUtil.isBlank((String)startNmb) || TextUtil.isBlank((String)endNmb)) {
                result.add(seat);
                continue;
            }
            for (int nmb = Integer.valueOf(startNmb).intValue(); nmb <= Integer.valueOf(endNmb); ++nmb) {
                result.add(String.format("%03d", nmb));
            }
        }
        result.remove(NULL_PLACE_NUMBER);
        return result;
    }

    public static List<RailwayMcoProduct> getBaggageProducts(Collection<BaseProduct> products) {
        return products.stream().filter(RailwayMcoProduct.class::isInstance).map(RailwayMcoProduct.class::cast).filter(rp -> BAGGAGE_MCO_CATEGORIES.contains(rp.getMcoCategory())).collect(Collectors.toList());
    }

    public static EntityReference<Organization> getSupplier(EntityContainer<? extends BaseRailGdsAccount> accountCtr) {
        return (EntityReference)MiscUtil.guarded((Object)CommonRailwayHelper.getSupplier((GdsName)((BaseRailGdsAccount)accountCtr.getEntity()).getGds()), (Object)((BaseRailGdsAccount)accountCtr.getEntity()).getSupplier());
    }

    static {
        kzhSchemaMap.put("KZH_1/2_V2", CarriageCardId.KZH_1_2_V2);
        kzhSchemaMap.put("KZH_3/6_V1", CarriageCardId.KZH_3_6_V1);
        kzhSchemaMap.put("KZH_O_V1", CarriageCardId.KZH_O_V1);
        kzhSchemaMap.put("KZH_TALGO_BSN1", CarriageCardId.KZH_TALGO_BSN1_12);
        kzhSchemaMap.put("KZH_TALGO_GRAND_PMR1", CarriageCardId.KZH_TALGO_GRAND_PMR1);
        kzhSchemaMap.put("KZH_TALGO_TUR1", CarriageCardId.KZH_TALGO_TUR1_18);
        kzhSchemaMap.put("KZH_TALGO_TUR2", CarriageCardId.KZH_TALGO_TUR2_20);
        kzhSchemaMap.put("KZH_TALGO_SID1", CarriageCardId.KZH_TALGO_SID1);
        kzhSchemaMap.put("KZH_TALGO_SID2", CarriageCardId.KZH_TALGO_SID2);
        subTypeMap.put("91\u0421", CarriageCardId.SAPSAN_1);
        subTypeMap.put("92\u0421", CarriageCardId.SAPSAN_2);
        subTypeMap.put("60\u0421", CarriageCardId.SAPSAN_3);
        subTypeMap.put("56\u0421", CarriageCardId.SAPSAN_4);
        subTypeMap.put("84\u0421", CarriageCardId.SAPSAN_5_15);
        subTypeMap.put("71\u0421", CarriageCardId.SAPSAN_6);
        subTypeMap.put("82\u0421", CarriageCardId.SAPSAN_7);
        subTypeMap.put("83\u0421", CarriageCardId.SAPSAN_8);
        subTypeMap.put("79\u0421", CarriageCardId.SAPSAN_10);
        subTypeMap.put("54\u0421", CarriageCardId.SAPSAN_54C);
        subTypeMap.put("55\u0421", CarriageCardId.SAPSAN_55C);
        subTypeMap.put("61\u0421", CarriageCardId.ALLEGRO_1_8);
        subTypeMap.put("62\u0421", CarriageCardId.ALLEGRO_2_9);
        subTypeMap.put("63\u0421", CarriageCardId.ALLEGRO_4_11);
        subTypeMap.put("64\u0421", CarriageCardId.ALLEGRO_5_12);
        subTypeMap.put("65\u0421", CarriageCardId.ALLEGRO_6_13);
        subTypeMap.put("66\u0421", CarriageCardId.ALLEGRO_7_14);
        subTypeMap.put("21\u041a", CarriageCardId.ARKTIKA_K);
        subTypeMap.put("35\u041a", CarriageCardId.K35);
        subTypeMap.put("36\u041a", CarriageCardId.K36);
        subTypeMap.put("80\u041a", CarriageCardId.K80);
        subTypeMap.put("71\u041a", CarriageCardId.K71);
        subTypeMap.put("72\u041a", CarriageCardId.K72);
        subTypeMap.put("82\u041a", CarriageCardId.K82);
        subTypeMap.put("31\u0421", CarriageCardId.LASTOCHKA_723M_1);
        subTypeMap.put("32\u0421", CarriageCardId.LASTOCHKA_723M_2);
        subTypeMap.put("34\u0421", CarriageCardId.LASTOCHKA_723M_4);
        subTypeMap.put("36\u0421", CarriageCardId.LASTOCHKA_45C);
        subTypeMap.put("37\u0421", CarriageCardId.LASTOCHKA_37C);
        subTypeMap.put("41\u0421", CarriageCardId.LASTOCHKA_41C);
        subTypeMap.put("42\u0421", CarriageCardId.LASTOCHKA_723M_2);
        subTypeMap.put("43\u0421", CarriageCardId.LASTOCHKA_723M_3);
        subTypeMap.put("44\u0421", CarriageCardId.LASTOCHKA_723M_4);
        subTypeMap.put("45\u0421", CarriageCardId.LASTOCHKA_45C);
        subTypeMap.put("87\u0421", CarriageCardId.LASTOCHKA_87C);
        subTypeMap.put("89\u0421", CarriageCardId.LASTOCHKA_89C);
        subTypeMap.put("90\u0421", CarriageCardId.LASTOCHKA_90C);
        subTypeMap.put("97\u0421", CarriageCardId.C97);
        subTypeMap.put("98\u0421", CarriageCardId.STRIZH_98C);
        subTypeMap.put("30\u041b", CarriageCardId.STRIZH_30L);
        subTypeMap.put("32\u041b", CarriageCardId.STRIZH_32L);
        subTypeMap.put("33\u041b", CarriageCardId.STRIZH_33L);
        subTypeMap.put("31\u041b", CarriageCardId.L31);
        subTypeMap.put("01\u041b", CarriageCardId.L2);
        subTypeMap.put("27\u041b", CarriageCardId.L27);
        subTypeMap.put("76\u041b", CarriageCardId.BRAND_76L);
        subTypeMap.put("89\u041b", CarriageCardId.IVAN_PARISTY_2);
        subTypeMap.put("44\u041f", CarriageCardId.P_44P);
        subTypeMap.put("76\u0421", CarriageCardId.S_TF_CLASS_1);
        subTypeMap.put("77\u0421", CarriageCardId.S_TF_CLASS_2);
        lastochkaI.addAll(Arrays.asList("806\u0421", "808\u0421", "806\u042d", "806\u0427", "808\u042d", "721\u0427", "723\u041c", "722\u041c", "724\u0427", "804", "806", "803", "805", "805\u0427", "809", "809\u0421", "810", "810\u0421", "728\u0413", "730\u0413", "734\u0413", "732\u0413", "732\u0413", "727\u0413", "729\u0413", "731\u0413", "735\u0413", "733\u0413", "725\u041c", "726\u041c", "733\u041c", "731\u041c", "735\u041c", "736\u041c", "732\u041c", "734\u041c", "7101", "7103", "7105", "7107", "7109", "7111", "7113", "7117", "7119", "7121", "7125", "7127", "7131", "7102", "7104", "7106", "7108", "7110", "7114", "7116", "7118", "7122", "7124", "7128", "7130", "7134", "721", "722", "7501", "7503", "7502", "7504", "7203", "7205", "7209", "7213", "7215", "7204", "7208", "7210", "7214", "7216", "7101", "7102", "7219", "7221", "7223", "7225", "7220", "7222", "7224", "7226", "7451", "7453", "7452", "7454", "7401", "7402", "7403", "7404", "814\u0421", "814\u042d", "803\u0421", "803\u0427", "815\u0421", "801\u0421", "802\u0421", "816\u0421", "804\u0421", "804\u0427"));
        lastochkaII.addAll(Arrays.asList("716\u042f", "715\u042f", "718\u0418", "718\u042f", "721\u0427", "722\u041c", "723\u041c", "724\u0427", "725\u041c", "726\u041c", "738\u0418", "738\u042f", "740\u0418", "740\u042f", "803", "803\u0427", "804", "804\u0427", "805", "805\u0427", "806", "809", "809\u0421", "809\u0412", "810", "810\u0421", "810\u0412", "811\u0412", "812\u0412", "806\u0421", "806\u042d", "806\u0427", "808\u042d", "820\u0421"));
        lastochkaIII.addAll(Arrays.asList("716\u042f", "718\u0418", "718\u042f", "723\u041c", "722\u041c", "725\u041c", "726\u041c", "738\u0418", "738\u042f", "740\u0418", "740\u042f", "809\u0412", "810\u0412", "811\u0412", "812\u0412"));
        lastochkaIV.addAll(Arrays.asList("801\u0410", "805\u0410", "803\u041c"));
    }
}

