/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.stream.Collectors;

public class RailwayReservationsProvider
extends BaseTargetsProvider<Reservation> {
    public Collection<Reservation> getTargets(MessageContext ctx) {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservationUids = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS);
        return ((BookingFile)bookingCtr.getEntity()).getReservations().stream().filter(res -> reservationUids == null || reservationUids.contains(res.getUid())).filter(this::isValidOnlineRailReservation).collect(Collectors.toList());
    }

    private boolean isValidOnlineRailReservation(Reservation reservation) {
        return BookingHelper.getTravelSubject((Reservation)reservation) == TravelSubject.RAILWAY && !CommonIbecorpHelper.isIntentionCase((Reservation)reservation) && ReservationGdsNameInfoHelper.containsOnlineRecordLocatorOfAnyType((Reservation)reservation);
    }
}

