/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class RzdSalesContextValidator
extends BaseProcessor {
    private static boolean isClient(SalesContext sc) {
        return !ProfileHelper.isRetailProfile((EntityReference)sc.getClient());
    }

    private static boolean isRailwayEnabled(SalesContext sc) throws Exception {
        return true;
    }

    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Boolean doPermissionCheck = (Boolean)ctx.getObject((Enum)IBusMidofficeContextKeys.DO_PERMISSION_CHECK);
        if ((doPermissionCheck == null || doPermissionCheck.booleanValue()) && !RzdSalesContextValidator.isRailwayEnabled(salesContext)) {
            throw Xeption.forAdmin((String)"\u0423 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 {0} \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0416\u0414-\u0443\u0441\u043b\u0443\u0433\u0435.", (Object[])new Object[]{this.getOrgInfo(salesContext)});
        }
    }

    private String getOrgInfo(SalesContext salesContext) throws Exception {
        EntityReference orgRef = RzdSalesContextValidator.isClient(salesContext) ? salesContext.getClient() : salesContext.getSubagency();
        return orgRef.getCaption().concat(" (").concat(orgRef.getUid()).concat(")");
    }

    public static boolean checkOrganizationBooleanValue(SalesContext sc, CheckOrgValue checkOrg) {
        return RzdSalesContextValidator.checkOrganizationBooleanValue(sc, checkOrg, RzdSalesContextValidator.isClient(sc));
    }

    private static boolean checkOrganizationBooleanValue(SalesContext ctx, CheckOrgValue checkOrg, boolean isClient) {
        boolean enabled;
        if (isClient) {
            EntityContainer corporateClientContainer = EntityStorage.get().resolve(ctx.getClient());
            if (corporateClientContainer == null) {
                return false;
            }
            enabled = checkOrg.checkBoolean((Organization)corporateClientContainer.getEntity());
            if (enabled) {
                enabled = RzdSalesContextValidator.checkOrganizationBooleanValue(ctx, checkOrg, false);
            }
        } else {
            EntityContainer subagentContainer = EntityStorage.get().resolve(ctx.getSubagency());
            if (subagentContainer == null) {
                return false;
            }
            enabled = checkOrg.checkBoolean((Organization)subagentContainer.getEntity());
        }
        return enabled;
    }

    public static interface CheckOrgValue {
        public boolean checkBoolean(Organization var1);
    }
}

