/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper;
import com.gridnine.xtrip.server.gds.ibus.tracing.BookingTracingHelper;
import com.gridnine.xtrip.server.gds.ibus.tracing.ExceptionTraceItem;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class RzdSearchTracingPartAdvice
extends BaseAdvice {
    private String partName;

    public void configure(Map<String, String> params) throws Exception {
        this.partName = params.get("part-name");
    }

    public void before(MessageContext ctx) throws Exception {
        BookingTracingHelper.startNewDocument((String)this.partName, null);
    }

    public void after(MessageContext ctx) throws Exception {
        GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
        if (document == null) {
            return;
        }
        byte[] traceData = BookingTracingHelper.finishTracing();
        if (traceData == null) {
            return;
        }
        GdsTracingDocumentPart docPart = new GdsTracingDocumentPart();
        docPart.setName(this.partName);
        GdsTracingHelper.setGlobalData((GdsTracingDocumentPart)docPart, (byte[])traceData);
        document.getParts().add(docPart);
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        BookingTracingHelper.addTraceData((BookingTracingHelper.TraceItem)new ExceptionTraceItem(e));
        return super.handleException(e, ctx);
    }
}

