/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainRouteParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.MultiException;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class RzdStackTraceEnricherAdvice
extends BaseAdvice {
    private final String nullString = "[null]";
    private static FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        Boolean stackTraceEnriched = (Boolean)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_STACK_TRACE_ENRICHED);
        if (BooleanUtils.isTrue((Boolean)stackTraceEnriched)) {
            return false;
        }
        try {
            RzdSearchTrainsParameters searchTrainsParams = (RzdSearchTrainsParameters)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS);
            EntityContainer gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            RzdTrain train = (RzdTrain)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN);
            RzdGetTrainSeatsParameters trainSeatsParams = (RzdGetTrainSeatsParameters)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS);
            RzdGetTrainRouteParameters trainRouteParams = (RzdGetTrainRouteParameters)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_ROUTE_PARAMETERS);
            RzdReservationCreationParameters createParams = (RzdReservationCreationParameters)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
            ArrayList<StackTraceElement> addElements = new ArrayList<StackTraceElement>();
            addElements.add(IncidentsHelper.getContextStackTraceElement((String)"GdsAccount", (String)this.gdsAccountToString((EntityContainer<BaseGdsAccount>)gdsAccountCtr)));
            if (searchTrainsParams != null) {
                addElements.add(IncidentsHelper.getContextStackTraceElement((String)"searchTrainsParams", (String)this.searchTrainsParamsToString(searchTrainsParams)));
            }
            if (train != null) {
                addElements.add(IncidentsHelper.getContextStackTraceElement((String)"Train", (String)this.trainToString(train)));
            } else if (trainSeatsParams != null) {
                addElements.add(IncidentsHelper.getContextStackTraceElement((String)"trainSeatsParams", (String)this.trainSeatsParamsToString(trainSeatsParams)));
            } else if (trainRouteParams != null) {
                addElements.add(IncidentsHelper.getContextStackTraceElement((String)"trainRouteParams", (String)this.trainRouteParamsToString(trainRouteParams)));
            }
            if (createParams != null) {
                addElements.add(IncidentsHelper.getContextStackTraceElement((String)"createParams", (String)this.createParamsToString(createParams)));
            }
            IncidentsHelper.addStackTraceElement((Throwable)e, (StackTraceElement[])addElements.toArray(new StackTraceElement[0]));
            ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_STACK_TRACE_ENRICHED, (Object)Boolean.TRUE);
        }
        catch (Throwable newEx) {
            throw new MultiException(new Throwable[]{newEx, e});
        }
        return false;
    }

    private String gdsAccountToString(EntityContainer<BaseGdsAccount> gdsAccountCtr) {
        if (gdsAccountCtr == null) {
            return "[null]";
        }
        return ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName();
    }

    private String searchTrainsParamsToString(RzdSearchTrainsParameters params) {
        if (params == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        this.addAbstractSearchParameters(sb, (RzdAbstractSearchParameters)params);
        return sb.toString();
    }

    private void addAbstractSearchParameters(StringBuilder sb, RzdAbstractSearchParameters params) {
        sb.append(DictHelper.getCode((DictionaryReference)params.getDeparture())).append("-").append(DictHelper.getCode((DictionaryReference)params.getArrival()));
        sb.append(" ").append(params.getDepartureDate() == null ? null : DF.format(params.getDepartureDate()));
    }

    private String trainToString(RzdTrain train) {
        if (train == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(train.getPassengerFrom().getCode()).append("-").append(train.getPassengerTo().getCode());
        sb.append(" ").append(DF.format(train.getDepartureDatetime()));
        sb.append("#").append(train.getNumber());
        return sb.toString();
    }

    private String trainSeatsParamsToString(RzdGetTrainSeatsParameters params) {
        if (params == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        this.addAbstractSearchParameters(sb, (RzdAbstractSearchParameters)params);
        sb.append("#").append(params.getTrainNumber());
        return sb.toString();
    }

    private String trainRouteParamsToString(RzdGetTrainRouteParameters params) {
        if (params == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(params.getDeparture());
        sb.append(" ").append(DF.format(params.getDepartureDate()));
        sb.append("#").append(params.getTrainNumber());
        return sb.toString();
    }

    private String createParamsToString(RzdReservationCreationParameters params) {
        if (params == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.segmentParamsToString(params.getSegment()));
        if (params.getSegmentBack() != null) {
            sb.append(" BACK ");
            sb.append(this.segmentParamsToString(params.getSegmentBack()));
        }
        return sb.toString();
    }

    private String segmentParamsToString(RzdBookingSegmentParams params) {
        if (params == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.trainToString(params.getTrain())).append(" ");
        if (params.getRzdPrice() != null && params.getRzdPrice().getCategory() != null) {
            sb.append(params.getRzdPrice().getCategory().name()).append("#");
        }
        if (params.getRzdCar() != null) {
            sb.append(params.getRzdCar().getNumber());
        }
        return sb.toString();
    }
}

