/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class SearchMulticallExceptionHandler
extends BaseAdvice {
    private String searchMulticallResultName;
    private String searchResultName;

    public void configure(Map<String, String> params) throws Exception {
        super.configure(params);
        this.searchMulticallResultName = params.get("search-multicall-result");
        this.searchResultName = params.get("search-result");
    }

    public boolean handleException(Throwable e, MessageContext ctx) {
        if (e instanceof MulticallException) {
            Map subrouteExceptions = ((MulticallException)e).getSubrouteExceptions();
            for (Map.Entry entry : subrouteExceptions.entrySet()) {
                this.addExceptionMessage(ctx, (EntityContainer<BaseRailGdsAccount>)((EntityContainer)entry.getKey()), (Throwable)entry.getValue());
                Map mcMap = (Map)ctx.getObject(this.searchMulticallResultName);
                if (mcMap == null) continue;
                ((MessageContext)mcMap.get(entry.getKey())).removeObject(this.searchResultName);
            }
            return true;
        }
        return false;
    }

    private void addExceptionMessage(MessageContext ctx, EntityContainer<BaseRailGdsAccount> accountCtr, Throwable exception) {
        if (exception instanceof MulticallException) {
            MulticallException me = (MulticallException)exception;
            me.getSubrouteExceptions().values().forEach(ex -> this.addExceptionMessage(ctx, accountCtr, (Throwable)ex));
            return;
        }
        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u0438 \u043f\u043e\u0438\u0441\u043a\u0435 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f '{0}' \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: {1}", (Throwable)exception, (Object[])new Object[]{accountCtr.toReference().getCaption(), exception.getMessage()}));
    }
}

