/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.checkReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class RzdReservationAddNotChangeMessage
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ProductStatus gdsStatus = (ProductStatus)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT_STATUS);
        String reservationAddInfo = (String)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_CHECK_RESERVATION_ADD_INFO);
        if (gdsStatus != null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)this.buildMessageText(gdsStatus, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), reservationAddInfo), (Object[])new Object[0]));
        }
    }

    private String buildMessageText(ProductStatus status, String recordLocator, String reservationAddInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u0441\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u043a\u0430\u0437\u0430: \u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 " + recordLocator);
        if (TextUtil.nonBlank((String)reservationAddInfo)) {
            sb.append(" (").append(reservationAddInfo).append(")");
        }
        sb.append(" \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c ");
        switch (status) {
            case BOOKING: {
                sb.append("\u0437\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c");
                break;
            }
            case VOID_BOOKING: {
                sb.append("\u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u043c");
                break;
            }
            case SELL: {
                sb.append("\u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u043c");
                break;
            }
            case REFUND: {
                sb.append("\u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u043c/\u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u043d\u044b\u043c");
                break;
            }
        }
        return sb.toString();
    }
}

