/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.checkReservation;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class RzdReservationCheckAggregator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map mcres = (Map)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_MULTICALL_RESULT);
        if (mcres == null) {
            ctx.addMessage(MessageHelper.createWarningMessage((String)"\u0441\u043f\u0438\u0441\u043e\u043a \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u043f\u0443\u0441\u0442", (Object[])new Object[0]));
        } else {
            boolean bookingWasChanged = false;
            boolean wasTicketing = false;
            boolean statusChanged = false;
            for (MessageContext subctx : mcres.values()) {
                Boolean notSupported = (Boolean)subctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_RESERVATION_CHECK_NOT_SUPPORTED);
                if (BooleanUtils.isTrue((Boolean)notSupported)) continue;
                Boolean eregChanged = (Boolean)subctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_EREG_WAS_CHANGED);
                Boolean refundChanged = (Boolean)subctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_REFUND_WAS_CHANGED);
                Boolean rzdStatusChanged = (Boolean)subctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKET_STATUS_CHANGED);
                boolean changed = BooleanUtils.isTrue((Boolean)eregChanged) || BooleanUtils.isTrue((Boolean)refundChanged) || BooleanUtils.isTrue((Boolean)rzdStatusChanged);
                Boolean wasException = (Boolean)subctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_WAS_EXCEPTION);
                if (changed) {
                    bookingWasChanged = true;
                }
                wasTicketing = wasTicketing || BooleanUtils.isTrue((Boolean)((Boolean)subctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKETED)));
                Reservation reservation = (Reservation)subctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
                Map oldStatuses = (Map)subctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_RESERVATION_OLD_STATUSES);
                for (Reservation res : RzdCommonHelper.getRelatedReservations((Reservation)reservation)) {
                    ReservationStatus status = BooleanUtils.isTrue((Boolean)wasException) ? ReservationStatus.ERROR : res.getStatus();
                    ReservationStatus statusOld = (ReservationStatus)oldStatuses.get(res);
                    String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res);
                    if (status == null) {
                        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043d\u0435\u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438.", (Object[])new Object[]{recordLocator}));
                        continue;
                    }
                    if (status != statusOld) {
                        statusChanged = true;
                        continue;
                    }
                    if (statusOld == ReservationStatus.ERROR) {
                        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 '\u041e\u0448\u0438\u0431\u043a\u0430'.", (Object[])new Object[]{recordLocator}));
                        continue;
                    }
                    if (statusOld != ReservationStatus.REQUEST) continue;
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 '\u0417\u0430\u043f\u0440\u043e\u0441'.", (Object[])new Object[]{recordLocator}));
                }
            }
            if (statusChanged || bookingWasChanged) {
                BookingFileOperationParameters parameters = (BookingFileOperationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS);
                parameters.setSaveBookingFile(true);
                ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKETED, (Object)wasTicketing);
                ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_RESERVATION_CHANGED, (Object)Boolean.TRUE);
            }
        }
    }
}

