/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.BooleanUtils;

public class BindTrainSeatsTraceToBookingProcessor
extends BaseProcessor {
    private static List<String> GDS_PARTS = Arrays.asList("gds", "gds-transactions");

    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        RzdReservationCreationParameters parameters = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Boolean wasException = (Boolean)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_WAS_EXCEPTION);
        HashSet<Object> documents = (HashSet<Object>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
        if (documents == null) {
            documents = new HashSet<Object>();
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
        }
        this.bindTrainSeatsTrace((EntityContainer<BookingFile>)bfCtr, parameters.getSegment(), wasException, documents);
        this.bindTrainSeatsTrace((EntityContainer<BookingFile>)bfCtr, parameters.getSegmentBack(), wasException, documents);
    }

    private void bindTrainSeatsTrace(EntityContainer<BookingFile> bfCtr, RzdBookingSegmentParams segmentParams, Boolean wasException, Collection<Object> documents) throws Exception {
        if (segmentParams == null) {
            return;
        }
        TemporalObject to = (TemporalObject)AssetsStorage.get().load(TemporalObject.class, RailwayHelper.getTrainCarTraceTemporalObjectUid(segmentParams.getRzdCar().getCustomProperties()));
        if (to == null) {
            return;
        }
        GdsTracingDocument document = new GdsTracingDocument();
        XUtil.fromBytes((byte[])to.getData(), (XSerializable)document);
        Optional<GdsTracingDocumentPart> opt = document.getParts().stream().filter(p -> GDS_PARTS.contains(p.getName())).findAny();
        if (opt.isPresent()) {
            GdsTracingDocumentPart part = opt.get();
            Document doc = new Document();
            doc.setContent(GdsTracingHelper.getGlobalData((GdsTracingDocumentPart)part));
            doc.setContentType(ContentType.XML);
            doc.setCreated(new Date());
            doc.setDescription(document.getName());
            doc.setName(String.format("%s.xml", document.getName()));
            doc.setOwner(bfCtr.toReference());
            doc.setNavigationKey(((BookingFile)bfCtr.getEntity()).getUid());
            doc.setType(DocumentType.GDS_LOG);
            doc.setTitle(doc.getDescription());
            documents.add(doc);
        }
        if (!BooleanUtils.isTrue((Boolean)wasException)) {
            AssetsStorage.get().delete((BaseAsset)to);
        }
    }
}

