/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersProperties;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationParamsRulesProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;

public class RzdGetGdsParametersForBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference supplierRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SUPPLIER_REF);
        Boolean proxyTracerEnabled = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED);
        boolean traceEnabled = BooleanUtils.isTrue((Boolean)proxyTracerEnabled);
        RzdParametersActions rzdParametersActions = new RzdParametersActions();
        this.applyRules(rzdParametersActions, rules, salesContext, (EntityReference<? extends BaseGdsAccount>)params.getGdsAccount(), traceEnabled);
        this.applyRulesEx(rzdParametersActions, rules, params, salesContext, (EntityReference<Organization>)supplierRef, traceEnabled);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS, (Object)rzdParametersActions);
    }

    private void applyRules(RzdParametersActions rzdParametersActions, RuleSet rules, SalesContext salesContext, EntityReference<? extends BaseGdsAccount> gdsAccountRef, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdParametersProperties(((BaseGdsAccount)EntityStorage.get().resolve(gdsAccountRef).getEntity()).getGds(), salesContext, proxy));
        proxy.setActionSet((Object)rzdParametersActions);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
    }

    private void applyRulesEx(RzdParametersActions rzdParametersActions, RuleSet rules, RzdReservationCreationParameters params, SalesContext salesContext, EntityReference<Organization> supplier, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdReservationParamsRulesProperties(params, salesContext, null, supplier));
        proxy.setActionSet((Object)rzdParametersActions);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
    }
}

