/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.xtrip.common.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.BookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarPlaceTypeData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PriceInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatsRequest;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperParamsAbstractProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RzdPricingReservationCreationWrapperParamsProvider
extends RzdReservationCreationWrapperParamsAbstractProvider {
    protected final BookingRouteInfo routeInfo;
    private final PaymentType paymentType;

    public RzdPricingReservationCreationWrapperParamsProvider(SalesContext salesContext, RzdGdsParameters gdsParams, RzdReservationCreationParameters params, RzdBookingSegmentParams segmentParams, BookingRouteInfo routeInfo, List<Traveller> travellers, EntityReference<Organization> supplier, PaymentType paymentType) {
        super(salesContext, params, segmentParams, gdsParams, travellers, supplier);
        this.routeInfo = routeInfo;
        this.paymentType = paymentType;
    }

    @Override
    public String getRecordLocator() {
        return null;
    }

    @Override
    public Date getCreateDate() {
        return new Date();
    }

    @Override
    public String getComfortInfo() {
        return null;
    }

    @Override
    public DictionaryReference<RailwayCarrier> getCarrier() {
        return this.segmentParams.getRzdPrice().getCarrier();
    }

    @Override
    public String getTimeInfo() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RzdReservationCreationWrapperProvider.PassengerParamsProvider> getPassengers() {
        ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider> psgrParams = new ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider>();
        Map originalPlaceDataWithSeats = this.routeInfo.getCarriage().getCarPlaceData().stream().collect(Collectors.toMap(Function.identity(), placeData -> new ArrayList(placeData.getAvailableSeats())));
        try {
            List<RzdReservationCreationWrapperProvider.PassengerParamsProvider> nonRefundableParams = this.getPassengers(RzdTraveller::isNonRefundableTariff, CarPlaceTypeData::hasNonRefundableTariff);
            psgrParams.addAll(nonRefundableParams);
            List<RzdReservationCreationWrapperProvider.PassengerParamsProvider> otherParams = this.getPassengers(rzdTr -> !rzdTr.isNonRefundableTariff(), plData -> true);
            psgrParams.addAll(otherParams);
        }
        finally {
            originalPlaceDataWithSeats.forEach((plData, seats) -> {
                plData.getAvailableSeats().clear();
                plData.getAvailableSeats().addAll(seats);
            });
        }
        return psgrParams;
    }

    public List<RzdReservationCreationWrapperProvider.PassengerParamsProvider> getPassengers(Predicate<RzdTraveller> rzdTravellerFilter, Predicate<CarPlaceTypeData> filterCarPlaceTypeData) {
        boolean withoutBed = this.segmentParams.getRzdCar().isBeddingEnabled() && !this.routeInfo.getSeatsRequest().isWithBed();
        RzdPrice rzdPrice = this.segmentParams.getRzdPrice();
        BigDecimal adultSubtractPrice = withoutBed ? rzdPrice.getPrice().getServiceCost() : BigDecimal.ZERO;
        BigDecimal childSubtractPrice = withoutBed && rzdPrice.getChildPrice() != null ? rzdPrice.getChildPrice().getServiceCost() : BigDecimal.ZERO;
        List<CarPlaceTypeData> carPlaceDataListBySeatsRequest = this.getCarPlaceDataListBySeatsRequest(this.routeInfo, filterCarPlaceTypeData);
        Iterator<CarPlaceTypeData> cpdIterator = carPlaceDataListBySeatsRequest.iterator();
        ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider> psgrParams = new ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider>();
        int i = 0;
        List rzdTravellers = this.params.getRzdTravellers();
        rzdTravellers.sort((o1, o2) -> CommonHelper.getPassengerTypeRank((DictionaryReference)o2.getPassengerType()) - CommonHelper.getPassengerTypeRank((DictionaryReference)o1.getPassengerType()));
        for (final RzdTraveller rzdTraveller : this.params.getRzdTravellers()) {
            String seatNumber;
            if (rzdTravellerFilter != null && !rzdTravellerFilter.test(rzdTraveller)) continue;
            final Traveller traveller = (Traveller)CollectionUtil.find((Iterable)this.travellers, (String)rzdTraveller.getTravellerUid());
            String indStr = String.valueOf(i++);
            final DictionaryReference passengerType = rzdTraveller.getPassengerType();
            ArrayList<BlankData> blankDataList = new ArrayList<BlankData>();
            CarPlaceTypeData carPlaceTypeData = null;
            boolean selectMaxPrice = false;
            if (!DictHelper.isInfantPassengerType((DictionaryReference)passengerType)) {
                if (!cpdIterator.hasNext()) {
                    carPlaceDataListBySeatsRequest = this.getCarPlaceDataListBySeatsRequest(this.routeInfo, plData -> true);
                    cpdIterator = carPlaceDataListBySeatsRequest.iterator();
                }
                if (!(carPlaceTypeData = cpdIterator.next()).getAvailableSeats().isEmpty()) {
                    String seat = (String)carPlaceTypeData.getAvailableSeats().get(0);
                    this.routeInfo.getCarriage().getCarPlaceData().forEach(list -> list.getAvailableSeats().remove(seat));
                }
                selectMaxPrice = carPlaceTypeData.hasNonRefundableTariff() && !rzdTraveller.isNonRefundableTariff();
            }
            String string = seatNumber = carPlaceTypeData != null && !carPlaceTypeData.getAvailableSeats().isEmpty() ? (String)carPlaceTypeData.getAvailableSeats().get(0) : null;
            if (this.segmentParams.getRzdPrice().getSeatsIncluded() > 1) {
                if (i == 1) {
                    blankDataList.addAll(this.buildAdultBlankPrices(indStr, carPlaceTypeData.getPrice(), adultSubtractPrice, selectMaxPrice, seatNumber));
                } else {
                    blankDataList.add(new BlankData(indStr, BigDecimal.ZERO, seatNumber));
                }
            } else {
                boolean isChild = DictHelper.isChildPassengerType((DictionaryReference)passengerType);
                boolean isInfant = DictHelper.isInfantPassengerType((DictionaryReference)passengerType);
                if (isInfant) {
                    blankDataList.add(new BlankData(indStr, BigDecimal.ZERO, seatNumber));
                } else if (isChild) {
                    blankDataList.add(new BlankData("max-" + indStr, this.getPriceGds(carPlaceTypeData.getChildPrice(), childSubtractPrice, selectMaxPrice), seatNumber));
                } else {
                    blankDataList.addAll(this.buildAdultBlankPrices(indStr, carPlaceTypeData.getPrice(), adultSubtractPrice, selectMaxPrice, seatNumber));
                }
            }
            for (final BlankData blankData : blankDataList) {
                psgrParams.add(new RzdReservationCreationWrapperProvider.PassengerParamsProvider(){

                    @Override
                    public Traveller getTraveller() {
                        return traveller;
                    }

                    @Override
                    public String getBlankId() {
                        return blankData.blankId;
                    }

                    @Override
                    public RzdTariff getTariff() {
                        return RzdCommonHelper.getRzdTariff((DictionaryReference)passengerType);
                    }

                    @Override
                    public BigDecimal getPrice() {
                        return blankData.price;
                    }

                    @Override
                    public DictionaryReference<PassengerType> getPassengerType() {
                        return passengerType;
                    }

                    @Override
                    public DictionaryReference<Principal> getPrincipal() {
                        return null;
                    }

                    @Override
                    public String getSeatNumber() {
                        return blankData.seatNumber;
                    }

                    @Override
                    public BigDecimal getEquivalentVat() {
                        return BigDecimal.ZERO;
                    }

                    @Override
                    public BigDecimal getServiceVat() {
                        return null;
                    }

                    @Override
                    public BigDecimal getReservedSeatFare() {
                        return null;
                    }

                    @Override
                    public BigDecimal getSegmentFare() {
                        return null;
                    }

                    @Override
                    public Double getEquivalentVatRate() {
                        return null;
                    }

                    @Override
                    public Double getServiceVatRate() {
                        return null;
                    }

                    @Override
                    public boolean isNonRefundableTariff() {
                        return rzdTraveller.isNonRefundableTariff();
                    }

                    @Override
                    public PaymentType getPaymentType() {
                        return RzdPricingReservationCreationWrapperParamsProvider.this.paymentType;
                    }
                });
            }
        }
        return psgrParams;
    }

    private List<BlankData> buildAdultBlankPrices(String indStr, PriceInfo priceInfo, BigDecimal subtractPrice, boolean selectMaxPrice, String seatNumber) {
        ArrayList<BlankData> result = new ArrayList<BlankData>();
        if (priceInfo.getPriceRangeGds() != null) {
            if (selectMaxPrice) {
                result.add(new BlankData("max-" + indStr, MiscUtil.sub((BigDecimal)priceInfo.getPriceRangeGds().getMax(), (BigDecimal[])new BigDecimal[]{subtractPrice}), seatNumber));
            } else {
                result.add(new BlankData("min-" + indStr, MiscUtil.sub((BigDecimal)priceInfo.getPriceRangeGds().getMin(), (BigDecimal[])new BigDecimal[]{subtractPrice}), seatNumber));
            }
        } else {
            result.add(new BlankData(indStr, MiscUtil.sub((BigDecimal)priceInfo.getPriceGds(), (BigDecimal[])new BigDecimal[]{subtractPrice}), seatNumber));
        }
        return result;
    }

    private List<CarPlaceTypeData> getCarPlaceDataListBySeatsRequest(BookingRouteInfo routeInfo, Predicate<CarPlaceTypeData> filterCarPlaceTypeData) {
        SeatsRequest seatsRequest = routeInfo.getSeatsRequest();
        List carPlaceDataList = routeInfo.getCarriage().getCarPlaceData();
        ArrayList<CarPlaceTypeData> result = new ArrayList<CarPlaceTypeData>();
        Integer start = seatsRequest.getRange().getFirst();
        Integer end = seatsRequest.getRange().getSecond();
        if (start != null && end != null) {
            block0: for (int i = start.intValue(); i <= end; ++i) {
                String seat = String.valueOf(i);
                for (CarPlaceTypeData carPlaceTypeData : carPlaceDataList) {
                    if (filterCarPlaceTypeData != null && !filterCarPlaceTypeData.test(carPlaceTypeData)) continue;
                    for (String availableSeat : carPlaceTypeData.getAvailableSeats()) {
                        if (!availableSeat.equals(seat)) continue;
                        CarPlaceTypeData clone = this.cloneCarPlaceTypeData(carPlaceTypeData);
                        clone.getAvailableSeats().clear();
                        clone.getAvailableSeats().add(seat);
                        result.add(clone);
                        continue block0;
                    }
                }
            }
        } else {
            carPlaceDataList.stream().filter(filterCarPlaceTypeData).map(this::cloneCarPlaceTypeData).forEach(result::add);
        }
        result.sort((o1, o2) -> {
            BigDecimal price1 = this.getPriceGds(o1.getPrice(), null, false);
            BigDecimal price2 = this.getPriceGds(o2.getPrice(), null, false);
            return price1.compareTo(price2);
        });
        return result;
    }

    private BigDecimal getPriceGds(PriceInfo priceInfo, BigDecimal subtractPrice, boolean selectMaxPrice) {
        if (priceInfo == null) {
            return null;
        }
        BigDecimal price = priceInfo.getPriceRangeGds() != null ? (selectMaxPrice ? priceInfo.getPriceRangeGds().getMax() : priceInfo.getPriceRangeGds().getMin()) : priceInfo.getPriceGds();
        return MiscUtil.sub((BigDecimal)price, (BigDecimal[])new BigDecimal[]{subtractPrice});
    }

    private CarPlaceTypeData cloneCarPlaceTypeData(CarPlaceTypeData source) {
        CarPlaceTypeData result = new CarPlaceTypeData();
        result.setCarPlaceType(source.getCarPlaceType());
        result.setPrice(source.getPrice());
        result.setChildPrice(source.getChildPrice());
        result.setNonRefundableTariff(source.hasNonRefundableTariff());
        result.setSubcategory(source.getSubcategory());
        result.getAvailableSeats().addAll(source.getAvailableSeats());
        return result;
    }

    private static class BlankData {
        String blankId;
        BigDecimal price;
        String seatNumber;

        BlankData(String blankId, BigDecimal price, String seatNumber) {
            this.blankId = blankId;
            this.price = price;
            this.seatNumber = seatNumber;
        }
    }
}

