/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class RzdReservationCreationParametersValidator
extends BaseProcessor {
    private static final List<RzdTariff> rusInSapsanTariffs = Arrays.asList(RzdTariff.SENIOR_SAPSAN, RzdTariff.SENIOR, RzdTariff.JUNIOR, RzdTariff.JUNIOR_10_21);
    private static final List<PassportType> GENERAL_CHILD_PASSPORT_TYPES = Arrays.asList(PassportType.BIRTHDAY_NOTIFICATION, PassportType.FOREIGN, PassportType.PASSPORT);
    private static final List<PassportType> PASSPORT_TYPES_FOR_RUS = Arrays.asList(PassportType.INTERNAL, PassportType.FOREIGN, PassportType.BIRTHDAY_NOTIFICATION, PassportType.MILITARYID, PassportType.SEAMANSID);
    private static final List<PassportType> PASSPORT_TYPES_FOR_INTERNATIONAL = Arrays.asList(PassportType.FOREIGN, PassportType.PASSPORT, PassportType.IDENTITYCARD);
    private static final List<String> INTERNAL_PASSPORT_COUNTRIES = Arrays.asList("RU", "BY", "KZ", "KG", "TJ", "\u0410\u0426");
    private static final int birthdayInternalMinYears = 14;
    private static final int birthdayNotificationMaxYears = 14;
    private static final int birthdayNotificationMaxMonths = 3;
    private static final int nationalPasportForRusMaxYears = 14;
    private static final int nationalPasportForRusMaxMonths = 2;
    private static final Map<CompartmentType, Gender> genderMap = new HashMap<CompartmentType, Gender>();

    public static Collection<RzdTariff> getAvailableTariffs(RzdReservationCreationParameters params) {
        ArrayList<RzdTariff> result = new ArrayList<RzdTariff>(params.getSegment().getRzdPrice().getAvailableTariffs());
        if (params.getSegmentBack() != null) {
            result.retainAll(params.getSegmentBack().getRzdPrice().getAvailableTariffs());
        }
        return result;
    }

    public void process(MessageContext ctx) throws Exception {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)siteRef);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        this.validateParamsAndTravellers(travellers, params, salesContext, minimumDate);
    }

    private void validateParamsAndTravellers(List<Traveller> travellers, RzdReservationCreationParameters params, SalesContext salesContext, Date minimumDate) throws Exception {
        if (params.getSegment() == null) {
            throw Xeption.forDeveloper((String)"missing route segment", (Object[])new Object[0]);
        }
        this.validateTrainInfo(params.getSegment(), salesContext, minimumDate);
        this.validateTrainInfo(params.getSegmentBack(), salesContext, minimumDate);
        this.validateTrainsAvailability(params);
        if (params.getSegmentBack() != null && !MiscUtil.equals((Object)params.getSegment().getTrain().getGdsAccount(), (Object)params.getSegmentBack().getTrain().getGdsAccount())) {
            throw Xeption.forDeveloper((String)"different gdsAccounts for RT", (Object[])new Object[0]);
        }
        if (params.getRzdTravellers().isEmpty()) {
            params.getValidationContext().getRzdTravellersValidationMessages().add(StandardValidationMessages.getEmptyCollection());
        } else {
            this.validateRzdTravellers(travellers, params);
        }
    }

    private void validateTrainInfo(RzdBookingSegmentParams segmentParams, SalesContext salesContext, Date minimumDate) throws Exception {
        if (segmentParams == null) {
            return;
        }
        if (segmentParams.getTrain() == null) {
            throw Xeption.forDeveloper((String)"missing train", (Object[])new Object[0]);
        }
        if (segmentParams.getRzdPrice() == null) {
            throw Xeption.forDeveloper((String)"missing rzdPrice", (Object[])new Object[0]);
        }
        if (segmentParams.getRzdCar() == null) {
            throw Xeption.forDeveloper((String)"missing rzdCar", (Object[])new Object[0]);
        }
        RzdPrice rzdPrice = segmentParams.getRzdPrice();
        RzdTrain rzdTrain = segmentParams.getTrain();
        if (TextUtil.isBlank((String)rzdPrice.getTrainNumber())) {
            rzdPrice.getValidationContext().getTrainNumberValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        RailwayHelper.validateDepartuteAndArrival((DictionaryReference<RailwayStation>)rzdTrain.getPassengerFrom(), (DictionaryReference<RailwayStation>)rzdTrain.getPassengerTo(), rzdTrain.getValidationContext().getPassengerFromValidationMessages(), rzdTrain.getValidationContext().getPassengerToValidationMessages());
        RailwayHelper.validateDepartureDate(rzdTrain.getDepartureDatetime(), (DictionaryReference<RailwayStation>)rzdTrain.getPassengerFrom(), (DictionaryReference<RailwayStation>)rzdTrain.getPassengerTo(), salesContext, minimumDate, rzdTrain.getValidationContext().getDepartureDatetimeValidationMessages(), true);
        if (rzdPrice.getCategory() == null) {
            rzdPrice.getValidationContext().getCategoryValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
    }

    private void validateTrainsAvailability(RzdReservationCreationParameters params) {
        if (params.getSegmentBack() == null) {
            return;
        }
        this.checkRoundTrip(params);
    }

    private void checkRoundTrip(RzdReservationCreationParameters params) {
        RzdTrain train = params.getSegment().getTrain();
        RzdTrain trainBack = params.getSegmentBack().getTrain();
        this.checkSameStations((DictionaryReference<RailwayStation>)train.getPassengerFrom(), (DictionaryReference<RailwayStation>)trainBack.getPassengerTo());
        this.checkSameStations((DictionaryReference<RailwayStation>)train.getPassengerTo(), (DictionaryReference<RailwayStation>)trainBack.getPassengerFrom());
    }

    private void checkSameStations(DictionaryReference<RailwayStation> ref, DictionaryReference<RailwayStation> backRef) {
        if (!this.sameCityStations(ref, backRef)) {
            throw Xeption.forAdmin((String)"\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u0432 \u043f\u0440\u044f\u043c\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 ({0}) \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0432 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 ({1}). \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0421\u0442\u0430\u043d\u0446\u0438\u044f-\u0433\u043e\u0440\u043e\u0434'", (Object[])new Object[]{ref.getCode(), backRef.getCode()});
        }
    }

    private boolean sameCityStations(DictionaryReference<RailwayStation> station1, DictionaryReference<RailwayStation> station2) {
        DictionaryReference<RailwayStation> cityStation1 = RailwayHelper.getCityStation(station1);
        DictionaryReference<RailwayStation> cityStation2 = RailwayHelper.getCityStation(station2);
        return MiscUtil.equals(cityStation1, cityStation2);
    }

    private ServiceClass getSegmentServiceClass(RzdBookingSegmentParams segment) {
        if (segment == null || segment.getRzdPrice() == null) {
            return null;
        }
        return segment.getRzdPrice().getServiceClass();
    }

    private void validateRzdTravellers(List<Traveller> travellers, RzdReservationCreationParameters params) {
        int adultCount = 0;
        int childCount = 0;
        int babyCount = 0;
        ArrayList<TravellerWrapper> trWrappers = new ArrayList<TravellerWrapper>();
        for (RzdTraveller rzdTraveller : params.getRzdTravellers()) {
            if (rzdTraveller.getPassengerType() == null) {
                rzdTraveller.getValidationContext().getPassengerTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
                continue;
            }
            PassengerTypeValue ptv = DictHelper.getPassengerTypeValue((DictionaryReference)rzdTraveller.getPassengerType());
            switch (ptv) {
                case ADULT: {
                    ++adultCount;
                    break;
                }
                case CHILD: {
                    ++childCount;
                    break;
                }
                case INFANT: {
                    ++babyCount;
                    break;
                }
                default: {
                    rzdTraveller.getValidationContext().getPassengerTypeValidationMessages().add(StandardValidationMessages.getWrongValue());
                }
            }
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
            if (traveller == null) {
                throw Xeption.forDeveloper((String)"traveller with uid '{0}' referenced in parameters for reservation system account '{1}' not found in context", (Object[])new Object[]{rzdTraveller.getTravellerUid(), params.getGdsAccount()});
            }
            if (rzdTraveller.getTariff() == null) {
                rzdTraveller.setTariff(RzdCommonHelper.getRzdTariff((RzdTariff)rzdTraveller.getTariff(), (DictionaryReference)rzdTraveller.getPassengerType()));
            }
            this.validateTariff(rzdTraveller.getTariff(), traveller, params, rzdTraveller.getValidationContext().getTariffValidationMessages());
            this.validateTraveller(traveller, (DictionaryReference<PassengerType>)rzdTraveller.getPassengerType(), rzdTraveller.getTariff(), params);
            trWrappers.add(new TravellerWrapper(rzdTraveller, traveller));
        }
        Collection rzdTravellersValidationMessages = params.getValidationContext().getRzdTravellersValidationMessages();
        this.validateTravellersForSegment(adultCount, childCount, babyCount, params.getSegment(), rzdTravellersValidationMessages);
        this.validateTravellersForSegment(adultCount, childCount, babyCount, params.getSegmentBack(), rzdTravellersValidationMessages);
        this.validateUniquePassports(trWrappers);
        this.validateRzdCards(trWrappers);
    }

    private void validateTariff(RzdTariff tariff, Traveller traveller, RzdReservationCreationParameters params, Collection<ValidationMessage> vms) {
        if (tariff == null) {
            return;
        }
        if (!RzdReservationCreationParametersValidator.getAvailableTariffs(params).contains(tariff)) {
            vms.add(StandardValidationMessages.getWrongValue());
        }
        Boolean isRusCitizenship = this.getRusCitizenship(traveller.getPassport());
        if (this.isAnySapsan(params) && rusInSapsanTariffs.contains(tariff) && BooleanUtils.isFalse((Boolean)isRusCitizenship)) {
            vms.add(RzdValidationMessages.getTariffAvailableOnlyForRus());
        }
    }

    private boolean isAnySapsan(RzdReservationCreationParameters params) {
        return this.isSapsan(params.getSegment()) || this.isSapsan(params.getSegmentBack());
    }

    private boolean isBothSapsan(RzdReservationCreationParameters params) {
        return this.isSapsan(params.getSegment()) && this.isSapsan(params.getSegmentBack());
    }

    private boolean isSapsan(RzdBookingSegmentParams segmentParams) {
        return segmentParams != null && RzdCommonHelper.isSapsan((RzdTrain)segmentParams.getTrain());
    }

    private void validateTravellersForSegment(int adultCount, int childCount, int babyCount, RzdBookingSegmentParams segmentParams, Collection<ValidationMessage> rzdTravellersValidationMessages) {
        if (segmentParams == null) {
            return;
        }
        ValidationMessage travellersCountMes = RzdCommonHelper.checkTravellersCount((int)adultCount, (int)childCount, (int)babyCount, (RzdPrice)segmentParams.getRzdPrice());
        if (travellersCountMes != null) {
            rzdTravellersValidationMessages.add(travellersCountMes);
        }
    }

    private void validateRzdCards(List<TravellerWrapper> trWrappers) {
        HashMap doubleCards = new HashMap();
        HashMap doublePassports = new HashMap();
        for (TravellerWrapper wr2 : trWrappers) {
            String bonusCard = wr2.traveller.getRailwayBonusCard() == null ? null : wr2.traveller.getRailwayBonusCard().getNumber();
            Passport passport = wr2.traveller.getPassport();
            if (TextUtil.isBlank((String)bonusCard) || wr2.traveller.getPassport() == null) continue;
            this.validateRzdBonusCard(wr2);
            this.addToDoubleMap(doubleCards, bonusCard, wr2);
            this.addToDoubleMap(doublePassports, new PassportWrapper(passport), wr2);
        }
        this.validateDoubleMap(doubleCards, wr -> new PassportWrapper(wr.traveller.getPassport()), RzdValidationMessages.getExistsSameCardNumbers());
        this.validateDoubleMap(doublePassports, wr -> wr.traveller.getRailwayBonusCard().getNumber(), RzdValidationMessages.getDifferentCardNumbers4OnePassenger());
    }

    private <T> void validateDoubleMap(Map<?, Set<TravellerWrapper>> doubleMap, TravellerWrapperValueGetter<T> getter, ValidationMessage mes) {
        for (Set<TravellerWrapper> travellers : doubleMap.values()) {
            Object firstValue = null;
            boolean isInvalid = false;
            for (TravellerWrapper tr : travellers) {
                T value = getter.getValue(tr);
                if (firstValue == null) {
                    firstValue = value;
                    continue;
                }
                if (firstValue.equals(value)) continue;
                isInvalid = true;
                break;
            }
            if (!isInvalid) continue;
            for (TravellerWrapper tr : travellers) {
                tr.traveller.getValidationContext().getRailwayBonusCardValidationMessages().add(mes);
            }
        }
    }

    private <T> void addToDoubleMap(Map<T, Set<TravellerWrapper>> doubleMap, T key, TravellerWrapper traveller) {
        Set<TravellerWrapper> travellers = doubleMap.get(key);
        if (travellers == null) {
            travellers = new HashSet<TravellerWrapper>();
        }
        travellers.add(traveller);
        doubleMap.put(key, travellers);
    }

    private void validateRzdBonusCard(TravellerWrapper travellerWrapper) {
        Traveller traveller = travellerWrapper.traveller;
        String rzdBonusCard = traveller.getRailwayBonusCard().getNumber();
        if (TextUtil.isBlank((String)rzdBonusCard)) {
            return;
        }
        if (!rzdBonusCard.matches("^\\d{13}$")) {
            traveller.getValidationContext().getRailwayBonusCardValidationMessages().add(RzdValidationMessages.getIvalidValueOnlyFixedNumbers((int)13));
        }
    }

    private void validateUniquePassports(List<TravellerWrapper> trWrappers) {
        ArrayList<Passport> existsAdultPassports = new ArrayList<Passport>();
        ArrayList<Passport> existsChildPassports = new ArrayList<Passport>();
        for (TravellerWrapper trWrapper : trWrappers) {
            DictionaryReference passengerType = trWrapper.rzdTraveller.getPassengerType();
            Passport psp = trWrapper.traveller.getPassport();
            if (DictHelper.isAdultPassengerType((DictionaryReference)passengerType)) {
                this.validateUniquePassport(psp, existsAdultPassports, true);
                continue;
            }
            this.validateUniquePassport(psp, existsChildPassports, false);
        }
    }

    private void validateUniquePassport(Passport psp, List<Passport> existsPassports, boolean isAdult) {
        for (Passport ep : existsPassports) {
            if (!RzdCommonHelper.isSamePassports((Passport)psp, (Passport)ep, (boolean)false)) continue;
            if (!isAdult) {
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getExistsSameDocument());
                if (psp.getType() == PassportType.BIRTHDAY_NOTIFICATION) {
                    psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getAdditionalSeatsForFullTariff());
                }
                return;
            }
            if (MiscUtil.equals((Object)psp.getBirthday(), (Object)ep.getBirthday()) && MiscUtil.equals((Object)psp.getLastName(), (Object)ep.getLastName()) && MiscUtil.equals((Object)psp.getFirstName(), (Object)ep.getFirstName())) continue;
            psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getExistsSameDocument());
            return;
        }
        existsPassports.add(psp);
    }

    private void validateTraveller(Traveller traveller, DictionaryReference<PassengerType> passengerType, RzdTariff rzdTariff, RzdReservationCreationParameters params) {
        Passport psp = traveller.getPassport();
        if (!DictHelper.isInfantPassengerType(passengerType) && traveller.getParentTravellerUid() != null) {
            traveller.getValidationContext().getParentTravellerUidValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (psp == null) {
            traveller.getValidationContext().getPassportValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            this.validatePassport(psp, passengerType, rzdTariff, params);
        }
    }

    private void validatePassport(Passport psp, DictionaryReference<PassengerType> passengerType, RzdTariff rzdTariff, RzdReservationCreationParameters params) {
        boolean isKzCitizenship = RzdCommonHelper.isKzCitizenship((Passport)psp);
        boolean isByCitizenship = RzdCommonHelper.isByCitizenship((Passport)psp);
        this.basicNameValidation(psp.getLastName(), psp.getType(), true, 30, params, psp.getValidationContext().getLastNameValidationMessages(), isKzCitizenship, isByCitizenship);
        this.basicNameValidation(psp.getFirstName(), psp.getType(), true, 20, params, psp.getValidationContext().getFirstNameValidationMessages(), isKzCitizenship, isByCitizenship);
        this.basicNameValidation(psp.getSecondName(), psp.getType(), false, 20, params, psp.getValidationContext().getSecondNameValidationMessages(), isKzCitizenship, isByCitizenship);
        this.basicNameValidation(psp.getMiddleName(), psp.getType(), false, 20, params, psp.getValidationContext().getMiddleNameValidationMessages(), isKzCitizenship, isByCitizenship);
        this.validatePassportNumber(psp, isKzCitizenship);
        BaseRailGdsAccount gdsAccount = (BaseRailGdsAccount)EntityStorage.get().resolve(params.getSegment().getTrain().getGdsAccount()).getEntity();
        this.validatePassportType(psp, rzdTariff, gdsAccount, params.getSegment());
        this.validatePassportType(psp, rzdTariff, gdsAccount, params.getSegmentBack());
        boolean isSuburbanTrains = this.isSuburbanTrains(params);
        if (psp.getBirthday() == null) {
            psp.getValidationContext().getBirthdayValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            this.validateBirthDay(psp.getBirthday(), rzdTariff, params, psp.getValidationContext().getBirthdayValidationMessages());
        }
        if (!isSuburbanTrains) {
            if (psp.getOriginCountry() == null) {
                psp.getValidationContext().getOriginCountryValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
            if (psp.getCitizenship() == null) {
                psp.getValidationContext().getCitizenshipValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
            if (psp.getExpired() == null) {
                psp.getValidationContext().getExpiredValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else {
                Date departureDate;
                Date date = departureDate = params.getSegmentBack() != null ? params.getSegmentBack().getRzdPrice().getDepartureDatetime() : params.getSegment().getRzdPrice().getDepartureDatetime();
                if (departureDate.after(psp.getExpired())) {
                    psp.getValidationContext().getExpiredValidationMessages().add(RzdValidationMessages.getIvalidValuePassportExpirationDate());
                }
            }
        }
        if (psp.getGender() == null) {
            if (!isSuburbanTrains) {
                psp.getValidationContext().getGenderValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
        } else if (!this.validatePassportGender(psp.getGender(), passengerType, params)) {
            psp.getValidationContext().getGenderValidationMessages().add(RzdValidationMessages.getNotMatchGenderToTypeCompartment());
        }
        if (!TextUtil.isBlank((String)psp.getBirthPlace())) {
            if (!psp.getBirthPlace().matches("[\u0430-\u044f\u0410-\u042f\u0451\u0401\\w\\-\\\\ \\.,;/(){}\\[\\]<>]*")) {
                psp.getValidationContext().getBirthPlaceValidationMessages().add(StandardValidationMessages.getWrongValue());
            } else if (psp.getBirthPlace().split("[\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z]", -1).length <= 2) {
                psp.getValidationContext().getBirthPlaceValidationMessages().add(StandardValidationMessages.getWrongValue());
            }
        }
    }

    private boolean isSuburbanTrains(RzdReservationCreationParameters params) {
        boolean isSuburbanTrain = this.isSuburbanTrain(params.getSegment());
        if (params.getSegmentBack() == null) {
            return isSuburbanTrain;
        }
        boolean isSuburbanTrainBack = this.isSuburbanTrain(params.getSegmentBack());
        return isSuburbanTrain && isSuburbanTrainBack;
    }

    private boolean isSuburbanTrain(RzdBookingSegmentParams segmentParams) {
        String trainDisplayNumber = segmentParams.getTrain().getDisplayNumber();
        return RzdCommonHelper.isSuburbanTrain((String)trainDisplayNumber);
    }

    private void validateBirthDay(Date birthday, RzdTariff rzdTariff, RzdReservationCreationParameters params, Collection<ValidationMessage> messages) {
        if (new Date().before(birthday)) {
            messages.add(StandardValidationMessages.getWrongValue());
        }
        this.validateBirthDayForSegment(birthday, rzdTariff, messages, params.getSegment());
        this.validateBirthDayForSegment(birthday, rzdTariff, messages, params.getSegmentBack());
    }

    private void validateBirthDayForSegment(Date birthday, RzdTariff rzdTariff, Collection<ValidationMessage> messages, RzdBookingSegmentParams segmentParams) {
        if (segmentParams == null) {
            return;
        }
        RzdCommonHelper.validateBirthday((Date)birthday, (RzdTariff)rzdTariff, (RzdTrain)segmentParams.getTrain(), (RzdPrice)segmentParams.getRzdPrice(), (Integer)segmentParams.getPlacing().getSeatRangeFirst(), (Integer)segmentParams.getPlacing().getSeatRangeLast(), messages);
    }

    private void validatePassportType(Passport passport, RzdTariff rzdTariff, BaseRailGdsAccount gdsAccount, RzdBookingSegmentParams segmentParams) {
        if (segmentParams == null) {
            return;
        }
        if (passport.getType() == null) {
            passport.getValidationContext().getTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else if (!segmentParams.getRzdPrice().getAvailableDocuments().contains(passport.getType())) {
            passport.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getUnsupportedDocumentType());
        } else {
            DictionaryReference citizenshipRef = passport.getCitizenship();
            if (citizenshipRef != null) {
                DictionaryReference<Country> birthdayNotificationCountryRef = this.getBirthdayNotificationCountryRef(gdsAccount);
                boolean isRusCitizenship = this.isRusCitizenship((DictionaryReference<Country>)citizenshipRef);
                if (passport.getType() == PassportType.PASSPORT) {
                    this.validateNationalPassport(isRusCitizenship, passport, segmentParams);
                } else if (!(passport.getType() == PassportType.BIRTHDAY_NOTIFICATION && citizenshipRef.equals(birthdayNotificationCountryRef) || !PASSPORT_TYPES_FOR_RUS.contains(passport.getType()) || isRusCitizenship || RzdCommonHelper.isKzCitizenship((Passport)passport))) {
                    passport.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getIncorrectDocumentTypeForCitizenship());
                }
            }
            if (passport.getType() == PassportType.INTERNAL || passport.getType() == PassportType.BIRTHDAY_NOTIFICATION) {
                if (!this.isInternalPassportAvailable(segmentParams)) {
                    passport.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getIncorrectDocumentTypeForTrain());
                }
            } else {
                boolean internationalTrain = this.isInternationalTrain(segmentParams);
                if (internationalTrain && !PASSPORT_TYPES_FOR_INTERNATIONAL.contains(passport.getType())) {
                    passport.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getIncorrectDocumentTypeForTrain());
                }
            }
            if (Arrays.asList(RzdTariff.CHILD, RzdTariff.BABY).contains(rzdTariff) && !GENERAL_CHILD_PASSPORT_TYPES.contains(passport.getType())) {
                passport.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getIncorrectDocumentType());
            }
            this.validatePassportTypeByBirthday(passport, segmentParams);
        }
    }

    private void validateNationalPassport(boolean isRusCitizenship, Passport psp, RzdBookingSegmentParams segmentParams) {
        if (!isRusCitizenship) {
            return;
        }
        Date departureDate = segmentParams.getTrain().getDepartureDatetime();
        if (departureDate == null || psp.getBirthday() == null) {
            return;
        }
        Period age = new Period((ReadableInstant)new DateTime((Object)psp.getBirthday()), (ReadableInstant)new DateTime((Object)departureDate), PeriodType.months());
        if (age.getMonths() >= 170) {
            psp.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getIncorrectPassportForRusCitizenship((int)14, (int)2));
        }
    }

    private DictionaryReference<Country> getBirthdayNotificationCountryRef(BaseRailGdsAccount gdsAccount) {
        if (gdsAccount instanceof UfsGdsAccount) {
            UfsGdsAccount ufsAccount = (UfsGdsAccount)gdsAccount;
            return ufsAccount.getBirthdayNotificationCountry();
        }
        return null;
    }

    private Boolean getRusCitizenship(Passport passport) {
        if (passport.getCitizenship() == null) {
            return null;
        }
        return this.isRusCitizenship((DictionaryReference<Country>)passport.getCitizenship());
    }

    private boolean isRusCitizenship(DictionaryReference<Country> countryRef) {
        return MiscUtil.equals((Object)DictHelper.getRuRef(), countryRef);
    }

    private boolean isInternationalTrain(RzdBookingSegmentParams segmentParams) {
        return !RzdCommonHelper.isRussiaStation((DictionaryReference)segmentParams.getTrain().getPassengerFrom()) || !RzdCommonHelper.isRussiaStation((DictionaryReference)segmentParams.getTrain().getPassengerTo());
    }

    private boolean isInternalPassportAvailable(RzdBookingSegmentParams segmentParams) {
        DictionaryReference countryFrom = RzdCommonHelper.getStationCountry((DictionaryReference)segmentParams.getTrain().getPassengerFrom());
        DictionaryReference countryTo = RzdCommonHelper.getStationCountry((DictionaryReference)segmentParams.getTrain().getPassengerTo());
        if (countryFrom == null || countryTo == null) {
            return false;
        }
        return INTERNAL_PASSPORT_COUNTRIES.contains(countryTo.getCode()) && INTERNAL_PASSPORT_COUNTRIES.contains(countryFrom.getCode());
    }

    private void validatePassportTypeByBirthday(Passport psp, RzdBookingSegmentParams segmentParams) {
        Period age;
        Date departureDate = segmentParams.getTrain().getDepartureDatetime();
        if (departureDate == null || psp.getBirthday() == null) {
            return;
        }
        if (psp.getType() == PassportType.INTERNAL && (age = new Period((ReadableInstant)new DateTime((Object)psp.getBirthday()), (ReadableInstant)new DateTime((Object)departureDate), PeriodType.years())).getYears() < 14) {
            psp.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getIncorrectAgeForInternalDocument((int)14));
        }
        if (psp.getType() == PassportType.BIRTHDAY_NOTIFICATION && (age = new Period((ReadableInstant)new DateTime((Object)psp.getBirthday()), (ReadableInstant)new DateTime((Object)departureDate).minusDays(1), PeriodType.months())).getMonths() >= 171) {
            psp.getValidationContext().getTypeValidationMessages().add(RzdValidationMessages.getIncorrectAgeForBirthdayNotificationDocument((int)14, (int)3));
        }
    }

    private boolean validatePassportGender(Gender passengerGender, DictionaryReference<PassengerType> passengerType, RzdReservationCreationParameters params) {
        return this.validatePassportGender(passengerGender, passengerType, params.getSegment()) && this.validatePassportGender(passengerGender, passengerType, params.getSegmentBack());
    }

    private boolean validatePassportGender(Gender passengerGender, DictionaryReference<PassengerType> passengerType, RzdBookingSegmentParams segmentParams) {
        if (segmentParams == null) {
            return true;
        }
        if (!DictHelper.isAdultPassengerType(passengerType)) {
            return true;
        }
        CompartmentType segmentGender = segmentParams.getPlacing().getGender();
        if (segmentGender == null || segmentGender == CompartmentType.COMMON) {
            return true;
        }
        return genderMap.get(segmentGender) == passengerGender;
    }

    private void validatePassportNumber(Passport psp, boolean isKzCitizenship) {
        if (TextUtil.isBlank((String)psp.getNumber())) {
            psp.getValidationContext().getNumberValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (psp.getType() == null || TextUtil.isBlank((String)psp.getNumber())) {
            return;
        }
        switch (psp.getType()) {
            case INTERNAL: {
                if (psp.getNumber().matches("^\\d{10}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValueOnlyFixedNumbers((int)10));
                break;
            }
            case FOREIGN: {
                if (psp.getNumber().matches("^\\d{9}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValueOnlyFixedNumbers((int)9));
                break;
            }
            case BIRTHDAY_NOTIFICATION: {
                if (RzdCommonHelper.isKzCitizenship((Passport)psp) && !psp.getNumber().matches("^\\d{7}$")) {
                    psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValueOnlyFixedNumbers((int)7));
                }
                if (!BooleanUtils.isTrue((Boolean)this.getRusCitizenship(psp)) || psp.getNumber().matches("^[IVX]{1,6}[\u0430-\u044f\u0410-\u042f\u0451\u0401]{2}\\d{6}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValueBirthdayNotificationNumber());
                break;
            }
            case MILITARYID: {
                if (psp.getNumber().matches("^[\u0430-\u044f\u0410-\u042f\u0451\u0401]{2}\\d{6,7}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValueMilitaryIdNumber());
                break;
            }
            case SEAMANSID: {
                if (psp.getNumber().matches("^\\d{7}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValueOnlyFixedNumbers((int)7));
                break;
            }
            case PASSPORT: {
                if (isKzCitizenship) {
                    if (psp.getNumber().matches("^[a-zA-Z]?\\d{8}$")) break;
                    psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getInvalidValueKzPassportNumber());
                    break;
                }
                String oneD = ".*[0-9].*";
                String onlyLatin = "[a-zA-Z]+";
                String validSmb = "[\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z0-9]{1,16}";
                String onlyCyrillic = "[\u0430-\u044f\u0410-\u042f\u0451\u0401]";
                String latinAndCyrillic = "[\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z]{1,16}";
                if (psp.getNumber().matches(latinAndCyrillic) && psp.getNumber().replaceAll(onlyCyrillic, "").length() < 5) {
                    psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getInvalidNumberNotEnoughLatinCharacters());
                }
                if (psp.getNumber().matches("((" + oneD + ")|(" + onlyLatin + "))") && psp.getNumber().matches(validSmb)) break;
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValuePassportNumber());
                break;
            }
            case IDENTITYCARD: {
                if (isKzCitizenship) {
                    if (psp.getNumber().matches("^\\d{9}$")) break;
                    psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getIvalidValueOnlyFixedNumbers((int)9));
                    break;
                }
                String validSmb = ".*[0-9].*";
                if (psp.getNumber().matches(validSmb)) break;
                psp.getValidationContext().getNumberValidationMessages().add(RzdValidationMessages.getInvalidStatelessPersonIdentityCardNumber());
            }
        }
    }

    private void basicNameValidation(String name, PassportType passportType, boolean notEmpty, int maxLength, RzdReservationCreationParameters params, Collection<ValidationMessage> validationMessages, boolean isKzCitizenship, boolean isByCitizenship) {
        if (TextUtil.isBlank((String)name)) {
            if (notEmpty) {
                validationMessages.add(StandardValidationMessages.getMissingRequiredValue());
            }
            return;
        }
        if (!name.equals("-") || notEmpty) {
            if (maxLength > 0 && name.length() > maxLength) {
                validationMessages.add(RzdValidationMessages.getIvalidTextLength((int)maxLength));
                return;
            }
            if (name.startsWith("-") || name.endsWith("-")) {
                validationMessages.add(RzdValidationMessages.getNotAllowedHyphenAsFirstAndLastSymbol());
                return;
            }
            if (name.startsWith(".") || name.endsWith(".")) {
                validationMessages.add(RzdValidationMessages.getNotAllowedDotAsFirstAndLastSymbol());
                return;
            }
            if (!name.matches("^([A-Za-z \\-\\.]+|[\u0410-\u042f\u0430-\u044f\u0451\u0401 \\-\\.]+)$")) {
                validationMessages.add(RzdValidationMessages.getOnlyLatinOrCyrillic());
                return;
            }
            if (passportType != null) {
                switch (passportType) {
                    case INTERNAL: 
                    case BIRTHDAY_NOTIFICATION: 
                    case MILITARYID: 
                    case MILITARYCERTIFICATE: 
                    case PASSPORTLOSSCERTIFICATE: 
                    case CERTIFICATEOFRELEASE: 
                    case INTERIMCERTIFICATE: {
                        if (name.matches("[\u0430-\u044f\u0410-\u042f\u0451\u0401 \\-\\.]*")) break;
                        validationMessages.add(RzdValidationMessages.getOnlyCyrillicAllowedForDocumentTypeFio());
                        break;
                    }
                    case FOREIGN: {
                        if (name.matches("[a-zA-Z \\-\\.]*")) break;
                        validationMessages.add(RzdValidationMessages.getOnlyLatinAllowedForDocumentTypeFio());
                        break;
                    }
                    case PASSPORT: {
                        if (isByCitizenship) {
                            if (name.matches("[\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z \\-\\.]*")) break;
                            validationMessages.add(RzdValidationMessages.getIncorrectFioForDocumentType());
                            break;
                        }
                        if (name.matches("[a-zA-Z \\-\\.]*")) break;
                        validationMessages.add(RzdValidationMessages.getOnlyLatinAllowedForDocumentTypeFio());
                        break;
                    }
                    case IDENTITYCARD: {
                        if (isKzCitizenship && !name.matches("[\u0430-\u044f\u0410-\u042f\u0451\u0401 \\-\\.]*")) {
                            validationMessages.add(RzdValidationMessages.getOnlyCyrillicAllowedForDocumentTypeFio());
                            break;
                        }
                    }
                    default: {
                        if (name.matches("[\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z \\-\\.]*")) break;
                        validationMessages.add(RzdValidationMessages.getIncorrectFioForDocumentType());
                    }
                }
            }
        }
    }

    static {
        genderMap.put(CompartmentType.MEN, Gender.MALE);
        genderMap.put(CompartmentType.WOMEN, Gender.FEMALE);
    }

    private static class PassportWrapper {
        final PassportType passportType;
        final String number;

        PassportWrapper(Passport passport) {
            this.passportType = passport == null ? null : passport.getType();
            this.number = passport == null ? null : passport.getNumber();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
            result = 31 * result + (this.passportType == null ? 0 : this.passportType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PassportWrapper other = (PassportWrapper)obj;
            if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
                return false;
            }
            return this.passportType == other.passportType;
        }
    }

    private static class TravellerWrapper {
        final RzdTraveller rzdTraveller;
        final Traveller traveller;

        TravellerWrapper(RzdTraveller rzdTraveller, Traveller traveller) {
            this.rzdTraveller = rzdTraveller;
            this.traveller = traveller;
        }
    }

    static interface TravellerWrapperValueGetter<T> {
        public T getValue(TravellerWrapper var1);
    }
}

