/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttribute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttributeEx;
import com.gridnine.xtrip.common.ibecorp.rzd.model.KupeIndication;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.SeatType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RzdReservationCreationParamsPlacingValidator
extends BaseProcessor {
    private static List<KupeIndication> onlyPCarriageKupeIndications = Arrays.asList(KupeIndication.ONE_SECTION, KupeIndication.ANY_KUPE);

    public void process(MessageContext ctx) throws Exception {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        if (params.getSegment() == null) {
            throw Xeption.forDeveloper((String)"Segment params is null", (Object[])new Object[0]);
        }
        if (params.getSegment().getPlacing() == null) {
            throw Xeption.forDeveloper((String)"placing params is null", (Object[])new Object[0]);
        }
        if (params.getSegment().getRzdPrice() != null) {
            int needSeatsCount = RailwayHelper.calcTravellersSeatsCount(params.getRzdTravellers());
            this.validatePlacing(params.getSegment(), needSeatsCount);
            if (params.getSegmentBack() != null) {
                this.validatePlacing(params.getSegmentBack(), needSeatsCount);
            }
        }
    }

    private void validatePlacing(RzdBookingSegmentParams params, int needSeatsCount) {
        PlacingRequirements placing = params.getPlacing();
        if (placing.getSeatRangeFirst() != null && placing.getSeatRangeFirst() < 0) {
            placing.getValidationContext().getSeatRangeFirstValidationMessages().add(StandardValidationMessages.getWrongValue());
        }
        if (placing.getSeatRangeLast() != null && placing.getSeatRangeLast() < 0) {
            placing.getValidationContext().getSeatRangeLastValidationMessages().add(StandardValidationMessages.getWrongValue());
        }
        if (placing.getSeatRangeFirst() != null && placing.getSeatRangeLast() != null) {
            int rangeFirst = placing.getSeatRangeFirst();
            int rangeLast = placing.getSeatRangeLast();
            int vacantSeatsCount = this.calcVacantSeatsCount(params, rangeFirst, rangeLast);
            if (rangeLast < rangeFirst) {
                placing.getValidationContext().getSeatRangeLastValidationMessages().add(RzdValidationMessages.getInvalidSeatRange((int)rangeFirst, (int)rangeLast));
            } else {
                int seatsIncluded = params.getRzdPrice().getSeatsIncluded();
                if (vacantSeatsCount < seatsIncluded) {
                    placing.getValidationContext().getSeatRangeLastValidationMessages().add(RzdValidationMessages.getSeatsIncludedGreaterVacantSeats((int)seatsIncluded, (int)vacantSeatsCount));
                }
            }
        }
        if (params.getRzdPrice().getCategory() != CarriageType.P && onlyPCarriageKupeIndications.contains(placing.getKupeIndication())) {
            throw Xeption.forDeveloper((String)"invalid kupeIndication", (Object[])new Object[0]);
        }
        this.checkPlacingGender(params, needSeatsCount);
    }

    private int calcVacantSeatsCount(RzdBookingSegmentParams params, int rangeFirst, int rangeLast) {
        long vacantSeatsCount = params.getRzdCar().getVacantSeats().stream().map(RzdCommonHelper::seat2IntValue).filter(Objects::nonNull).filter(seat -> seat >= rangeFirst && seat <= rangeLast).count();
        return (int)vacantSeatsCount;
    }

    private void checkPlacingGender(RzdBookingSegmentParams params, int needSeatsCount) {
        CompartmentType gender = params.getPlacing().getGender();
        RzdPrice rzdPrice = params.getRzdPrice();
        if (rzdPrice == null || TextUtil.isBlank((String)rzdPrice.getSubcategory())) {
            return;
        }
        Set carriageAttributesEx = CarriageAttributeEx.parseCarriageAttributes((String)rzdPrice.getSubcategory());
        boolean withGender = carriageAttributesEx.stream().filter(attr -> attr.getAttribute() == CarriageAttribute.MF).findAny().isPresent();
        if (!withGender) {
            return;
        }
        if (gender == null) {
            throw Xeption.forDeveloper((String)"placing gender missing", (Object[])new Object[0]);
        }
        RzdCar rzdCar = params.getRzdCar();
        if (rzdCar == null || CollectionUtil.isEmpty((Collection)rzdCar.getVacantSeats())) {
            return;
        }
        SeatType placingSeatType = RzdHelper.convertCompartmentTypeToUfs(gender);
        int startNmb = MiscUtil.guarded((Integer)params.getPlacing().getSeatRangeFirst());
        int endNmb = (Integer)MiscUtil.guarded((Object)params.getPlacing().getSeatRangeLast(), (Object)Integer.MAX_VALUE);
        int existsSeatsCount = 0;
        for (String seat : rzdCar.getVacantSeats()) {
            String[] seatArr = seat.split("\\D");
            String nmbStr = seatArr[0];
            int nmb = Integer.valueOf(nmbStr);
            if (nmb < startNmb || nmb > endNmb) continue;
            String seatTypeStr = seat.substring(nmbStr.length());
            SeatType seatType = SeatType.getByValue(seatTypeStr);
            if (seatType == SeatType.WHOLE || seatType == placingSeatType) {
                ++existsSeatsCount;
            }
            if (existsSeatsCount < needSeatsCount) continue;
            break;
        }
        if (existsSeatsCount < needSeatsCount) {
            throw Xeption.forEndUser((String)String.format("\u0412 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 [%s-%s] \u043d\u0435\u0442 %s '%s'-\u043c\u0435\u0441\u0442", params.getPlacing().getSeatRangeFirst(), params.getPlacing().getSeatRangeLast(), needSeatsCount, placingSeatType.getValue()), (Object[])new Object[0]);
        }
    }
}

