/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperProvider;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.BooleanUtils;

public class RzdReservationCreationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdReservationCreationWrapperProvider params = (RzdReservationCreationWrapperProvider)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_CREATE_RESERVATION_PARAMETERS);
        List reservations = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusMidofficeContextKeys.RESERVATIONS, ArrayList::new);
        boolean isSimulate = Boolean.TRUE.equals(ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_IS_SIMULATE));
        ArrayList<Message> messages = new ArrayList<Message>();
        Reservation reservation = this.createReservation(params, isSimulate, messages);
        ctx.addMessages(messages);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043e", (Object[])new Object[0]));
        Reservation prevReservation = reservations.isEmpty() ? null : (Reservation)reservations.get(reservations.size() - 1);
        reservation.setPreviousReservation(prevReservation);
        reservations.add(reservation);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private Reservation createReservation(RzdReservationCreationWrapperProvider params, boolean isSimulate, List<Message> messages) throws Exception {
        Reservation reservation = new Reservation();
        EntityContainer accountCtr = EntityStorage.get().resolve(params.getGdsAccount());
        reservation.getGdsNameInfo().setOnlineGdsAccount(accountCtr.toReference());
        if (TextUtil.nonBlank((String)params.getRecordLocator())) {
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)((BaseGdsAccount)accountCtr.getEntity()).getGds(), (RecordLocatorType)RecordLocatorType.DEFAULT, (String)params.getRecordLocator());
        }
        if (isSimulate) {
            ReservationGdsNameInfoHelper.setRulesGdsNameFromAccount((Reservation)reservation, (EntityContainer)accountCtr);
        }
        reservation.setResDate(params.getCreateDate());
        reservation.setTimeLimit(params.getTimelimit());
        reservation.setSubagency(params.getSubagency());
        reservation.setSalesPoint(params.getSalesPoint());
        reservation.setBookingAgent(params.getAgent());
        reservation.getAdditionalInfo().getImData().setTrainProvider(params.getTrainProvider());
        for (RzdReservationCreationWrapperProvider.PassengerParamsProvider pparams : params.getPassengers()) {
            Traveller traveller;
            RailwayProduct product = RzdCommonHelper.getProductByBlankId((Reservation)reservation, (String)pparams.getBlankId());
            if (product == null) {
                product = this.createProduct(pparams, params, messages);
                product.setReservation(reservation);
                reservation.getProducts().add(product);
                if (isSimulate) {
                    product.setTicketType(TicketType.FAKE);
                }
            }
            if ((traveller = pparams.getTraveller()) != null) {
                product.getPassengers().add(traveller);
                RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, pparams.getPassengerType());
                continue;
            }
            if (isSimulate) continue;
            this.log.error(String.format("create reservation (pnr=%s) : can't find traveller by passport", params.getRecordLocator()));
        }
        return reservation;
    }

    private RailwayProduct createProduct(RzdReservationCreationWrapperProvider.PassengerParamsProvider pparams, RzdReservationCreationWrapperProvider params, List<Message> messages) throws Exception {
        BigDecimal minPrice;
        Date curDate = new Date();
        BigDecimal priceOriginal = MiscUtil.guarded((BigDecimal)pparams.getPrice());
        BigDecimal equivalentVat = MiscUtil.guarded((BigDecimal)pparams.getEquivalentVat());
        BigDecimal serviceVat = MiscUtil.guarded((BigDecimal)pparams.getServiceVat());
        String gdsCurrency = params.getGdsCurrency();
        RailwayProduct product = new RailwayProduct();
        product.setPaymentType(pparams.getPaymentType());
        product.setBlankId(pparams.getBlankId());
        product.setIbecorpTariff(pparams.getTariff());
        product.setTicketType(TicketType.OWN);
        product.setEticket(true);
        product.setIssueDate(curDate);
        product.setStatus(ProductStatus.BOOKING);
        product.setGdsCurrency(gdsCurrency);
        product.setEquivalentFare(priceOriginal);
        product.setTotalEquivalentFare(priceOriginal);
        RailwayHelper.updateProductVats(product, equivalentVat, pparams.getEquivalentVatRate(), serviceVat, pparams.getServiceVatRate(), messages);
        product.setCarriageAtrs(params.getComfortInfo());
        if (params.getCarriageType() == CarriageType.P) {
            product.setWithBedding(params.getWithBedding());
        }
        EntityReference<SalesPoint> salesPoint = params.getSalesPoint();
        EntityReference<Organization> agency = params.getAgency();
        EntityReference<Organization> blankOwner = params.getBlankOwner();
        EntityReference<Organization> supplier = params.getSupplier();
        RailwayProductHelper.setAgency((BaseTicketProduct)product, agency);
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, params.getSubagency());
        product.setSalesPoint(salesPoint);
        product.setCashier(params.getAgent());
        product.setBlankOwnerRef(blankOwner);
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, supplier);
        Validator validator = RzdHelper.findValidator(salesPoint, agency, blankOwner, supplier);
        if (validator != null) {
            product.setValidatorCode(validator.getNumber());
            product.setValidatorRef(new NestedEntityReference(salesPoint, (BaseEntity)validator));
        } else {
            this.log.error(String.format("Can't find validator for salesPoint %s, agency %s, blankOwner %s, supplier %s", salesPoint, agency, blankOwner, supplier));
        }
        product.setBlankType(RzdHelper.getBlankType("\u0420\u0416\u0414 \u042d\u0411"));
        product.setCarrier(pparams.getPrincipal());
        product.setNonRefundableTariff(pparams.isNonRefundableTariff());
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(1);
        segment.setDepartureStation(params.getDepartureStation());
        segment.setArriveStation(params.getArriveStation());
        segment.setDepartureDate(params.getDepartureDate());
        segment.setTrainDepartureDate(params.getTrainDepartureDate());
        segment.setArriveDate(params.getArriveDate());
        segment.setLocalDepartureDate(params.getLocalDepartureDate());
        segment.setLocalArriveDate(params.getLocalArriveDate());
        segment.setTrainArriveToStationDate(params.geTrainArriveDate());
        segment.setTrainArriveToStationLocalDate(params.getLocalTrainArriveDate());
        RzdHelper.writeFullTrainNumber(segment, params.getTrainNumber());
        segment.setCarriageNumber(params.getCarriageNumber());
        segment.getPlaces().addAll(RailwayHelper.parseSeatNumber(pparams.getSeatNumber()));
        segment.setCarriageType(params.getCarriageType());
        segment.setCompartmentType(params.getCompartmentType());
        segment.setServiceClass(params.getServiceClass());
        segment.getServicesList().addAll(params.getRailServiceList());
        if (pparams.getSegmentFare() != null) {
            BigDecimal segmentFare = pparams.getSegmentFare();
            segment.setEquivalentFare(segmentFare);
            segment.setFare(MoneyHelper.buildMoney((BigDecimal)segmentFare, (String)gdsCurrency));
        }
        segment.setERegEnabled(params.isERegEnabled());
        segment.setHasEReg(params.isHasEReg());
        segment.setCarrier(params.getCarrier());
        segment.setRoute(params.getRoute());
        segment.setTimeInfo(params.getTimeInfo());
        segment.setAddInfo(params.getAddInfo());
        segment.setTrainCategory(params.getTrainCategory());
        if (params.getInternational() != null) {
            segment.setInternational(params.getInternational());
        } else {
            segment.setInternational(this.calcInternational(params.getDepartureStation(), params.getArriveStation()));
        }
        this.fullAdditionInformation(params, segment);
        product.getSegments().add(segment);
        if (pparams.getReservedSeatFare() != null) {
            BigDecimal reservedSeatFare = pparams.getReservedSeatFare();
            ReservedSeat reservedSeat = new ReservedSeat();
            reservedSeat.setSegment(segment);
            reservedSeat.setFare(MoneyHelper.buildMoney((BigDecimal)reservedSeatFare, (String)gdsCurrency));
            reservedSeat.setEquivalentFare(reservedSeatFare);
            reservedSeat.setEquivalentVAT(equivalentVat);
            product.getReservedSeats().add(reservedSeat);
        }
        if ((minPrice = params.getMinPrice()) != null) {
            if (product.getStatisticalData() == null) {
                product.setStatisticalData(new StatisticalData());
            }
            product.getStatisticalData().setMinPriceRailway(minPrice);
        }
        RailwayProductHelper.updateFops((RailwayProduct)product, (boolean)true);
        return product;
    }

    private void fullAdditionInformation(RzdReservationCreationWrapperProvider params, RailwaySegment segment) {
        segment.setDirectionGroup(params.getDirectionGroup());
        segment.setDurationInMinutes(Integer.valueOf(params.getDurationInMinutes()));
        segment.setArrivalLocation(params.getTrainArrivalLocation());
        segment.setDepartureLocation(params.getTrainDepartureLocation());
        segment.setTrainNumberInSearch(params.getTrainNumberInSearch());
        segment.setTrainNumberOriginal(params.getTrainNumberOriginal());
        segment.setBrand(params.getBrand());
        segment.setCarrierRoute(params.getCarrierRoute());
        segment.setCarrierSubcategory(params.getCarrierSubcategory());
        segment.setTwoFloors(Boolean.valueOf(params.isTwoFloors()));
        segment.setSeatsGroupSize(params.getSeatsGroupSize());
        segment.setCarriageTypeTitle(params.getCarriageTypeTitle());
        segment.setSchema(params.getSchema());
        segment.setCarriageCardId((String)Optional.ofNullable(params.getCarriageCardId()).map(Enum::name).orElse(null));
        segment.setProviderCarSchemeId(params.getProviderCarSchemeId());
        segment.setHasNonRefundableTariff(BooleanUtils.toBoolean((Boolean)params.isHasNonRefundableTariff()));
        segment.setServiceDescription(params.getServiceDescription());
        segment.setServiceList(params.getServiceList());
    }

    private Boolean calcInternational(DictionaryReference<RailwayStation> departureStation, DictionaryReference<RailwayStation> arriveStation) {
        return !RzdCommonHelper.isRussiaStation(departureStation) || !RzdCommonHelper.isRussiaStation(arriveStation);
    }
}

