/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.CarriageCardId;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperTrainPriceAbstractProvider;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public abstract class RzdReservationCreationWrapperParamsAbstractProvider
extends RzdReservationCreationWrapperTrainPriceAbstractProvider {
    protected final RzdReservationCreationParameters params;
    protected final RzdBookingSegmentParams segmentParams;
    protected final List<Traveller> travellers;

    public RzdReservationCreationWrapperParamsAbstractProvider(SalesContext salesContext, RzdReservationCreationParameters params, RzdBookingSegmentParams segmentParams, RzdGdsParameters gdsParams, List<Traveller> travellers, EntityReference<Organization> supplier) {
        super(salesContext, segmentParams.getTrain(), segmentParams.getRzdPrice(), gdsParams, supplier);
        this.params = params;
        this.segmentParams = segmentParams;
        this.travellers = travellers;
    }

    @Override
    public List<Traveller> getTravellers() {
        return this.travellers;
    }

    @Override
    public String getCarriageNumber() {
        return this.segmentParams.getRzdCar().getNumber();
    }

    @Override
    public boolean isTwoFloors() {
        return BooleanUtils.isTrue((Boolean)this.segmentParams.getRzdCar().isTwoStoreyed());
    }

    @Override
    public boolean isERegEnabled() {
        return this.segmentParams.getRzdCar().isERegEnabled();
    }

    @Override
    public Boolean getWithBedding() {
        return this.segmentParams.getPlacing().getWithBedding();
    }

    @Override
    public CompartmentType getCompartmentType() {
        return this.segmentParams.getPlacing().getGender();
    }

    @Override
    public boolean isHasEReg() {
        return this.segmentParams.getRzdCar().isERegEnabled();
    }

    @Override
    public String getSchema() {
        return this.segmentParams.getRzdCar().getSchema();
    }

    @Override
    public CarriageCardId getCarriageCardId() {
        return RailwayHelper.findCarriageCardId(this.segmentParams.getRzdPrice(), this.segmentParams.getRzdCar());
    }

    @Override
    public String getProviderCarSchemeId() {
        return this.segmentParams.getRzdCar().getProviderCarSchemeId();
    }

    @Override
    public Boolean isHasNonRefundableTariff() {
        return this.segmentParams.getRzdCar().isHasNonRefundableTariff();
    }

    @Override
    public Date getArriveDate() throws ParseException {
        return (Date)MiscUtil.guarded((Object)this.segmentParams.getRzdCar().getArrivalDatetime(), (Object)super.getArriveDate());
    }

    @Override
    public Date getLocalArriveDate() throws ParseException {
        return (Date)MiscUtil.guarded((Object)this.segmentParams.getRzdCar().getLocalArrivalDatetime(), (Object)super.getLocalArriveDate());
    }

    @Override
    public BigDecimal getMinPrice() {
        return this.segmentParams.getMinPrice();
    }
}

